/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.configuration.impl;

import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.impl.ConfigurationActionEventImpl;
import com.sun.identity.plugin.configuration.impl.ConfigurationInstanceImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceListener;

class ServiceListenerImpl
implements ServiceListener {
    private ConfigurationListener configListener;
    private String componentName;
    private static Debug debug = ConfigurationInstanceImpl.debug;

    ServiceListenerImpl(ConfigurationListener configListener, String componentName) {
        this.configListener = configListener;
        this.componentName = componentName;
    }

    public void schemaChanged(String serviceName, String version) {
        if (debug.messageEnabled()) {
            debug.message("ServiceListenerImpl.schemaChanged: service = " + serviceName);
        }
        ConfigurationActionEventImpl caevent = new ConfigurationActionEventImpl(3, null, this.componentName, null);
        this.configListener.configChanged(caevent);
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("ServiceListenerImpl.organizationConfigChanged: service = " + serviceName);
        }
        ConfigurationActionEventImpl caevent = new ConfigurationActionEventImpl(ServiceListenerImpl.typeMapping(type), serviceComponent, this.componentName, orgName);
        this.configListener.configChanged(caevent);
    }

    private static int typeMapping(int smsType) {
        switch (smsType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return smsType;
    }
}

