/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.identity.monitoring.Monitoring;
import com.sun.identity.monitoring.MonitoringUtils;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_AMMessageLogInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_RemoteServiceAccessPointInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.statistics.CMM_RemoteServiceAccessPointStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceAccessURIStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceStatsInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;

public class MonitoringLogging {
    private static CMM_ServiceInstrum amSvcLogging;
    private static CMM_ServiceInstrum amSvcLoggingPlugin;
    private static CMM_ServiceInstrum amLoggingPluginFlatfile;
    private static CMM_ServiceInstrum amLoggingPluginRdbms;
    private static CMM_RemoteServiceAccessPointInstrum amLoggingRsapRdbmsOracleDest;
    private static CMM_RemoteServiceAccessPointInstrum amLoggingRsapRdbmsMysqlDest;
    private static CMM_RemoteServiceAccessPointInstrum amLoggingRsapCertdbDest;
    private static CMM_ServiceStatsInstrum amLoggingSvcStats;
    private static CMM_ServiceAccessURIStatsInstrum amLoggingSvcUriStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amLoggingRsapRdbmsOracleStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amLoggingRsapRdbmsMysqlStats;
    private static CMM_RemoteServiceAccessPointStatsInstrum amLoggingRsapCertdbStats;
    private static CMM_ServiceAccessURIInstrum amLoggingSvcUri;
    private static CMM_ServiceAccessURIInstrum amLoggingJaxrpcUri;
    private static CMM_AMMessageLogInstrum amLoggingMsgLog;

    private MonitoringLogging() {
    }

    protected static int createLogging(MfManagedElementServer mfMEServer, CMM_ApplicationSystemInstrum amAppli) {
        try {
            MfManagedElementInfo meInfo = mfMEServer.makeManagedElementInfo();
            MfRelationInfo relInfo = mfMEServer.makeRelationInfo();
            MfRelationInstrum mRI = null;
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("logging");
            relInfo.setType(MfRelationType.CMM_HOSTED_SERVICE);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSvcLogging = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("logging plugins");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcLogging, relInfo, meInfo);
            amSvcLoggingPlugin = (CMM_ServiceInstrum)mRI.getDestination();
            Monitoring.debug.message("MonitoringLogging:createLogging:Flatfile");
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("flatfile");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcLoggingPlugin, relInfo, meInfo);
            amLoggingPluginFlatfile = (CMM_ServiceInstrum)mRI.getDestination();
            Monitoring.debug.message("MonitoringLogging:createLogging:RDBMS");
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("rdbms");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcLoggingPlugin, relInfo, meInfo);
            amLoggingPluginRdbms = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("CertDB keystore");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amLoggingRsapCertdbDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amLoggingRsapCertdbDest, relInfo, (CIM_ManagedElementInstrum)amSvcLogging);
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("Oracle rdbms");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amLoggingRsapRdbmsOracleDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amLoggingRsapRdbmsOracleDest, relInfo, (CIM_ManagedElementInstrum)amLoggingPluginRdbms);
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT);
            meInfo.setName("MySQL rdbms");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amLoggingRsapRdbmsMysqlDest = (CMM_RemoteServiceAccessPointInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_SAP_DEPENDENCY);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amLoggingRsapRdbmsMysqlDest, relInfo, (CIM_ManagedElementInstrum)amLoggingPluginRdbms);
            Monitoring.debug.message("MonitoringLogging:createLogging:Service Access URI");
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("logging service URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amLoggingSvcUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amLoggingSvcUri.setLabeledURI("%protocol://%host:%port/amserver/loggingservice");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcLogging, relInfo, (CIM_ManagedElementInstrum)amLoggingSvcUri);
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcLogging, relInfo, (CIM_ManagedElementInstrum)Monitoring.getAMJAXRPCURI());
            Monitoring.debug.message("MonitoringLogging:createLogging:stats");
            meInfo.setType(MfManagedElementType.CMM_SERVICE_STATS);
            meInfo.setName("logging rqt");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcLogging, relInfo, meInfo);
            amLoggingSvcStats = (CMM_ServiceStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("logging service URI stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amLoggingSvcUri, relInfo, meInfo);
            amLoggingSvcUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("logging service Oracle RDBMS stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amLoggingRsapRdbmsOracleDest, relInfo, meInfo);
            amLoggingRsapRdbmsOracleStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("logging service MySQL RDBMS stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amLoggingRsapRdbmsMysqlDest, relInfo, meInfo);
            amLoggingRsapRdbmsMysqlStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_REMOTE_SERVICE_ACCESS_POINT_STATS);
            meInfo.setName("logging service Certificate DB KeyStore stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amLoggingRsapCertdbDest, relInfo, meInfo);
            amLoggingRsapCertdbStats = (CMM_RemoteServiceAccessPointStatsInstrum)mRI.getDestination();
            Monitoring.debug.message("MonitoringLogging:createLogging:init stats");
            MonitoringLogging.initStats();
        }
        catch (MfManagedElementServerException mmese) {
            Monitoring.debug.error("createLogging: " + mmese.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            Monitoring.debug.error("createLogging: " + mrie.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("createLogging:from initStats(): " + mmeie.getMessage());
        }
        return 0;
    }

    public static void initAttributes() {
    }

    private static void initStats() throws MfManagedElementInstrumException {
        MonitoringUtils.initSvcUriStats(amLoggingSvcUriStats, "logging");
        MonitoringUtils.initSvcStats(amLoggingSvcStats, "logging");
        Monitoring.debug.message("MonitoringLogging:createLogging:initStats for Rsaps");
        MonitoringUtils.initRsapStats(amLoggingRsapRdbmsOracleStats, "logging Oracle rdbms");
        MonitoringUtils.setRsapOperationalStatus(amLoggingRsapRdbmsOracleDest, OperationalStatus.OK, "logging Oracle rdbms");
        MonitoringUtils.initRsapStats(amLoggingRsapRdbmsMysqlStats, "logging MySQL rdbms");
        MonitoringUtils.setRsapOperationalStatus(amLoggingRsapRdbmsMysqlDest, OperationalStatus.OK, "logging MySQL rdbms");
        MonitoringUtils.initRsapStats(amLoggingRsapCertdbStats, "logging CertDB");
        MonitoringUtils.setRsapOperationalStatus(amLoggingRsapCertdbDest, OperationalStatus.OK, "logging CertDB");
    }

    public static void setStatus(OperationalStatus status) {
        if (!Monitoring.isLocal) {
            return;
        }
        HashSet<OperationalStatus> loggingStatus = new HashSet<OperationalStatus>();
        loggingStatus.add(status);
        if (amSvcLogging == null || amSvcLoggingPlugin == null) {
            return;
        }
        try {
            amSvcLogging.setOperationalStatus(loggingStatus);
            amSvcLoggingPlugin.setOperationalStatus(loggingStatus);
            if (amLoggingPluginFlatfile != null) {
                amLoggingPluginFlatfile.setOperationalStatus(loggingStatus);
            }
            if (amLoggingPluginRdbms != null) {
                amLoggingPluginRdbms.setOperationalStatus(loggingStatus);
            }
            if (amLoggingSvcUri != null) {
                amLoggingSvcUri.setOperationalStatus(loggingStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringLogging:setStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:setStatus:error = " + mmeie.getMessage());
        }
    }

    public static void setCertDBStatus(OperationalStatus status) {
        if (!Monitoring.isLocal) {
            return;
        }
        HashSet<OperationalStatus> loggingStatus = new HashSet<OperationalStatus>();
        loggingStatus.add(status);
        if (amLoggingRsapCertdbDest == null) {
            return;
        }
        try {
            amLoggingRsapCertdbDest.setOperationalStatus(loggingStatus);
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringLogging:setCertDBStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:setCertDBStatus:error = " + mmeie.getMessage());
        }
    }

    public static void setDBStatus(String driver, OperationalStatus status) {
        if (!Monitoring.isLocal) {
            return;
        }
        if (driver == null || driver.length() == 0) {
            return;
        }
        boolean isMySQL = true;
        if (driver.toLowerCase().indexOf("oracle") != -1) {
            isMySQL = false;
        }
        HashSet<OperationalStatus> dblogStatus = new HashSet<OperationalStatus>();
        dblogStatus.add(status);
        if (!isMySQL && amLoggingRsapRdbmsOracleDest == null) {
            return;
        }
        if (isMySQL && amLoggingRsapRdbmsMysqlDest == null) {
            return;
        }
        CMM_RemoteServiceAccessPointInstrum tmpRsap = amLoggingRsapRdbmsMysqlDest;
        if (!isMySQL) {
            tmpRsap = amLoggingRsapRdbmsOracleDest;
        }
        try {
            if (status == OperationalStatus.OK) {
                if (!isMySQL) {
                    amLoggingRsapRdbmsOracleDest.setOperationalStatus(dblogStatus);
                } else {
                    amLoggingRsapRdbmsMysqlDest.setOperationalStatus(dblogStatus);
                }
            } else {
                tmpRsap.setOperationalStatus(dblogStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringLogging:setDBStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:setDBStatus:error = " + mmeie.getMessage());
        }
    }

    public static CMM_ServiceStatsInstrum getLoggingSvcStats() {
        return amLoggingSvcStats;
    }

    public static void incrementLogRecords() {
        if (amLoggingSvcStats == null) {
            return;
        }
        try {
            amLoggingSvcStats.addInRequests(1L);
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:incrementLogRecords:error = " + mmeie.getMessage());
        }
    }

    public static void incrementDBConnections(String driver, boolean successful) {
        if (driver == null || driver.length() == 0) {
            return;
        }
        boolean isMySQL = true;
        if (driver.toLowerCase().indexOf("oracle") != -1) {
            isMySQL = false;
        }
        if (!isMySQL && amLoggingRsapRdbmsOracleStats == null) {
            return;
        }
        if (isMySQL && amLoggingRsapRdbmsMysqlStats == null) {
            return;
        }
        CMM_RemoteServiceAccessPointStatsInstrum tmpRsap = amLoggingRsapRdbmsMysqlStats;
        if (!isMySQL) {
            tmpRsap = amLoggingRsapRdbmsOracleStats;
        }
        try {
            if (successful) {
                tmpRsap.addConnectionsCount(1L);
            } else {
                tmpRsap.addFailedConnectionsCount(1L);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:incrementDBConnections:driver = " + driver + ", successful = " + successful + ", error = " + mmeie.getMessage());
        }
    }

    public static void incrementDBRequests(String driver, boolean successful, long count) {
        if (driver == null || driver.length() == 0) {
            return;
        }
        boolean isMySQL = true;
        if (driver.toLowerCase().indexOf("oracle") != -1) {
            isMySQL = false;
        }
        if (!isMySQL && amLoggingRsapRdbmsOracleStats == null) {
            return;
        }
        if (isMySQL && amLoggingRsapRdbmsMysqlStats == null) {
            return;
        }
        CMM_RemoteServiceAccessPointStatsInstrum tmpRsap = amLoggingRsapRdbmsMysqlStats;
        if (!isMySQL) {
            tmpRsap = amLoggingRsapRdbmsOracleStats;
        }
        try {
            if (successful) {
                tmpRsap.addRequestsCount(count);
            } else {
                tmpRsap.addFailedRequestsCount(count);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringLogging:incrementDBRequests:driver = " + driver + ", successful = " + successful + ", count = " + count + ", error = " + mmeie.getMessage());
        }
    }

    protected static CMM_ServiceInstrum getSvcLogging() {
        return amSvcLogging;
    }
}

