/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.Distribution;
import com.sun.cmm.cim.OperationalStatus;
import com.sun.cmm.relations.CMM_ApplicationSystemDependency;
import com.sun.identity.monitoring.MonitoringAuth;
import com.sun.identity.monitoring.MonitoringIdrepo;
import com.sun.identity.monitoring.MonitoringLogging;
import com.sun.identity.monitoring.MonitoringPolicy;
import com.sun.identity.monitoring.MonitoringSession;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_ApplicationSystemSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ApplicationSystemStatsInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementServerFactory;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class Monitoring {
    private static MfManagedElementServer mfMEServer;
    private static MfManagedElementInfo meInfo;
    protected static Debug debug;
    protected static boolean isLocal;
    private static CMM_ApplicationSystemInstrum amAppli;
    private static CMM_ApplicationSystemStatsInstrum amApplstati;
    private static CMM_ApplicationSystemSettingInstrum amApplseti;
    private static CMM_ServiceAccessURIInstrum amJaxrpcUri;
    private static CMM_ApplicationSystemDependency jesAS;
    private static CMM_ApplicationSystemDependency jesWS;
    private static CMM_ApplicationSystemDependency genAS;

    private Monitoring() {
    }

    public static int startMonitoring(String amServerID) {
        if (debug.messageEnabled()) {
            debug.message("Monitoring:startMonitoring: amServerID = " + amServerID);
        }
        isLocal = true;
        try {
            mfMEServer = MfManagedElementServerFactory.makeManagedElementServer();
        }
        catch (Throwable te) {
            debug.error("Monitoring:framework error:cause =  " + te.getCause() + ", message = " + te.getMessage());
            te.printStackTrace();
            return -1;
        }
        debug.message("Monitoring:startMonitoring:Started Managed Element Server");
        Properties configProperties = new Properties();
        Hashtable<String, String> context = new Hashtable<String, String>();
        String tempPort = SystemPropertiesManager.get("com.sun.identity.monitoring.html.port", "3890");
        configProperties.setProperty("ENABLE_HTML_ADAPTOR", "true");
        configProperties.setProperty("HTML_ADAPTOR_PORT", tempPort);
        String pvtConnSvrURL = SystemPropertiesManager.get("com.sun.identity.monitoring.local.conn.server.url", "service:jmx:rmi://");
        configProperties.setProperty("PrivateConnectorServerUrl", pvtConnSvrURL);
        amServerID = "amServer" + amServerID;
        context.put("ProductPrefix", amServerID);
        context.put("ProductCodeName", "am");
        context.put("ProductName", "Federated Access Manager");
        String installDir = SystemPropertiesManager.get("com.iplanet.am.installdir");
        context.put("ProductCollectionId", installDir);
        try {
            mfMEServer.initialize(configProperties, context);
            debug.message("Monitoring:startMonitoring:Initialized Managed Element Svr");
            mfMEServer.start();
            debug.message("Monitoring:startMonitoring:Started Managed Element Svr");
            meInfo = mfMEServer.makeManagedElementInfo();
            meInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM);
            meInfo.setName("amserver");
            amAppli = (CMM_ApplicationSystemInstrum)mfMEServer.createManagedElement(meInfo);
            MfRelationInstrum mRI = null;
            MfRelationInfo relInfo = null;
            meInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM_STATS);
            meInfo.setName("amserver statistics");
            relInfo = mfMEServer.makeRelationInfo();
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amApplstati = (CMM_ApplicationSystemStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_APPLICATION_SYSTEM_SETTING);
            meInfo.setName("amserver settings");
            relInfo = mfMEServer.makeRelationInfo();
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amApplseti = (CMM_ApplicationSystemSettingInstrum)mRI.getDestination();
            String proto = SystemPropertiesManager.get("com.iplanet.am.server.protocol");
            String host = SystemPropertiesManager.get("com.iplanet.am.server.host");
            String port = SystemPropertiesManager.get("com.iplanet.am.server.port");
            String deploy = SystemPropertiesManager.get("com.iplanet.am.services.deploymentDescriptor");
            StringBuffer amURLb = new StringBuffer(proto);
            amURLb.append("://").append(host).append(":").append(port).append("/").append(deploy);
            amApplseti.setURL(amURLb.toString());
            relInfo = mfMEServer.makeRelationInfo();
            relInfo.setType(MfRelationType.CMM_APPLICATION_SYSTEM_DEPENDENCY);
            String certdbDir = SystemPropertiesManager.get("com.iplanet.am.admin.cli.certdb.dir");
            String containerName = "Other Application Server";
            if (certdbDir != null && certdbDir.length() > 0) {
                if (certdbDir.indexOf("SUNWwbsvr") != -1 || certdbDir.indexOf("webserver") != -1) {
                    containerName = "SUNWwbsvr";
                } else if (certdbDir.indexOf("SUNWappserver") != -1 || certdbDir.indexOf("Applicationserver") != -1) {
                    containerName = "SUNWappserver";
                }
            }
            if (debug.messageEnabled()) {
                debug.message("Monitoring:startMonitoring:containerName = " + containerName);
            }
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("jaxrpc URI");
            relInfo = mfMEServer.makeRelationInfo();
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            MfRelationInstrum am_jaxrpc_uri_rel = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amJaxrpcUri = (CMM_ServiceAccessURIInstrum)am_jaxrpc_uri_rel.getDestination();
            amJaxrpcUri.setLabeledURI("%protocol://%host:%port/amserver/JAXRPC");
            MonitoringAuth.createAuth(mfMEServer, amAppli);
            MonitoringSession.createSession(mfMEServer, amAppli);
            debug.message("Monitoring:startMonitoring:Created Session elements");
            MonitoringIdrepo.createIdrepo(mfMEServer, amAppli);
            debug.message("Monitoring:startMonitoring:Created Idrepo elements");
            MonitoringPolicy.createPolicy(mfMEServer, amAppli);
            debug.message("Monitoring:startMonitoring:Created Policy elements");
            MonitoringLogging.createLogging(mfMEServer, amAppli);
            debug.message("Monitoring:startMonitoring:Created Logging elements");
            amAppli.setDistribution(Distribution.LOCAL);
            amAppli.setPrimaryOwnerName("amadmin");
            HashSet<OperationalStatus> amStatus = new HashSet<OperationalStatus>();
            amStatus.add(OperationalStatus.OK);
            amAppli.setOperationalStatus(amStatus);
            amAppli.setDescription("Federated Access Manager");
            amApplstati.setInboundAssociations(0L);
            amApplstati.setOutboundAssociations(0L);
            amApplstati.setRejectedInboundAssociations(0L);
            amApplstati.setFailedOutboundAssociations(0L);
            amApplseti.setDirectoryName("");
            debug.message("Monitoring:startMonitoring:Initializing attributes");
            MonitoringAuth.initAttributes();
            MonitoringSession.initAttributes();
            MonitoringPolicy.initAttributes();
            MonitoringLogging.initAttributes();
            debug.message("Monitoring:startMonitoring:Done initializing attributes");
            CMM_ServiceInstrum authSvc = MonitoringAuth.getSvcAuth();
            CMM_ServiceInstrum logSvc = MonitoringLogging.getSvcLogging();
            CMM_ServiceInstrum sessSvc = MonitoringSession.getSvcSess();
            CMM_ServiceInstrum idrepoSvc = MonitoringIdrepo.getSvcIdrepo();
            CMM_ServiceInstrum policySvc = MonitoringPolicy.getSvcPolicy();
            relInfo.setType(MfRelationType.CMM_SERVICE_SERVICE_DEPENDENCY);
            if (authSvc != null) {
                if (logSvc != null) {
                    mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)logSvc, relInfo, (CIM_ManagedElementInstrum)authSvc);
                }
                if (sessSvc != null) {
                    mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)sessSvc, relInfo, (CIM_ManagedElementInstrum)authSvc);
                }
                if (policySvc != null) {
                    mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)policySvc, relInfo, (CIM_ManagedElementInstrum)authSvc);
                }
            }
            if (logSvc != null) {
                if (sessSvc != null) {
                    mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)sessSvc, relInfo, (CIM_ManagedElementInstrum)logSvc);
                }
                if (policySvc != null) {
                    mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)policySvc, relInfo, (CIM_ManagedElementInstrum)logSvc);
                }
            }
            if (sessSvc != null && policySvc != null) {
                mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)policySvc, relInfo, (CIM_ManagedElementInstrum)sessSvc);
            }
        }
        catch (MfManagedElementServerException mmese) {
            debug.error("startMonitoring: " + mmese.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            debug.error("startMonitoring: " + mmeie.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            debug.error("startMonitoring: " + mrie.getMessage());
        }
        try {
            mfMEServer.publish();
        }
        catch (Exception ex) {
            debug.error("Exception received: " + ex.getMessage(), ex);
            return 1;
        }
        return 0;
    }

    protected static CMM_ServiceAccessURIInstrum getAMJAXRPCURI() {
        return amJaxrpcUri;
    }

    public MfManagedElementServer getMfManagedElementServer() {
        return mfMEServer;
    }

    public static void stopMonitoring() {
        if (debug.messageEnabled()) {
            debug.message("Monitoring:stopMonitoring:mfMEServer active = " + (mfMEServer != null));
        }
        if (amAppli != null) {
            HashSet<OperationalStatus> opStat = new HashSet<OperationalStatus>();
            opStat.add(OperationalStatus.STOPPED);
            try {
                amAppli.setOperationalStatus(opStat);
            }
            catch (MfManagedElementInstrumException meie) {
                debug.error("Monitoring:setting operational status to STOP: " + meie.getMessage());
            }
        }
        if (mfMEServer != null) {
            try {
                mfMEServer.stop();
            }
            catch (MfManagedElementServerException mese) {
                debug.error("Monitoring:error stopping monitoring: " + mese.getMessage());
            }
        }
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance("amMonitoring");
        }
    }
}

