/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.dst;

import com.sun.identity.liberty.ws.dst.DSTException;
import com.sun.identity.liberty.ws.dst.DSTUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DSTQueryItem {
    private String select;
    private boolean includeCommonAttribute;
    private Date changedSince;
    private String itemID = null;
    private String id = null;
    private String nameSpaceURI = null;
    private String prefix = null;

    public DSTQueryItem(String select, String serviceNS) {
        this.select = select;
        this.nameSpaceURI = serviceNS;
    }

    public DSTQueryItem(String select, boolean includeCommonAttribute, Date changedSince, String serviceNS) {
        this.select = select;
        this.includeCommonAttribute = includeCommonAttribute;
        this.changedSince = changedSince;
        this.nameSpaceURI = serviceNS;
    }

    public DSTQueryItem(Element element) throws DSTException {
        NodeList list;
        if (element == null) {
            DSTUtils.debug.error("DSTQueryItem(element):null input");
            throw new DSTException(DSTUtils.bundle.getString("nullInputParams"));
        }
        String elementName = element.getLocalName();
        if (elementName == null || !elementName.equals("QueryItem")) {
            DSTUtils.debug.error("DSTQueryItem(element):Invalid elementName");
            throw new DSTException(DSTUtils.bundle.getString("invalidElement"));
        }
        this.nameSpaceURI = element.getNamespaceURI();
        if (this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryItem(element): Namespace is null");
            throw new DSTException(DSTUtils.bundle.getString("noNameSpace"));
        }
        this.prefix = element.getPrefix();
        this.id = element.getAttribute("id");
        String attr = element.getAttribute("includeCommonAttributes");
        if (attr != null) {
            this.includeCommonAttribute = Boolean.valueOf(attr);
        }
        if ((attr = element.getAttribute("changedSince")) != null && attr.length() != 0) {
            try {
                this.changedSince = DateUtils.stringToDate(attr);
            }
            catch (ParseException ex) {
                DSTUtils.debug.error("DSTQueryItem(element): date can not be parsed.", ex);
            }
        }
        if ((list = element.getElementsByTagNameNS(this.nameSpaceURI, "Select")).getLength() != 1) {
            DSTUtils.debug.error("DSTQueryItem(element): Select is null or more than one select found.");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
        this.select = XMLUtils.getElementValue((Element)list.item(0));
        if (this.select == null) {
            DSTUtils.debug.error("DSTQueryItem(element): Select is null");
            throw new DSTException(DSTUtils.bundle.getString("invalidSelect"));
        }
    }

    public String getSelect() {
        return this.select;
    }

    public String getItemID() {
        return this.itemID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isIncludeCommonAttributes() {
        return this.includeCommonAttribute;
    }

    public Date getChangedSince() {
        return this.changedSince;
    }

    public String getNameSpaceURI() {
        return this.nameSpaceURI;
    }

    public void setNameSpaceURI(String nameSpace) {
        this.nameSpaceURI = nameSpace;
    }

    public void setNameSpacePrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getNameSpacePrefix() {
        return this.prefix;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        if (this.select == null) {
            DSTUtils.debug.error("DSTQueryItem.toString: Select cannot be null");
            return "";
        }
        String tempPrefix = "";
        if (includeNS) {
            if (this.prefix == null) {
                this.prefix = "sis";
            }
            tempPrefix = this.prefix + ":";
        }
        if (declareNS && this.nameSpaceURI == null) {
            DSTUtils.debug.error("DSTQueryItem.toString: Name Space is not defined");
            return "";
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append(tempPrefix).append("QueryItem");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(" includeCommonAttributes=\"");
        if (this.includeCommonAttribute) {
            sb.append("true").append("\"");
        } else {
            sb.append("false").append("\"");
        }
        if (this.itemID != null && this.itemID.length() != 0) {
            sb.append(" itemID=\"").append(this.itemID).append("\"");
        }
        if (this.changedSince != null) {
            sb.append(" changedSince=\"").append(DateUtils.toUTCDateFormat(this.changedSince)).append("\"");
        }
        if (declareNS) {
            sb.append(" xmlns:").append(this.prefix).append("=\"").append(this.nameSpaceURI).append("\"").append(" xmlns=\"").append(this.nameSpaceURI).append("\"");
        }
        sb.append(">").append("<").append(tempPrefix).append("Select").append(">").append(this.appendPrefix(this.select, this.prefix)).append("</").append(tempPrefix).append("Select").append(">").append("</").append(tempPrefix).append("QueryItem").append(">");
        return sb.toString();
    }

    private String appendPrefix(String select, String prefix) {
        if (select.indexOf(":") != -1) {
            return select;
        }
        StringBuffer sb = new StringBuffer(100);
        StringTokenizer st = new StringTokenizer(select, "/");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            temp = "/" + prefix + ":" + temp;
            sb.append(temp);
        }
        return sb.toString();
    }
}

