/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.saml.common.SAMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryResponse {
    private String id = null;
    private Status status = null;
    private List offerings = null;
    private List creds = null;

    public QueryResponse(Element root) throws DiscoveryException {
        String nameSpaceURI;
        if (root == null) {
            DiscoUtils.debug.message("QueryResponse(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = root.getLocalName();
        if (nodeName == null || !nodeName.equals("QueryResponse") || (nameSpaceURI = root.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("QueryResponse(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = root.getAttribute("id");
        NodeList contentnl = root.getChildNodes();
        boolean foundCreds = false;
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("QueryResponse(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("Status")) {
                if (this.status != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("QueryResponse(Element): included more than one Status.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                this.status = DiscoUtils.parseStatus((Element)child);
                continue;
            }
            if (nodeName.equals("ResourceOffering")) {
                if (this.offerings == null) {
                    this.offerings = new ArrayList();
                }
                this.offerings.add(new ResourceOffering((Element)child));
                continue;
            }
            if (nodeName.equals("Credentials")) {
                if (foundCreds) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("QueryResponse(Element): included more than one Credentials.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreElement"));
                }
                foundCreds = true;
                this.parseCreds((Element)child);
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("QueryResponse(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.status == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("QueryResponse(Element): missing Status.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingStatus"));
        }
    }

    private void parseCreds(Element elem) throws DiscoveryException {
        NodeList contentnl = elem.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            SecurityAssertion assertion;
            Node child = contentnl.item(i);
            String nodeName = child.getLocalName();
            if (nodeName == null) continue;
            try {
                assertion = new SecurityAssertion((Element)child);
            }
            catch (SAMLException se) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("QueryResponse(Element): Exception thrown when parsing Credentials:", se);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongCredential"));
            }
            if (this.creds == null) {
                this.creds = new ArrayList();
            }
            this.creds.add(assertion);
        }
    }

    public QueryResponse() {
    }

    public QueryResponse(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public List getResourceOffering() {
        return this.offerings;
    }

    public void setResourceOffering(List offerings) {
        this.offerings = offerings;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List getCredentials() {
        return this.creds;
    }

    public void setCredentials(List credentials) {
        this.creds = credentials;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<QueryResponse xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.status != null) {
            sb.append(this.status.toString());
        }
        if (this.offerings != null) {
            Iterator iter = this.offerings.iterator();
            while (iter.hasNext()) {
                sb.append(((ResourceOffering)iter.next()).toString());
            }
        }
        if (this.creds != null) {
            sb.append("<Credentials xmlns=\"").append("urn:liberty:disco:2003-08").append("\">");
            Iterator iter2 = this.creds.iterator();
            while (iter2.hasNext()) {
                sb.append(iter2.next().toString());
            }
            sb.append("</Credentials>");
        }
        sb.append("</QueryResponse>");
        return sb.toString();
    }
}

