/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.InsertEntry;
import com.sun.identity.liberty.ws.disco.RemoveEntry;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Modify {
    private String id = null;
    private ResourceID resourceID = null;
    private EncryptedResourceID encryptResID = null;
    private List inserts = null;
    private List removes = null;

    public Modify(ResourceID resourceID, List insertEntry, List removeEntry) {
        this.resourceID = resourceID;
        this.inserts = insertEntry;
        this.removes = removeEntry;
    }

    public Modify(EncryptedResourceID resourceID, List insertEntry, List removeEntry) {
        this.encryptResID = resourceID;
        this.inserts = insertEntry;
        this.removes = removeEntry;
    }

    public Modify() {
    }

    public Modify(Element root) throws DiscoveryException {
        String nameSpaceURI;
        if (root == null) {
            DiscoUtils.debug.message("Modify(Element): null input.");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String nodeName = root.getLocalName();
        if (nodeName == null || !nodeName.equals("Modify") || (nameSpaceURI = root.getNamespaceURI()) == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
            DiscoUtils.debug.message("Modify(Element): wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.id = root.getAttribute("id");
        NodeList contentnl = root.getChildNodes();
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            nameSpaceURI = ((Element)child).getNamespaceURI();
            if (nameSpaceURI == null || !nameSpaceURI.equals("urn:liberty:disco:2003-08")) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("Modify(Element): invalid namespace for node " + nodeName);
                }
                throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
            }
            if (nodeName.equals("ResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Modify(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                this.resourceID = new ResourceID((Element)child);
                continue;
            }
            if (nodeName.equals("EncryptedResourceID")) {
                if (this.resourceID != null || this.encryptResID != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("Modify(Element): Included more than one ResourceIDGroup element.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreResourceIDGroup"));
                }
                this.encryptResID = new EncryptedResourceID((Element)child);
                continue;
            }
            if (nodeName.equals("InsertEntry")) {
                if (this.inserts == null) {
                    this.inserts = new ArrayList();
                }
                this.inserts.add(new InsertEntry((Element)child));
                continue;
            }
            if (nodeName.equals("RemoveEntry")) {
                if (this.removes == null) {
                    this.removes = new ArrayList();
                }
                this.removes.add(new RemoveEntry(((Element)child).getAttribute("entryID")));
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Modify(Element): invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.resourceID == null && this.encryptResID == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("Modify(Element): missing ResourceID or EncryptedResourceID element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingResourceIDGroup"));
        }
    }

    public EncryptedResourceID getEncryptedResourceID() {
        return this.encryptResID;
    }

    public void setEncryptedResourceID(EncryptedResourceID value) {
        this.encryptResID = value;
    }

    public ResourceID getResourceID() {
        return this.resourceID;
    }

    public void setResourceID(ResourceID resourceID) {
        this.resourceID = resourceID;
    }

    public String getId() {
        return this.id;
    }

    public List getRemoveEntry() {
        return this.removes;
    }

    public void setRemoveEntry(List removes) {
        this.removes = removes;
    }

    public List getInsertEntry() {
        return this.inserts;
    }

    public void setInsertEntry(List inserts) {
        this.inserts = inserts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(1200);
        sb.append("<Modify xmlns=\"").append("urn:liberty:disco:2003-08").append("\"");
        if (this.id != null && this.id.length() != 0) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        if (this.resourceID != null) {
            sb.append(this.resourceID.toString());
        } else if (this.encryptResID != null) {
            sb.append(this.encryptResID.toString());
        }
        if (this.inserts != null) {
            Iterator iter = this.inserts.iterator();
            while (iter.hasNext()) {
                sb.append(((InsertEntry)iter.next()).toString());
            }
        }
        if (this.removes != null) {
            Iterator iter1 = this.removes.iterator();
            while (iter1.hasNext()) {
                sb.append(((RemoveEntry)iter1.next()).toString());
            }
        }
        sb.append("</Modify>");
        return sb.toString();
    }
}

