/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.util.ProviderManager;
import com.sun.identity.liberty.ws.util.ProviderUtil;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xmlenc.XMLEncryptionManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EncryptedResourceID {
    private Element data = null;
    private Element key = null;
    private String namespaceURI = null;

    public EncryptedResourceID() {
    }

    public EncryptedResourceID(Element elem) throws DiscoveryException {
        this.init(elem, "urn:liberty:disco:2003-08");
    }

    public EncryptedResourceID(Element elem, String nspaceURI) throws DiscoveryException {
        this.init(elem, nspaceURI);
    }

    private void init(Element elem, String nspaceURI) throws DiscoveryException {
        if (elem == null) {
            DiscoUtils.debug.message("EncryptedResourceID(Element):null input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        String nameSpaceURI = null;
        tag = elem.getLocalName();
        if (tag == null || !tag.equals("EncryptedResourceID") || (nameSpaceURI = elem.getNamespaceURI()) == null || !nameSpaceURI.equals(nspaceURI)) {
            DiscoUtils.debug.message("EncryptedResourceID(Ele):wrong input");
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        this.namespaceURI = nspaceURI;
        NodeList contentnl = elem.getChildNodes();
        String nodeName = null;
        int length = contentnl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = contentnl.item(i);
            nodeName = child.getLocalName();
            if (nodeName == null) continue;
            if (nodeName.equals("EncryptedData")) {
                if (this.data != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("EncryptedResourceID(Element):Included more than one EncryptedData.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreEncryptedData"));
                }
                this.data = (Element)child;
                continue;
            }
            if (nodeName.equals("EncryptedKey")) {
                if (this.key != null) {
                    if (DiscoUtils.debug.messageEnabled()) {
                        DiscoUtils.debug.message("EncryptedResourceID(Element):Included more than one EncryptedKey.");
                    }
                    throw new DiscoveryException(DiscoUtils.bundle.getString("moreEncryptedKey"));
                }
                this.key = (Element)child;
                continue;
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("EncryptedResourceID(Element):invalid node" + nodeName);
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("wrongInput"));
        }
        if (this.data == null) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("EncryptedResourceID(Element): missing EncryptedData element.");
            }
            throw new DiscoveryException(DiscoUtils.bundle.getString("missingEncryptedData"));
        }
    }

    public EncryptedResourceID(Element encryptedData, Element encryptedKey) {
        this.data = encryptedData;
        this.key = encryptedKey;
    }

    public void setEncryptedData(Element data) {
        this.data = data;
    }

    public Element getEncryptedData() {
        return this.data;
    }

    public Element getEncryptedKey() {
        return this.key;
    }

    public void setEncryptedKey(Element key) {
        this.key = key;
    }

    public static ResourceID getDecryptedResourceID(EncryptedResourceID eri, String providerID) throws DiscoveryException {
        if (eri == null || providerID == null) {
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        ResourceID result = null;
        try {
            XMLEncryptionManager manager = XMLEncryptionManager.getInstance();
            Document encDoc = XMLUtils.toDOMDocument(eri.toString(), DiscoUtils.debug);
            Document decryptDoc = manager.decryptAndReplace(encDoc, ProviderUtil.getProviderManager().getDecryptionKey(providerID));
            Element riEl = (Element)decryptDoc.getElementsByTagNameNS("urn:liberty:disco:2003-08", "ResourceID").item(0);
            result = new ResourceID(riEl);
        }
        catch (Exception e) {
            DiscoUtils.debug.error("EncryptedResourceID.getDecryptedResourceID: decryption exception:", e);
            throw new DiscoveryException(e);
        }
        return result;
    }

    public static EncryptedResourceID getEncryptedResourceID(ResourceID ri, String providerID) throws DiscoveryException {
        if (ri == null || providerID == null) {
            DiscoUtils.debug.error("EncryptedResourceID.getEncryptedResourceID: null input value");
            throw new DiscoveryException(DiscoUtils.bundle.getString("nullInput"));
        }
        EncryptedResourceID eri = null;
        try {
            ProviderManager pm = ProviderUtil.getProviderManager();
            Document doc = XMLUtils.toDOMDocument(ri.toString(), DiscoUtils.debug);
            XMLEncryptionManager manager = XMLEncryptionManager.getInstance();
            Document encDoc = manager.encryptAndReplaceResourceID(doc, doc.getDocumentElement(), pm.getEncryptionKeyAlgorithm(providerID), pm.getEncryptionKeyStrength(providerID), pm.getEncryptionKey(providerID), 0, providerID);
            eri = new EncryptedResourceID(encDoc.getDocumentElement());
        }
        catch (Exception e) {
            DiscoUtils.debug.error("EncryptedResourceID.getEncryptedResourceID: encryption exception:", e);
            throw new DiscoveryException(e);
        }
        return eri;
    }

    public String toString() {
        return this.toString(this.namespaceURI);
    }

    public String toString(String ns) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<EncryptedResourceID xmlns=\"").append(ns).append("\">");
        if (this.data != null) {
            sb.append(XMLUtils.print(this.data));
        }
        if (this.key != null) {
            sb.append(XMLUtils.print(this.key));
        }
        sb.append("</EncryptedResourceID>");
        return sb.toString();
    }
}

