/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco;

import com.sun.identity.liberty.ws.common.LogUtil;
import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.common.DiscoConstants;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptedResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyResponseElement;
import com.sun.identity.liberty.ws.disco.jaxb.ModifyType;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.StatusType;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.interfaces.Authorizer;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.ProviderHeader;
import com.sun.identity.liberty.ws.soapbinding.RequestHandler;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DiscoveryService
implements RequestHandler {
    public DiscoveryService() {
        DiscoUtils.debug.message("In DiscoveryService constructor.");
    }

    public Message processRequest(Message request) throws Exception {
        Set authnMechs;
        List bodies = request.getBodies();
        if ((bodies = Utils.convertElementToJAXB(bodies)).size() != 1) {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAP message didn't contain one SOAP body.");
            throw new Exception(DiscoUtils.bundle.getString("oneBody"));
        }
        String authnMech = request.getAuthenticationMechanism();
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("DiscoService.processRequest: authentication mechanism =" + authnMech);
        }
        if ((authnMechs = DiscoServiceManager.getSupportedAuthenticationMechanisms()) == null || !authnMechs.contains(authnMech)) {
            DiscoUtils.debug.error("DiscoService.processRequest: AuthenticationMechanism used is not supported by this service:" + authnMech);
            throw new Exception(DiscoUtils.bundle.getString("authnMechNotSupported"));
        }
        Message message = null;
        ProviderHeader provH = null;
        try {
            provH = new ProviderHeader(DiscoServiceManager.getDiscoProviderID());
        }
        catch (SOAPBindingException sbe) {
            throw new DiscoveryException(sbe.getMessage());
        }
        if (DiscoServiceManager.useResponseAuthentication() || authnMech.equals("urn:liberty:security:2003-08:null:X509") || authnMech.equals("urn:liberty:security:2003-08:null:SAML") || authnMech.equals("urn:liberty:security:2004-04:null:Bearer") || authnMech.equals("urn:liberty:security:2003-08:TLS:X509") || authnMech.equals("urn:liberty:security:2003-08:TLS:SAML") || authnMech.equals("urn:liberty:security:2004-04:TLS:Bearer") || authnMech.equals("urn:liberty:security:2003-08:ClientTLS:X509") || authnMech.equals("urn:liberty:security:2003-08:ClientTLS:SAML") || authnMech.equals("urn:liberty:security:2004-04:ClientTLS:Bearer") || authnMech.equals("urn:liberty:security:2005-02:null:X509") || authnMech.equals("urn:liberty:security:2005-02:null:SAML") || authnMech.equals("urn:liberty:security:2005-02:null:Bearer") || authnMech.equals("urn:liberty:security:2005-02:TLS:X509") || authnMech.equals("urn:liberty:security:2005-02:TLS:SAML") || authnMech.equals("urn:liberty:security:2005-02:TLS:Bearer") || authnMech.equals("urn:liberty:security:2005-02:ClientTLS:X509") || authnMech.equals("urn:liberty:security:2005-02:ClientTLS:SAML") || authnMech.equals("urn:liberty:security:2005-02:ClientTLS:Bearer")) {
            try {
                SecurityTokenManager stm = new SecurityTokenManager(request.getToken());
                BinarySecurityToken binaryToken = stm.getX509CertificateToken();
                binaryToken.setWSFVersion(request.getWSFVersion());
                message = new Message(provH, binaryToken);
                message.setWSFVersion(request.getWSFVersion());
            }
            catch (Exception e) {
                DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message with X509 token: ", e);
                throw new DiscoveryException(e.getMessage());
            }
        }
        try {
            message = new Message(provH);
        }
        catch (Exception e) {
            DiscoUtils.debug.error("DiscoveryService.processRequest:couldn't generate Message: ", e);
            throw new DiscoveryException(e.getMessage());
        }
        Object body = bodies.iterator().next();
        if (body instanceof QueryType) {
            message.setSOAPBody(this.lookup((QueryType)body, request));
        } else if (body instanceof ModifyType) {
            message.setSOAPBody(Utils.convertJAXBToElement(this.update((ModifyType)body, request)));
        } else {
            DiscoUtils.debug.error("DiscoService.processRequest: SOAPBody is not a Disco message.");
            throw new Exception(DiscoUtils.bundle.getString("bodyNotDisco"));
        }
        return message;
    }

    private Element lookup(QueryType query, Message message) throws JAXBException {
        DiscoUtils.debug.message("in lookup.");
        Status status = new Status("urn:liberty:disco:2003-08", "disco");
        QueryResponse resp = new QueryResponse(status);
        String providerID = DiscoServiceManager.getDiscoProviderID();
        String resourceID = null;
        ResourceIDType resID = query.getResourceID();
        resourceID = resID == null ? this.getResourceID(query.getEncryptedResourceID(), providerID) : resID.getValue();
        DiscoEntryHandler entryHandler = null;
        String userDN = null;
        boolean isB2E = false;
        if (resourceID != null && resourceID.equals("urn:liberty:isf:implied-resource")) {
            DiscoUtils.debug.message("DiscoveryService.lookup: in B2E case");
            isB2E = true;
        }
        if (!isB2E) {
            ResourceIDMapper idMapper = DiscoServiceManager.getResourceIDMapper(providerID);
            if (idMapper == null) {
                idMapper = DiscoServiceManager.getDefaultResourceIDMapper();
            }
            if ((userDN = idMapper.getUserID(providerID, resourceID, message)) == null) {
                DiscoUtils.debug.error("DiscoService.lookup: couldn't find the user associated with the resourceID:" + resourceID);
                status.setCode(DiscoConstants.QNAME_FAILED);
                Document doc = null;
                try {
                    doc = XMLUtils.newDocument();
                }
                catch (Exception ex) {
                    DiscoUtils.debug.error("DiscoService.lookup:", ex);
                }
                DiscoUtils.getDiscoMarshaller().marshal((Object)resp, (Node)doc);
                return doc.getDocumentElement();
            }
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: userDN=" + userDN);
            }
            entryHandler = DiscoServiceManager.getDiscoEntryHandler();
        } else {
            entryHandler = DiscoServiceManager.getGlobalEntryHandler();
        }
        if (entryHandler == null) {
            status.setCode(DiscoConstants.QNAME_FAILED);
            DiscoUtils.debug.message("DiscoService.lookup: null DiscoEntryHandler.");
            return XMLUtils.toDOMDocument(resp.toString(), null).getDocumentElement();
        }
        Map discoEntriesMap = entryHandler.getDiscoEntries(userDN, query.getRequestedServiceType());
        Collection results = discoEntriesMap.values();
        Map returnMap = null;
        if (results.size() == 0) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: lookup NoResults for user:" + userDN);
            }
            status.setCode(DiscoConstants.QNAME_FAILED);
            String[] data = new String[]{userDN};
            LogUtil.error(Level.INFO, "DS_Lookup_Failure", data);
        } else {
            List offerings;
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.lookup: find " + results.size() + "ResourceOfferings for userDN:" + userDN);
            }
            Authorizer authorizer = null;
            if (DiscoServiceManager.needPolicyEvalLookup()) {
                DiscoUtils.debug.message("DiscoService.lookup:needPolicyEval.");
                authorizer = DiscoServiceManager.getAuthorizer();
                if (authorizer == null) {
                    status.setCode(DiscoConstants.QNAME_FAILED);
                    String[] data = new String[]{userDN};
                    LogUtil.error(Level.INFO, "DS_Lookup_Failure", data);
                    return XMLUtils.toDOMDocument(resp.toString(), null).getDocumentElement();
                }
            }
            if ((offerings = (List)(returnMap = DiscoUtils.checkPolicyAndHandleDirectives(userDN, message, results, authorizer, null, null, message.getToken())).get("offerings")).isEmpty()) {
                if (DiscoUtils.debug.messageEnabled()) {
                    DiscoUtils.debug.message("DiscoService.lookup: after policy check and directive handling, NoResults for:" + userDN);
                }
                status.setCode(DiscoConstants.QNAME_FAILED);
                String[] data = new String[]{userDN};
                LogUtil.error(Level.INFO, "DS_Lookup_Failure", data);
            } else {
                resp.setResourceOffering(offerings);
                DiscoUtils.debug.message("after resp.getresoff.addall");
                List credentials = (List)returnMap.get("credentials");
                if (credentials != null && !credentials.isEmpty()) {
                    DiscoUtils.debug.message("DiscoService.lookup: has cred.");
                    resp.setCredentials(credentials);
                }
                status.setCode(DiscoConstants.QNAME_OK);
                String[] data = new String[]{userDN};
                LogUtil.access(Level.INFO, "DS_Lookup_Success", data);
            }
        }
        return XMLUtils.toDOMDocument(resp.toString(), null).getDocumentElement();
    }

    private ModifyResponseElement update(ModifyType modify, Message message) throws JAXBException {
        Map results;
        String statusCode;
        DiscoUtils.debug.message("in update.");
        ModifyResponseElement resp = null;
        StatusType status = null;
        try {
            resp = DiscoUtils.getDiscoFactory().createModifyResponseElement();
            status = DiscoUtils.getDiscoFactory().createStatusType();
            resp.setStatus(status);
        }
        catch (JAXBException je) {
            DiscoUtils.debug.error("DiscoService.update: couldn't form ModifyResponse.");
            throw je;
        }
        String providerID = DiscoServiceManager.getDiscoProviderID();
        String resourceID = null;
        ResourceIDType resID = modify.getResourceID();
        resourceID = resID == null ? this.getResourceID(modify.getEncryptedResourceID(), providerID) : resID.getValue();
        DiscoEntryHandler entryHandler = null;
        String userDN = null;
        boolean isB2E = false;
        String logMsg = null;
        if (resourceID != null && resourceID.equals("urn:liberty:isf:implied-resource")) {
            DiscoUtils.debug.message("DiscoveryService.lookup: in B2E case");
            isB2E = true;
        }
        if (!isB2E) {
            ResourceIDMapper idMapper = DiscoServiceManager.getResourceIDMapper(providerID);
            if (idMapper == null) {
                idMapper = DiscoServiceManager.getDefaultResourceIDMapper();
            }
            userDN = idMapper.getUserID(providerID, resourceID, message);
            logMsg = DiscoUtils.bundle.getString("messageID") + "=" + message.getCorrelationHeader().getMessageID() + "." + DiscoUtils.bundle.getString("providerID") + "=" + providerID + "." + DiscoUtils.bundle.getString("securityMechID") + "=" + message.getAuthenticationMechanism() + "." + DiscoUtils.bundle.getString("resourceOfferingID") + "=" + resourceID + "." + DiscoUtils.bundle.getString("operation") + "=" + "Update";
            if (userDN == null) {
                DiscoUtils.debug.error("DiscoService.update: couldn't find user from resourceID: " + resourceID);
                status.setCode(DiscoConstants.QNAME_FAILED);
                String[] data = new String[]{resourceID};
                LogUtil.error(Level.INFO, "DS_Update_Failure", data);
                return resp;
            }
            entryHandler = DiscoServiceManager.getDiscoEntryHandler();
        } else {
            entryHandler = DiscoServiceManager.getGlobalEntryHandler();
        }
        if (DiscoServiceManager.needPolicyEvalUpdate()) {
            DiscoUtils.debug.message("DiscoService.lookup: needPolicyEval.");
            if (!this.isUpdateAllowed(userDN, message, modify.getRemoveEntry(), modify.getInsertEntry(), entryHandler, DiscoServiceManager.getAuthorizer())) {
                status.setCode(DiscoConstants.QNAME_FAILED);
                String[] data = new String[]{userDN};
                LogUtil.error(Level.INFO, "DS_Update_Failure", data);
                return resp;
            }
        }
        if ((statusCode = (String)(results = entryHandler.modifyDiscoEntries(userDN, modify.getRemoveEntry(), modify.getInsertEntry())).get("STATUS_CODE")).equals("OK")) {
            if (DiscoUtils.debug.messageEnabled()) {
                DiscoUtils.debug.message("DiscoService.update: modified DiscoEntries through DiscoEntryHandler successfully.");
            }
            status.setCode(DiscoConstants.QNAME_OK);
            List entryIds = (List)results.get("newEntryIDs");
            if (entryIds != null && entryIds.size() != 0) {
                resp.getNewEntryIDs().addAll(entryIds);
            }
            String[] data = new String[]{logMsg};
            LogUtil.access(Level.INFO, "DS_Update_Success", data);
        } else {
            DiscoUtils.debug.error("DiscoService.update: couldn't modify DiscoEntries through DiscoEntryHandler.");
            status.setCode(DiscoConstants.QNAME_FAILED);
            String[] data = new String[]{logMsg};
            LogUtil.error(Level.INFO, "DS_Update_Failure", data);
        }
        return resp;
    }

    private boolean isUpdateAllowed(String userDN, Message message, List removes, List inserts, DiscoEntryHandler entryHandler, Authorizer authorizer) {
        DiscoUtils.debug.message("DiscoService.isUpdateAllowed.");
        if (authorizer == null) {
            return false;
        }
        HashMap<String, Object> env = null;
        if (removes != null && removes.size() != 0) {
            Map entryMap = entryHandler.getDiscoEntries(userDN, null);
            Iterator i = removes.iterator();
            String entryID = null;
            while (i.hasNext()) {
                entryID = ((RemoveEntryType)i.next()).getEntryID();
                if (!entryMap.containsKey(entryID)) {
                    DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: remove entry not exits: " + entryID);
                    return false;
                }
                if (env == null) {
                    env = new HashMap();
                    env.put("userID", userDN);
                    env.put("authType", message.getAuthenticationMechanism());
                    env.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)entryMap.get(entryID)).getResourceOffering(), env)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to remove entry: " + entryID);
                return false;
            }
        }
        if (inserts != null && inserts.size() != 0) {
            Iterator j = inserts.iterator();
            while (j.hasNext()) {
                if (env == null) {
                    env = new HashMap<String, Object>();
                    env.put("userID", userDN);
                    env.put("authType", message.getAuthenticationMechanism());
                    env.put("message", message);
                }
                if (authorizer.isAuthorized(message.getToken(), "UPDATE", ((InsertEntryType)j.next()).getResourceOffering(), env)) continue;
                DiscoUtils.debug.error("DiscoveryService.isUpdateAllowed: WSC is not authorized to insert entry.");
                return false;
            }
        }
        return true;
    }

    private String getResourceID(EncryptedResourceIDType encryptResID, String providerID) {
        if (encryptResID == null || providerID == null) {
            return null;
        }
        String result = null;
        try {
            EncryptedResourceID eri = new EncryptedResourceID(Utils.convertJAXBToElement(encryptResID, false));
            ResourceID ri = EncryptedResourceID.getDecryptedResourceID(eri, providerID);
            if (ri != null) {
                result = ri.getResourceID();
            }
        }
        catch (Exception e) {
            DiscoUtils.debug.error("DiscoveryService.getResourceID: Exception:", e);
        }
        return result;
    }
}

