/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.saml.common.SAMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IDPEntries {
    private List idpEntryList = null;
    private List otherElements = null;

    public IDPEntries() {
    }

    public IDPEntries(List idpEntries) {
        this.idpEntryList = idpEntries;
    }

    public List getIDPEntryList() {
        return this.idpEntryList;
    }

    public void setIDPEntryList(List idpEntryList) {
        this.idpEntryList = idpEntryList;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "lib:";
        }
        if (declareNS) {
            uri = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        xml.append("<").append(prefix).append("IDPEntries").append(uri).append(">\n");
        if (this.idpEntryList != null && this.idpEntryList != Collections.EMPTY_LIST) {
            Iterator i = this.idpEntryList.iterator();
            while (i.hasNext()) {
                IDPEntry entry = (IDPEntry)i.next();
                xml.append(entry.toXMLString(true, false));
            }
        }
        xml.append("</").append(prefix).append("IDPEntries>\n");
        return xml.toString();
    }

    public IDPEntries(Element root) throws FSMsgException {
        if (root == null) {
            SAMLUtils.debug.message("IDPEntries.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("IDPEntries")) {
            FSUtils.debug.message("IDPEntries.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null || !childName.equals("IDPEntry")) continue;
            if (this.idpEntryList == null || this.idpEntryList == Collections.EMPTY_LIST) {
                this.idpEntryList = new ArrayList();
            }
            this.idpEntryList.add(new IDPEntry((Element)child));
        }
    }
}

