/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSNameIdentifierMappingResponse
extends AbstractResponse {
    private String providerID;
    private Status status;
    private NameIdentifier nameIdentifier;
    private int minorVersion = 2;
    private String signatureString;

    public FSNameIdentifierMappingResponse(String providerID, String inResponseTo, Status status, NameIdentifier nameIdentifier) throws FSMsgException {
        this.providerID = providerID;
        this.inResponseTo = inResponseTo;
        this.status = status;
        this.nameIdentifier = nameIdentifier;
        this.responseID = FSUtils.generateID();
        this.setIssueInstant(new Date());
    }

    public FSNameIdentifierMappingResponse(Element root) throws FSMsgException {
        if (root == null) {
            FSUtils.debug.message("FSNameIdentifierMappingResponse: null element input");
            throw new FSMsgException("nullInputParameter", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("NameIdentifierMappingResponse")) {
            FSUtils.debug.message("FSNameIdentifierMappingRequest: wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String instantString = root.getAttribute("IssueInstant");
        if (instantString == null || instantString.length() == 0) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse: missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse: could not parse IssueInstant.", e);
            throw new FSMsgException("wrongInput", null);
        }
        this.responseID = root.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.length() < 1) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse: response doesn't have ResponseID");
            Object[] args = new String[]{"ResponseID"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.inResponseTo = root.getAttribute("InResponseTo");
        if (this.inResponseTo == null) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse: response doesn't have InResponseTo");
            Object[] args = new String[]{"InResponseTo"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Status")) {
                try {
                    this.status = new Status((Element)child);
                    continue;
                }
                catch (SAMLException se) {
                    FSUtils.debug.error("FSNameIdentifierMappingResponse: unable to initialize Status", se);
                    throw new FSMsgException("statusCreateError", null, se);
                }
            }
            if (childName.equals("ProviderID")) {
                this.providerID = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (!childName.equals("NameIdentifier")) continue;
            try {
                this.nameIdentifier = new NameIdentifier((Element)child);
                continue;
            }
            catch (SAMLException samle) {
                FSUtils.debug.error("FSNameIdentifierMappingResponse: unable to initialize NameIdentifier", samle);
                throw new FSMsgException("nameIdentifierCreateError", null, samle);
            }
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.signed = true;
        } else if (signsSize != 0) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse: included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public static FSNameIdentifierMappingResponse parseXML(String xml) throws FSMsgException {
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse.parseXML: error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSNameIdentifierMappingResponse(root);
    }

    public String getProviderID() {
        return this.providerID;
    }

    public Status getStatus() {
        return this.status;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    private void parseMajorVersion(String version) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMajorVersion:invalid MajorVersion:" + version, e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMajorVersion: MajorVersion is too high");
                }
                throw new FSMsgException("requestVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMajorVersion: MajorVersion is too low");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String version) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(version);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMinorVersion:invalid MinorVersion:" + version, e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMinorVersion: MinorVersion is too high");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.parseMinorVersion: MinorVersion is too low");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    public void signXML() throws SAMLException {
        String certAlias = SystemConfigurationUtil.getProperty("com.sun.identity.saml.xmlsig.certalias");
        this.signXML(certAlias);
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSNameIdentifierMappingResponse.signXML");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.signXML: the response is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() < 1) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameIdentifierMappingResponse.signXML: null certAlias");
            }
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "ResponseID", this.getResponseID(), false);
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse.signXML: unable to sign", e);
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        String prefixLIB = "";
        String uriLIB = "";
        String uriSAML = "";
        if (includeNS) {
            prefixLIB = "lib:";
        }
        if (declareNS) {
            uriLIB = " xmlns:lib=\"urn:liberty:iff:2003-08\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String instantString = null;
        try {
            instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        }
        catch (Exception e) {
            FSUtils.debug.error("FSNameIdentifierMappingResponse.toXMLString: could not convert issueInstant to String.", e);
        }
        StringBuffer xml = new StringBuffer(1000);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\"").append(" ").append('?').append(">").append("\n");
        }
        xml.append("<").append(prefixLIB).append("NameIdentifierMappingResponse").append(uriLIB).append(uriSAML).append(" ").append("ResponseID").append('=').append("\"").append(this.responseID).append("\"").append(" ").append("InResponseTo").append('=').append("\"").append(this.inResponseTo).append("\"").append(" ").append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append('=').append("\"").append(" ").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append(" ").append("IssueInstant").append('=').append(instantString).append("\"").append(" ").append(">");
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        xml.append("<").append(prefixLIB).append("ProviderID").append(">").append(this.providerID).append("</").append(prefixLIB).append("ProviderID").append(">").append(this.status.toString(includeNS, true));
        if (this.nameIdentifier != null) {
            xml.append(this.nameIdentifier.toString());
        }
        xml.append("</").append(prefixLIB).append("NameIdentifierMappingResponse").append(">");
        return xml.toString();
    }
}

