/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAuthnResponse
extends Response {
    private String providerId = null;
    protected String relayState = null;
    protected String consentURI = null;
    protected int minorVersion = 0;
    protected String id = null;
    protected Element domElement = null;

    public FSAuthnResponse(String responseID, String inResponseTo, Status status, List contents, String relayState) throws SAMLException, FSMsgException {
        super(responseID, inResponseTo, status, contents);
        this.setIssueInstant(new Date());
        this.relayState = relayState;
    }

    public static FSAuthnResponse parseAuthnResponseXML(String xml) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.parseAuthnResponseXML: Called");
        Document doc = XMLUtils.toDOMDocument(xml, FSUtils.debug);
        if (doc == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element root = doc.getDocumentElement();
        return new FSAuthnResponse(root);
    }

    public FSAuthnResponse(Element root) throws SAMLException, FSMsgException {
        String instantString;
        FSUtils.debug.message("FSAuthnResponse(Element): Called");
        if (root == null) {
            FSUtils.debug.message("FSAuthnResponse(Element): Input paramenter (root) is null");
            throw new FSMsgException("nullInput", null);
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("AuthnResponse")) {
            FSUtils.debug.message("FSAuthnResponse(Element): Root element name is not AuthnResponse");
            throw new FSMsgException("wrongInput", null);
        }
        this.domElement = root;
        this.consentURI = root.getAttribute("consent");
        this.id = root.getAttribute("id");
        this.responseID = root.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): AuthnResponse doesn't have ResponseID attribute");
            }
            Object[] args = new String[]{"ResponseID"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.inResponseTo = root.getAttribute("InResponseTo");
        if (this.inResponseTo == null && FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponse(Element): AuthnResponse doesn't have InResponseTo attribute");
        }
        if ((instantString = root.getAttribute("IssueInstant")) == null || instantString.length() == 0) {
            FSUtils.debug.message("FSAuthnResponse(Element):  missing IssueInstant");
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.issueInstant = DateUtils.stringToDate(instantString);
        }
        catch (ParseException e) {
            FSUtils.debug.message("FSAuthnResponse(Element): could not parse IssueInstant", e);
            throw new FSMsgException("wrongInput", null);
        }
        this.parseMajorVersion(root.getAttribute("MajorVersion"));
        this.parseMinorVersion(root.getAttribute("MinorVersion"));
        this.setRecipient(root.getAttribute("Recipient"));
        NodeList nl = root.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Status")) {
                if (this.status != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnResponse(Element): included more than one <Status>");
                    }
                    throw new FSMsgException("moreElement", null);
                }
                this.status = new Status((Element)child);
                continue;
            }
            if (childName.equals("Assertion")) {
                if (this.assertions == Collections.EMPTY_LIST) {
                    this.assertions = new ArrayList();
                }
                this.assertions.add(new FSAssertion((Element)child));
                continue;
            }
            if (childName.equals("RelayState")) {
                if (this.relayState != null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnResponse(Element): should contain only one RelayState.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.relayState = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (childName.equals("ProviderID")) {
                if (this.providerId != null && this.providerId.length() != 0) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAuthnResponse(Element): should contain only one ProviderID.");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                this.providerId = XMLUtils.getElementValue((Element)child);
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): included wrong element: " + childName);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.status == null) {
            FSUtils.debug.message("FSAuthnResponse(Element): missing element <Status>.");
            throw new FSMsgException("missingElement", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1(root, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print(root);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String provId) {
        this.providerId = provId;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public String getConsentURI() {
        return this.consentURI;
    }

    public void setConsentURI(String consent) {
        this.consentURI = consent;
    }

    public Element getDOMElement() {
        return this.domElement;
    }

    private void parseMajorVersion(String majorVer) throws SAMLException, FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(majorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): invalid MajorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnResponse(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooHigh", null);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException("libIDFF", "responseVersionTooLow", null);
        }
    }

    private void parseMinorVersion(String minorVer) throws SAMLException, FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(minorVer);
        }
        catch (NumberFormatException e) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse(Element): invalid MinorVersion", e);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.checkMinorVersion: Minor Version of the AuthnResponse is too high.");
            }
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        if (this.minorVersion < 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.checkMinorVersion: Minor Version of the AuthnResponse is too low.");
            }
            throw new FSMsgException("requestVersionTooLow", null);
        }
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        return this.toXMLString(includeNS, declareNS, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS, boolean includeHeader) throws FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.toXMLString(3): Called");
        if (this.providerId == null || this.providerId.length() == 0) {
            FSUtils.debug.error("FSAuthnResponse.toXMLString: providerId is null ");
            throw new FSMsgException("nullProviderID", null);
        }
        StringBuffer xml = new StringBuffer(300);
        if (includeHeader) {
            xml.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n").append("\"").append('?').append(">").append("\n");
        }
        String prefixSAML = "";
        String prefixLIB = "";
        String prefixSAML_PROTOCOL = "";
        String uriSAML_PROTOCOL = "";
        String uriSAML = "";
        String uriLIB = "";
        String uriDS = "";
        String uriXSI = "";
        if (includeNS) {
            prefixLIB = "lib:";
            prefixSAML = "saml:";
            prefixSAML_PROTOCOL = "samlp:";
        }
        if (declareNS) {
            uriLIB = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriSAML = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            uriSAML_PROTOCOL = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            uriDS = "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"";
            uriXSI = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String instantString = DateUtils.toUTCDateFormat(this.issueInstant);
        if (this.responseID != null && this.inResponseTo != null) {
            xml.append("<").append(prefixLIB).append("AuthnResponse").append(uriLIB).append(uriSAML).append(uriSAML_PROTOCOL).append(" ").append(uriDS).append(" ").append(uriXSI).append(" ").append("ResponseID").append('=').append("\"").append(this.responseID).append("\"").append(" ");
            if (this.inResponseTo != null && this.inResponseTo.length() != 0) {
                xml.append(" ").append("InResponseTo").append('=').append("\"").append(this.inResponseTo).append("\"");
            }
            if (this.minorVersion == 0 && this.id != null && this.id.length() > 0) {
                xml.append(" ").append("id").append('=').append("\"").append(this.id).append("\"");
            }
            xml.append(" ").append("MajorVersion").append('=').append("\"").append(this.majorVersion).append("\"").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append("IssueInstant").append('=').append("\"").append(instantString).append("\"");
            if (this.consentURI != null) {
                xml.append(" ").append("consent").append('=').append("\"").append(this.consentURI).append("\"").append(" ");
            }
            if (this.recipient != null && this.recipient.length() != 0) {
                xml.append(" ").append("Recipient").append('=').append("\"").append(this.recipient).append("\"").append(" ");
            }
            xml.append(">");
        }
        if (this.signed) {
            if (this.signatureString != null && this.signatureString.length() != 0) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        if (this.status != null) {
            xml.append(this.status.toString(includeNS, false));
        }
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator j = this.assertions.iterator();
            while (j.hasNext()) {
                xml.append(((FSAssertion)j.next()).toXMLString(true, declareNS));
            }
        }
        xml.append("<").append(prefixLIB).append("ProviderID").append(">").append(this.providerId).append("</").append(prefixLIB).append("ProviderID").append(">");
        if (this.relayState != null && this.relayState.length() != 0) {
            xml.append("<").append(prefixLIB).append("RelayState").append(">").append(XMLUtils.escapeSpecialCharacters(this.relayState)).append("</").append(prefixLIB).append("RelayState").append(">");
        }
        xml.append("</").append(prefixLIB).append("AuthnResponse").append(">").append("\n");
        return xml.toString();
    }

    public static FSAuthnResponse parseBASE64EncodedString(String encodedRes) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: Called new");
        if (encodedRes != null) {
            String decodedAuthnRes = new String(Base64.decode(encodedRes));
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: Decoded AuthnResponse message: \n" + decodedAuthnRes);
            }
            return FSAuthnResponse.parseAuthnResponseXML(decodedAuthnRes);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponse.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        FSUtils.debug.message("FSAuthnResponse.toBASE64EncodedString: Called");
        if (this.responseID == null || this.responseID.length() == 0) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSAuthnResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        return Base64.encode(this.toXMLString(true, true).getBytes());
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSAuthnResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            throw new SAMLResponderException("libIDFF", "signFailed", null);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print(elem);
        return super.setSignature(elem);
    }
}

