/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAssertion
extends Assertion {
    private Element domElement;
    static SAMLConstants sc;
    protected String id;
    protected int minorVersion = 0;
    private List securityAssertions;
    protected String inResponseTo;

    public FSAssertion(Element assertionElement) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSAssertion(Element):  Called");
        Element elt = assertionElement;
        String eltName = elt.getLocalName();
        if (eltName == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: local name missing");
            }
            throw new FSMsgException("nullInput", null);
        }
        if (!eltName.equals("Assertion")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: invalid root element");
            }
            Object[] args = new String[]{eltName};
            throw new FSMsgException("invalidElement", args);
        }
        this.domElement = assertionElement;
        this.id = elt.getAttribute("id");
        String read = elt.getAttribute("MajorVersion");
        if (read == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: MajorVersion missing");
            }
            Object[] args = new String[]{"MajorVersion"};
            throw new FSMsgException("missingAttribute", args);
        }
        int ver = 0;
        try {
            ver = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            FSUtils.debug.error("FSAssertion: invalid integer in MajorVersion", ne);
            throw new FSMsgException("invalidNumber", null);
        }
        if (ver != 1) {
            if (ver < 1) {
                FSUtils.debug.error("FSAssertion: MajorVersion too low");
                throw new SAMLVersionMismatchException("libIDFF", "assertionVersionTooLow", null);
            }
            if (ver > 1) {
                FSUtils.debug.error("FSAssertion: MajorVersion too high");
                throw new SAMLVersionMismatchException("libIDFF", "assertionVersionTooHigh", null);
            }
        }
        if ((read = elt.getAttribute("MinorVersion")) == null || read.length() == 0) {
            FSUtils.debug.error("FSAssertion: MinorVersion missing");
            Object[] args = new String[]{"MinorVersion"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.minorVersion = Integer.parseInt(read);
        }
        catch (NumberFormatException ne) {
            FSUtils.debug.error("FSAssertion: invalid integer in MinorVersion", ne);
            throw new FSMsgException("invalidNumber", null);
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSAssertion: MinorVersion too low");
            throw new SAMLVersionMismatchException("libIDFF", "assertionVersionTooLow", null);
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSAssertion: MinorVersion too high");
            throw new SAMLVersionMismatchException("libIDFF", "assertionMinorVersionTooHigh", null);
        }
        read = elt.getAttribute("AssertionID");
        if (read == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: AssertionID missing");
            }
            Object[] args = new String[]{"AssertionID"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.setAssertionID(read);
        read = elt.getAttribute("Issuer");
        if (read == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: Issuer missing");
            }
            Object[] args = new String[]{"Issuer"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.setIssuer(read);
        read = elt.getAttribute("InResponseTo");
        if (read == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: InResponseTo missing");
            }
            Object[] args = new String[]{"InResponseTo"};
            throw new FSMsgException("missingAttribute", args);
        }
        this.inResponseTo = read;
        read = elt.getAttribute("IssueInstant");
        if (read == null || read.length() == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: IssueInstant missing");
            }
            Object[] args = new String[]{"IssueInstant"};
            throw new FSMsgException("missingAttribute", args);
        }
        try {
            this.setIssueInstant(DateUtils.stringToDate(read));
        }
        catch (ParseException pe) {
            FSUtils.debug.message("FSAssertion: could not parse IssueInstant", pe);
            throw new FSMsgException("wrongInput", null);
        }
        boolean statementFound = false;
        NodeList nl = assertionElement.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            Node child = nl.item(n);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName.equals("Conditions")) {
                this.setConditions(new Conditions((Element)child));
                continue;
            }
            if (childName.equals("Advice")) {
                this.parseAdvice((Element)child);
                continue;
            }
            if (childName.equals("AuthenticationStatement")) {
                this.addStatement(new FSAuthenticationStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("AuthorizationDecisionStatement")) {
                this.addStatement(new AuthorizationDecisionStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("AttributeStatement")) {
                this.addStatement(new AttributeStatement((Element)child));
                statementFound = true;
                continue;
            }
            if (childName.equals("Signature")) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSAssertion: Signature found");
                continue;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: invalid element in Assertion");
            }
            throw new FSMsgException("invalidElement", null);
        }
        List signs = XMLUtils.getElementsByTagNameNS1(assertionElement, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int signsSize = signs.size();
        if (signsSize == 1) {
            Element elem = (Element)signs.get(0);
            this.setSignature(elem);
            this.xmlString = XMLUtils.print(assertionElement);
            this.signed = true;
        } else if (signsSize != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
        if (!statementFound) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Assertion: mandatory statement missing");
            }
            throw new FSMsgException("missingStatement", null);
        }
        FSUtils.debug.message("FSAssertion(Element): leaving");
    }

    public FSAssertion(String assertionID, String issuer, Date issueInstant, Set statements, String inResponseTo) throws FSMsgException, SAMLException {
        super(assertionID, issuer, issueInstant, statements);
        this.inResponseTo = inResponseTo;
    }

    public FSAssertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Set statements, String inResponseTo) throws FSMsgException, SAMLException {
        super(assertionID, issuer, issueInstant, conditions, statements);
        this.inResponseTo = inResponseTo;
    }

    public FSAssertion(String assertionID, String issuer, Date issueInstant, Conditions conditions, Advice advice, Set statements, String inResponseTo) throws FSMsgException, SAMLException {
        super(assertionID, issuer, issueInstant, conditions, advice, statements);
        this.inResponseTo = inResponseTo;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int version) {
        this.minorVersion = version;
    }

    public Element getDOMElement() {
        return this.domElement;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String inResponseTo) {
        this.inResponseTo = inResponseTo;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public boolean isTimeValid() {
        boolean isTimeValid = true;
        Conditions conditions = this.getConditions();
        if (conditions != null) {
            isTimeValid = conditions.checkDateValidity(System.currentTimeMillis());
        }
        return isTimeValid;
    }

    public boolean addStatement(Statement statement) {
        boolean addedStmt = false;
        if (statement != null) {
            super.addStatement(statement);
            addedStmt = true;
        }
        return addedStmt;
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws FSMsgException {
        StringBuffer xml = new StringBuffer(3000);
        String NS = "";
        String appendNS = "";
        String libNS = "";
        String libAppendNS = "";
        String uriXSI = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            libNS = this.minorVersion == 2 || this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            uriXSI = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        if (includeNS) {
            appendNS = "saml:";
            libAppendNS = "lib:";
        }
        String dateStr = null;
        if (this.getIssueInstant() != null) {
            dateStr = DateUtils.toUTCDateFormat(this.getIssueInstant());
        }
        xml.append("<").append(appendNS).append("Assertion").append(" ").append(NS).append(" ").append(uriXSI).append(" ").append(libNS).append(" ");
        if (this.minorVersion == 0 && this.id != null && this.id.length() != 0) {
            xml.append(" ").append("id").append('=').append("\"").append(this.id).append("\"").append(" ");
        }
        xml.append("MajorVersion").append('=').append("\"").append(this.getMajorVersion()).append("\"").append(" ").append("MinorVersion").append('=').append("\"").append(this.minorVersion).append("\"").append(" ").append("AssertionID").append('=').append("\"").append(this.getAssertionID()).append("\"").append(" ").append("Issuer").append('=').append("\"").append(this.getIssuer()).append("\"").append(" ").append("IssueInstant").append('=').append("\"").append(dateStr).append("\"").append(" ").append("InResponseTo").append('=').append("\"").append(this.inResponseTo).append("\"").append(" ").append("xsi:type").append('=').append("\"").append(libAppendNS).append("AssertionType").append("\"").append(">").append("\n");
        if (this.getConditions() != null) {
            xml.append(this.getConditions().toString(includeNS, false));
        }
        if (this.getAdvice() != null) {
            xml.append(this.getAdvice().toString(includeNS, false));
        }
        Iterator i = this.getStatement().iterator();
        while (i.hasNext()) {
            Statement st = (Statement)i.next();
            if (st instanceof FSAuthenticationStatement) {
                xml.append(((FSAuthenticationStatement)st).toXMLString(includeNS, false));
                continue;
            }
            if (!(st instanceof AttributeStatement)) continue;
            xml.append(((AttributeStatement)st).toString(includeNS, false));
        }
        if (this.signed) {
            if (this.signatureString != null) {
                xml.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                xml.append(this.signatureString);
            }
        }
        xml.append("</").append(appendNS).append("Assertion").append(">").append("\n");
        return xml.toString();
    }

    public void signXML(String certAlias) throws SAMLException {
        FSUtils.debug.message("FSAssertion.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException("libIDFF", "alreadySigned", null);
        }
        if (certAlias == null || certAlias.length() == 0) {
            throw new SAMLResponderException("libIDFF", "cannotFindCertAlias", null);
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2 || this.minorVersion == 2) {
                this.signatureString = manager.signXML(this.toXMLString(true, true), certAlias, (String)null, "AssertionID", this.getAssertionID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument(this.signatureString, FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception e) {
            FSUtils.debug.message(" Exception :" + e.getMessage());
            throw new SAMLResponderException(e);
        }
    }

    public boolean setSignature(Element elem) {
        this.signatureString = XMLUtils.print(elem);
        return super.setSignature(elem);
    }

    public void parseAdvice(Element element) {
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int n = 0; n < length; ++n) {
            String childName;
            Node child = nl.item(n);
            if (child.getNodeType() != 1 || !(childName = child.getLocalName()).equals("Assertion")) continue;
            try {
                if (this.securityAssertions == null) {
                    this.securityAssertions = new ArrayList();
                }
                this.securityAssertions.add(new SecurityAssertion((Element)child));
                continue;
            }
            catch (Exception ex) {
                FSUtils.debug.error("FSAssertion.parseAdvice: Error inparsing security assertion", ex);
            }
        }
        if (this.securityAssertions != null && !this.securityAssertions.isEmpty()) {
            this._advice = new Advice(null, this.securityAssertions, null);
        }
    }

    public List getDiscoveryCredential() {
        return this.securityAssertions;
    }
}

