/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.federation.common.IFSConstants;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public class FSUtils {
    public static String deploymentURI = SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor");
    public static final String BUNDLE_NAME = "libIDFF";
    public static IFSConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;
    private static SecureRandom random;
    public static final String FSID_PREFIX = "f";
    public static IDFFMetaManager metaInstance;

    private FSUtils() {
    }

    public static void setLocale(String localeName) {
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getLocale(localeName));
        }
        catch (MissingResourceException mre) {
            System.err.println(mre.getMessage());
            System.exit(1);
        }
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String encodedID = FSID_PREFIX + SAMLUtils.byteArrayToHexString(bytes);
        if (debug.messageEnabled()) {
            debug.message("FSUtils.generateID: generated id is " + encodedID);
        }
        return encodedID;
    }

    public static String generateSourceID(String entityID) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            debug.error("FSUtils.generateSourceID: Exception:", e);
            return null;
        }
        char[] chars = entityID.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        md.update(bytes);
        return SAMLUtils.byteArrayToString(md.digest());
    }

    public static String generateAssertionHandle() {
        String result = null;
        String encodedID = FSUtils.generateID();
        if (encodedID != null) {
            try {
                result = encodedID.substring(0, 20);
            }
            catch (Exception e) {
                debug.error("FSUtil.generateAssertionHandle:", e);
            }
        }
        return result;
    }

    public static String stringToBase64(String succinctID) {
        String encodedID;
        block3: {
            encodedID = null;
            try {
                encodedID = Base64.encode(SAMLUtils.stringToByteArray(succinctID)).trim();
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("FSUtils:stringToBase64: exception encode input:", e);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("base 64 source id is :" + encodedID);
        }
        return encodedID;
    }

    public static void checkHTTPRequestLength(HttpServletRequest request) throws ServletException {
        int maxContentLength = SAMLUtils.getMaxContentLength();
        if (maxContentLength != 0) {
            int length = request.getContentLength();
            if (length == -1) {
                throw new ServletException(bundle.getString("unknownLength"));
            }
            if (length > maxContentLength) {
                if (debug.messageEnabled()) {
                    debug.message("FSUtils.checkHTTPRequestLength: content length too large" + length);
                }
                throw new ServletException(bundle.getString("largeContentLength"));
            }
        }
    }

    public static void forwardRequest(HttpServletRequest request, HttpServletResponse response, String url) {
        debug.message("FSUtils.forwardRequest: called");
        String newUrl = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object token = sessionProvider.getSession(request);
            if (token != null && sessionProvider.isValid(token)) {
                newUrl = sessionProvider.rewriteURL(token, url);
            }
        }
        catch (Exception se) {
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardReqeust: couldn't rewrite url: " + se.getMessage());
            }
            newUrl = null;
        }
        if (newUrl == null) {
            newUrl = url;
        }
        try {
            String sourceHost = request.getServerName();
            int sourcePort = request.getServerPort();
            debug.message("FSUtils.forwardRequest: SourceHost=" + sourceHost + " SourcePort=" + sourcePort);
            URL target = new URL(newUrl);
            String targetHost = target.getHost();
            int targetPort = target.getPort();
            debug.message("FSUtils.forwardRequest: targetHost=" + targetHost + " targetPort=" + targetPort);
            boolean isWebSphere = false;
            String container = SystemConfigurationUtil.getProperty("com.sun.identity.webcontainer");
            if (container != null && container.indexOf("IBM") != -1) {
                isWebSphere = true;
            }
            int index = newUrl.indexOf(deploymentURI + "/");
            if (!sourceHost.equals(targetHost) || sourcePort != targetPort || index <= 0 || isWebSphere) {
                debug.message("FSUtils.forwardRequest: Source and Target are not on the same container.Redirecting to target");
                response.sendRedirect(newUrl);
                return;
            }
            String resource = newUrl.substring(index + deploymentURI.length());
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardRequest: Forwarding to :" + resource);
            }
            RequestDispatcher dispatcher = request.getRequestDispatcher(resource);
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                debug.error("FSUtils.forwardRequest: Exception occured while trying to forward to resource:" + resource, e);
            }
        }
        catch (Exception ex) {
            debug.error("FSUtils.forwardRequest: Exception occured", ex);
        }
    }

    private static String getProviderIDFromSuccinctID(String realm, String succinctID) {
        if (succinctID == null) {
            return null;
        }
        try {
            metaInstance = FSUtils.getIDFFMetaManager();
            if (metaInstance != null) {
                return metaInstance.getEntityIDBySuccinctID(realm, succinctID);
            }
        }
        catch (Exception ex) {
            debug.error("FSUtils.getProviderIDFromSuccinctID::", ex);
        }
        return null;
    }

    public static String findPreferredIDP(String realm, HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        String succinctID = request.getParameter("_liberty_idp");
        if (succinctID == null || succinctID.length() == 0) {
            debug.message("FSUtils.findPreferredIDP::Pref IDP not found.");
            return null;
        }
        succinctID = succinctID.trim();
        String preferredSuccinctId = null;
        StringTokenizer st = new StringTokenizer(succinctID, " ");
        while (st.hasMoreTokens()) {
            preferredSuccinctId = st.nextToken();
            if (preferredSuccinctId.length() >= 28) continue;
            preferredSuccinctId = preferredSuccinctId + "+" + st.nextToken();
        }
        preferredSuccinctId = SAMLUtils.byteArrayToString(Base64.decode(preferredSuccinctId));
        return FSUtils.getProviderIDFromSuccinctID(realm, preferredSuccinctId);
    }

    public static String removeNewLineChars(String s) {
        String retString = null;
        if (s != null && s.length() > 0 && s.indexOf(10) != -1) {
            char[] chars = s.toCharArray();
            int len = chars.length;
            StringBuffer sb = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = chars[i];
                if (c == '\n') continue;
                sb.append(c);
            }
            retString = sb.toString();
        } else {
            retString = s;
        }
        return retString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDFFMetaManager getIDFFMetaManager() {
        if (metaInstance == null) {
            Class clazz = IDFFMetaManager.class;
            synchronized (clazz) {
                try {
                    metaInstance = new IDFFMetaManager(null);
                    return metaInstance;
                }
                catch (Exception e) {
                    debug.error("FSUtils.getIDFFMetaManager: Could not create meta Manager", e);
                    return null;
                }
            }
        }
        return metaInstance;
    }

    public static String getAuthDomainURL(String orgDN) {
        if (orgDN == null || orgDN.length() == 0) {
            return "/";
        }
        if (DN.isDN(orgDN)) {
            DN orgdn = new DN(orgDN);
            Vector rdn = orgdn.getRDNs();
            if (rdn != null && rdn.size() > 0) {
                return ((RDN)rdn.firstElement()).getValues()[0];
            }
        } else if (orgDN.startsWith("/")) {
            if (orgDN.trim().equals("/")) {
                return "/";
            }
            if (!orgDN.trim().endsWith("/")) {
                int loc = orgDN.lastIndexOf("/");
                return orgDN.substring(loc + 1).trim();
            }
            debug.error("getAuthDomainURL.invalid org URL " + orgDN);
        } else {
            debug.error("getAuthDomainURLList invalid org URL " + orgDN);
        }
        return null;
    }

    static {
        bundle = Locale.getInstallResourceBundle(BUNDLE_NAME);
        debug = Debug.getInstance(BUNDLE_NAME);
        random = new SecureRandom();
        metaInstance = null;
    }
}

