/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entity;

import com.iplanet.dpro.session.Session;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entity.EntityException;
import com.sun.identity.entity.EntityUtils;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;

public class EntityObject {
    private static String SERVICE_NAME = "EntityObjectIF";
    private SSOToken token;
    private String tokenString;
    protected String entityLocation;
    protected SOAPClient client = null;

    public EntityObject(SSOToken token, String entityLocation) throws EntityException {
        this.token = token;
        this.tokenString = ((Object)token.getTokenID()).toString();
        this.entityLocation = entityLocation;
        if (this.client == null) {
            this.client = new SOAPClient(SERVICE_NAME);
        }
    }

    public Set createEntity(String entityName, String entityType, Map attributes) throws EntityException, SSOException {
        try {
            Object[] objs = new Object[]{this.tokenString, entityName, entityType, this.entityLocation, attributes};
            return (Set)this.client.send(this.client.encodeMessage("createEntity", objs), Session.getLBCookie(((Object)this.token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            EntityUtils.debug.warning("EntityObject:createEntity->RemoteException", rex);
            throw new EntityException(rex.getMessage(), "1000");
        }
        catch (Exception ex) {
            EntityUtils.debug.warning("EntityObject:createEntity->Exception", ex);
            throw new EntityException(ex.getMessage(), "1000");
        }
    }

    public void deleteEntity(String entityName, String entityType) throws EntityException, SSOException {
        try {
            Object[] objs = new Object[]{this.tokenString, entityName, entityType, this.entityLocation};
            this.client.send(this.client.encodeMessage("deleteEntity", objs), Session.getLBCookie(((Object)this.token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            EntityUtils.debug.warning("EntityObject:deleteEntity->RemoteException", rex);
            throw new EntityException(rex.getMessage(), "1000");
        }
        catch (Exception ex) {
            EntityUtils.debug.warning("EntityObject:deleteEntity->Exception", ex);
            throw new EntityException(ex.getMessage(), "1000");
        }
    }

    public Map getEntity(String entityName, String entityType) throws EntityException, SSOException {
        try {
            Object[] objs = new Object[]{this.tokenString, entityName, entityType, this.entityLocation};
            return (Map)this.client.send(this.client.encodeMessage("getEntity", objs), Session.getLBCookie(((Object)this.token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            EntityUtils.debug.warning("EntityObject:getEntity->RemoteException", rex);
            throw new EntityException(rex.getMessage(), "1000");
        }
        catch (Exception ex) {
            EntityUtils.debug.warning("EntityObject:getEntity->Exception", ex);
            throw new EntityException(ex.getMessage(), "1000");
        }
    }

    public Set getEntityNames(String entityName, String entityType, String entityFilter) throws EntityException, SSOException {
        try {
            Object[] objs = new Object[]{this.tokenString, entityType, this.entityLocation, entityFilter};
            return (Set)this.client.send(this.client.encodeMessage("getEntityNames", objs), Session.getLBCookie(((Object)this.token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            EntityUtils.debug.warning("EntityObject:getEntityNames->RemoteException", rex);
            throw new EntityException(rex.getMessage(), "1000");
        }
        catch (Exception ex) {
            EntityUtils.debug.warning("EntityObject:getEntityNames->Exception", ex);
            throw new EntityException(ex.getMessage(), "1000");
        }
    }

    public void modifyEntity(String entityName, String entityType, Map attributes) throws EntityException, SSOException {
        try {
            Object[] objs = new Object[]{this.tokenString, entityName, entityType, this.entityLocation, attributes};
            this.client.send(this.client.encodeMessage("modifyEntity", objs), Session.getLBCookie(((Object)this.token.getTokenID()).toString()), null);
        }
        catch (RemoteException rex) {
            EntityUtils.debug.warning("EntityObject:modifyEntity->RemoteException", rex);
            throw new EntityException(rex.getMessage(), "1000");
        }
        catch (Exception ex) {
            EntityUtils.debug.warning("EntityObject:modifyEntity->Exception", ex);
            throw new EntityException(ex.getMessage(), "1000");
        }
    }
}

