/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cot;

import com.sun.identity.cot.COTUtils;
import com.sun.identity.cot.CircleOfTrustDescriptor;
import com.sun.identity.shared.debug.Debug;
import java.util.Hashtable;

public class COTCache {
    private static Hashtable cotCache = new Hashtable();
    private static Debug debug = COTUtils.debug;

    private COTCache() {
    }

    static CircleOfTrustDescriptor getCircleOfTrust(String realm, String name) {
        String classMethod = "CircleOfDescriptorCache:getCircleOfTrust:";
        String cacheKey = COTCache.buildCacheKey(realm, name);
        CircleOfTrustDescriptor cotDesc = (CircleOfTrustDescriptor)cotCache.get(cacheKey);
        if (COTUtils.debug.messageEnabled()) {
            COTUtils.debug.message(classMethod + "cacheKey = " + cacheKey + ", found = " + (cotDesc != null));
        }
        return cotDesc;
    }

    static void putCircleOfTrust(String realm, String name, CircleOfTrustDescriptor cotDescriptor) {
        String classMethod = "CircleOfTrustCache:putCircleOfTrust";
        String cacheKey = COTCache.buildCacheKey(realm, name);
        if (debug.messageEnabled()) {
            debug.message(classMethod + ": cacheKey = " + cacheKey);
        }
        cotCache.put(cacheKey, cotDescriptor);
    }

    static void clear() {
        cotCache.clear();
    }

    private static String buildCacheKey(String realm, String cotName) {
        return realm + "//" + cotName;
    }
}

