/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.search.FileLookup;
import com.sun.identity.shared.search.FileLookupException;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.ServletContext;

public class ResourceLookup {
    private static Hashtable resourceNameCache = null;
    private static Debug debug = Debug.getInstance("amResourceLookup");

    public static String getFirstExisting(ServletContext context, String fileRoot, String locale, String orgFilePath, String clientPath, String filename, String resourceDir, boolean enableCache) {
        String resourceName = null;
        String cacheKey = fileRoot + ":" + locale + ":" + orgFilePath + ":" + clientPath + ":" + filename + ":" + resourceDir;
        if (enableCache && resourceNameCache != null && !resourceNameCache.isEmpty()) {
            resourceName = (String)resourceNameCache.get(cacheKey);
            if (resourceName != null && ResourceLookup.getResourceURL(context, resourceName) != null) {
                return resourceName;
            }
            resourceNameCache.remove(cacheKey);
        }
        URL resourceUrl = null;
        try {
            File[] orderedPaths = FileLookup.getOrderedPaths(fileRoot, locale, null, orgFilePath, clientPath, filename);
            for (int i = 0; i < orderedPaths.length; ++i) {
                resourceName = resourceDir + "/" + orderedPaths[i].toString();
                resourceUrl = ResourceLookup.getResourceURL(context, resourceName = resourceName.replaceAll("\\\\", "/"));
                if (resourceUrl == null) {
                    continue;
                }
                break;
            }
        }
        catch (FileLookupException fe) {
            debug.message("ResourceLookup.getFirstExisting :", fe);
        }
        catch (Exception e) {
            debug.message("ResourceLookup.getFirstExisting:", e);
        }
        if (debug.messageEnabled()) {
            debug.message("amResourceLookup: resourceURL :" + resourceUrl);
            debug.message("amResourceLookup: resourceName:" + resourceName);
        }
        if (resourceUrl != null) {
            if (enableCache) {
                if (resourceNameCache == null) {
                    resourceNameCache = new Hashtable();
                }
                resourceNameCache.put(cacheKey, resourceName);
            }
        } else {
            resourceName = null;
        }
        return resourceName;
    }

    private static URL getResourceURL(ServletContext context, String resourceName) {
        URL resourceURL = null;
        try {
            resourceURL = context.getResource(resourceName);
        }
        catch (Exception e) {
            debug.message("Error getting resource  : " + e.getMessage());
        }
        return resourceURL;
    }
}

