/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenListener;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthSSOToken;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.shared.encode.Base64;
import java.net.InetAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.security.auth.login.LoginException;

public class AuthSSOToken
implements SSOToken {
    protected static Map allSSOTokens = Collections.synchronizedMap(new HashMap());
    protected static Random random = new Random();
    public static final int INVALID = 0;
    public static final int VALID = 1;
    public static final int DESTROYED = 3;
    protected AuthContext authContext;
    protected HashMap session = new HashMap();
    protected HashSet callbackObjects = new HashSet();
    protected String key;

    private AuthSSOToken() {
    }

    protected AuthSSOToken(AuthContext authc) throws InvalidAuthContextException {
        if (authc == null) {
            throw new InvalidAuthContextException();
        }
        if (authc.getLoginStatus() != 3) {
            throw new InvalidAuthContextException();
        }
        this.authContext = authc;
        this.key = AuthSSOToken.getNewKey();
        allSSOTokens.put(this.key, this);
    }

    protected static String getNewKey() {
        byte[] keyRandom = new byte[12];
        random.nextBytes(keyRandom);
        String key = Base64.encode(keyRandom);
        try {
            key = key + Base64.encode(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        key = key + Long.toString(System.currentTimeMillis());
        return Base64.encode(key.getBytes());
    }

    public Principal getPrincipal() throws SSOException {
        return this.authContext.getPrincipal();
    }

    public String getAuthType() throws SSOException {
        return "ldap";
    }

    public int getAuthLevel() throws SSOException {
        return 1;
    }

    public InetAddress getIPAddress() throws SSOException {
        try {
            String host = this.getProperty("Host");
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            throw new SSOException(e);
        }
    }

    public String getHostName() throws SSOException {
        try {
            String hostName = this.getProperty("HostName");
            return hostName;
        }
        catch (Exception e) {
            throw new SSOException(e);
        }
    }

    public byte[] getAddress() throws SSOException {
        return this.getIPAddress().getAddress();
    }

    public long getTimeLeft() throws SSOException {
        return 0L;
    }

    public String encodeURL(String url) {
        return null;
    }

    public long getMaxSessionTime() throws SSOException {
        return 0L;
    }

    public long getIdleTime() throws SSOException {
        return 0L;
    }

    public long getMaxIdleTime() throws SSOException {
        return -1L;
    }

    public SSOTokenID getTokenID() {
        return new AuthSSOTokenID(this, this.key);
    }

    protected int getState() throws SSOException {
        if (this.authContext != null && this.authContext.getLoginStatus() == 3) {
            return 1;
        }
        return 0;
    }

    public void setProperty(String name, String value) throws SSOException {
        this.session.put(name, value);
    }

    public String getProperty(String name) throws SSOException {
        return (String)this.session.get(name);
    }

    public void addSSOTokenListener(SSOTokenListener listener) throws SSOException {
        this.callbackObjects.add(listener);
    }

    protected boolean isValid() {
        return this.authContext != null && this.authContext.getLoginStatus() == 3;
    }

    protected void validate() throws SSOException {
        if (this.authContext != null && this.authContext.getLoginStatus() == 3) {
            return;
        }
        throw new SSOException("amAuth", "invalidcontext", null);
    }

    protected void invalidate() {
        allSSOTokens.remove(this.key);
        try {
            this.authContext.logout();
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }
}

