/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming.share;

import com.iplanet.services.naming.share.NamingRequestParser;
import com.iplanet.services.naming.share.NamingResponse;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class NamingResponseParser {
    private NamingResponse namingResponse = null;
    Document document;

    public NamingResponseParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public NamingResponseParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument(xmlString, NamingRequestParser.debug);
    }

    public NamingResponse parseXML() {
        Node node;
        NodeList exception;
        NodeList attribs;
        if (this.document == null) {
            return null;
        }
        Element elem = this.document.getDocumentElement();
        this.namingResponse = new NamingResponse();
        String temp = elem.getAttribute("vers");
        if (temp != null) {
            this.namingResponse.setResponseVersion(temp);
        }
        if ((temp = elem.getAttribute("reqid")) != null) {
            this.namingResponse.setRequestID(temp);
        }
        if ((attribs = elem.getElementsByTagName("Attribute")) != null && attribs.getLength() != 0) {
            this.parseAttributeTag(attribs);
        }
        if ((exception = elem.getElementsByTagName("Exception")) != null && exception.getLength() != 0 && (node = exception.item(0)) != null) {
            this.namingResponse.setException(node.getNodeValue());
        }
        return this.namingResponse;
    }

    public void parseAttributeTag(NodeList attributes) {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            Element tempElem = (Element)attributes.item(i);
            String name = tempElem.getAttribute("name");
            if (name == null) continue;
            String value = tempElem.getAttribute("value");
            this.namingResponse.setAttribute(name, value);
        }
    }
}

