/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm.clientschema;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.L10NMessage;
import com.sun.identity.shared.locale.Locale;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class AMClientCapException
extends Exception
implements L10NMessage {
    private static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private static Debug debug = Debug.getInstance("amClientSchema");
    private String bundleName = null;
    private String errorCode = null;
    private Object[] args = null;
    private String message = null;

    public AMClientCapException(String msg) {
        super(msg);
        this.message = msg;
    }

    public AMClientCapException(String rbName, String eCode, Object[] a) {
        this.bundleName = rbName;
        this.errorCode = eCode;
        this.args = a;
        this.message = this.getL10NMessage(java.util.Locale.ENGLISH);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getResourceBundleName() {
        return this.bundleName;
    }

    public Object[] getMessageArgs() {
        return this.args;
    }

    public String getL10NMessage(java.util.Locale locale) {
        String result = this.errorCode;
        if (this.bundleName != null && locale != null) {
            ResourceBundle bundle = amCache.getResBundle(this.bundleName, locale);
            String mid = Locale.getString(bundle, this.errorCode, debug);
            result = this.args == null || this.args.length == 0 ? mid : MessageFormat.format(mid, this.args);
        }
        return result;
    }

    public String getMessage() {
        return this.message;
    }
}

