/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.ASN1CharStrConvMap;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.x509.AVAValueConverter;
import java.io.CharConversionException;
import java.io.IOException;
import sun.io.CharToByteConverter;

public class IA5StringConverter
implements AVAValueConverter {
    public DerValue getValue(String valueString) throws IOException {
        return this.getValue(valueString, null);
    }

    public DerValue getValue(String valueString, byte[] encodingOrder) throws IOException {
        byte[] bbuf = new byte[valueString.length()];
        ASN1CharStrConvMap map = ASN1CharStrConvMap.getDefault();
        try {
            CharToByteConverter cbc = map.getCBC((byte)22);
            if (cbc == null) {
                throw new IOException("No CharToByteConverter for IA5String");
            }
            cbc.convert(valueString.toCharArray(), 0, valueString.length(), bbuf, 0, bbuf.length);
        }
        catch (CharConversionException e) {
            throw new IllegalArgumentException("Invalid IA5String AVA Value string");
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate CharToByteConverter");
        }
        catch (IllegalAccessException e) {
            throw new IOException("Illegal access loading CharToByteConverter");
        }
        return new DerValue(22, bbuf);
    }

    public DerValue getValue(byte[] berStream) throws IOException {
        DerValue value = new DerValue(berStream);
        if (value.tag != 22) {
            throw new IOException("Invalid IA5String AVA Value.");
        }
        return value;
    }

    public String getAsString(DerValue avaValue) throws IOException {
        return avaValue.getIA5String();
    }
}

