/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.x509.X500Name;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;

public class CertUtils {
    public static String getSubjectName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            X500Principal subjectDN = cert.getSubjectX500Principal();
            X500Name certDN = new X500Name(subjectDN.getEncoded());
            return certDN.getName();
        }
        catch (IOException io) {
            return null;
        }
    }

    public static String getIssuerName(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        try {
            X500Principal issuerDN = cert.getIssuerX500Principal();
            X500Name certDN = new X500Name(issuerDN.getEncoded());
            return certDN.getName();
        }
        catch (IOException io) {
            return null;
        }
    }
}

