/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.x509;

import com.iplanet.security.util.DerEncoder;
import com.iplanet.security.util.DerOutputStream;
import com.iplanet.security.util.DerValue;
import com.iplanet.security.util.ObjectIdentifier;
import com.iplanet.security.x509.AVAValueConverter;
import com.iplanet.security.x509.X500NameAttrMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class Attribute
implements DerEncoder {
    ObjectIdentifier oid;
    Vector valueSet = new Vector();
    protected X500NameAttrMap attrMap;

    public Attribute(ObjectIdentifier oid, String value) throws IOException {
        if (oid == null || value == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = oid;
        this.valueSet.addElement(value);
    }

    public Attribute(ObjectIdentifier oid, Vector values) throws IOException {
        if (oid == null || values == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.oid = oid;
        Enumeration vals = values.elements();
        while (vals.hasMoreElements()) {
            Object obj = vals.nextElement();
            if (obj instanceof String) {
                this.valueSet.addElement(obj);
                continue;
            }
            throw new IOException("values vectore must consist of String object");
        }
    }

    public Attribute(String attr, Vector values) throws IOException {
        if (attr == null || values == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        ObjectIdentifier id = this.attrMap.getOid(attr);
        if (id == null) {
            throw new IOException("Attr is not supported - does not contain in attr map");
        }
        this.oid = id;
        Enumeration vals = values.elements();
        while (vals.hasMoreElements()) {
            Object obj = vals.nextElement();
            if (obj instanceof String) {
                this.valueSet.addElement(obj);
                continue;
            }
            throw new IOException("Values vectore must consist of String object");
        }
    }

    public Attribute(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed");
        }
        this.attrMap = X500NameAttrMap.getDefault();
        this.decodeThis(val);
    }

    public ObjectIdentifier getOid() {
        return this.oid;
    }

    public Enumeration getValues() {
        if (this.valueSet == null) {
            return null;
        }
        return this.valueSet.elements();
    }

    public void encode(DerOutputStream out) throws IOException {
        this.encodeThis(out);
    }

    public void derEncode(OutputStream out) throws IOException {
        this.encodeThis(out);
    }

    public String toString() {
        String theoid = "Attribute: " + this.oid + "\n";
        String values = "Values: ";
        Enumeration n = this.valueSet.elements();
        if (n.hasMoreElements()) {
            values = values + (String)n.nextElement();
            while (n.hasMoreElements()) {
                values = values + "," + (String)n.nextElement();
            }
        }
        return theoid + values + "\n";
    }

    private void encodeThis(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        tmp.putOID(this.oid);
        this.encodeValueSet(tmp);
        tmp2.write((byte)48, tmp);
        out.write(tmp2.toByteArray());
    }

    private void encodeValueSet(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        DerOutputStream tmp2 = new DerOutputStream();
        AVAValueConverter converter = this.attrMap.getValueConverter(this.oid);
        if (converter == null) {
            throw new IOException("Converter not found: unsupported attribute type");
        }
        Enumeration vals = this.valueSet.elements();
        while (vals.hasMoreElements()) {
            String val = (String)vals.nextElement();
            DerValue derobj = converter.getValue(val);
            derobj.encode(tmp);
        }
        tmp2.write((byte)49, tmp);
        out.write(tmp2.toByteArray());
    }

    private void decodeThis(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for Attribute.");
        }
        if (val.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded value.");
        }
        this.oid = val.data.getDerValue().getOID();
        if (val.data.available() == 0) {
            throw new IOException("Invalid encoding for Attribute - value missing");
        }
        this.decodeValueSet(val.data.getDerValue());
        if (this.oid == null) {
            throw new IOException("Invalid encoding for Attribute - OID missing");
        }
    }

    private void decodeValueSet(DerValue val) throws IOException {
        if (val == null) {
            throw new IOException("Invalid Input - null passed.");
        }
        AVAValueConverter converter = this.attrMap.getValueConverter(this.oid);
        if (converter == null) {
            throw new IOException("Attribute is not supported - not in attr map");
        }
        if (val.tag != 49) {
            throw new IOException("Invalid encoding for Attribute Value Set.");
        }
        if (val.data.available() == 0) {
            throw new IOException("No data available in passed DER encoded attribute value set.");
        }
        while (val.data.available() != 0) {
            DerValue value = val.data.getDerValue();
            this.valueSet.addElement(converter.getAsString(value));
        }
    }
}

