/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.security.util;

import com.iplanet.security.util.DerInputBuffer;
import com.iplanet.security.util.DerInputStream;
import com.iplanet.security.util.DerOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private int[] components;
    private int componentLen;
    private static final int allocationQuantum = 5;
    public static Hashtable mOIDs = new Hashtable();

    public ObjectIdentifier(String oid) {
        if (oid == null) {
            return;
        }
        int ch = 46;
        int start = 0;
        int end = 0;
        this.componentLen = 0;
        while ((end = oid.indexOf(ch, start)) != -1) {
            start = end + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        start = 0;
        int i = 0;
        String comp = null;
        while ((end = oid.indexOf(ch, start)) != -1) {
            comp = oid.substring(start, end);
            this.components[i++] = Integer.valueOf(comp);
            start = end + 1;
        }
        comp = oid.substring(start);
        this.components[i] = Integer.valueOf(comp);
    }

    public ObjectIdentifier(int[] values) {
        try {
            this.components = (int[])values.clone();
            this.componentLen = values.length;
        }
        catch (Throwable t) {
            System.out.println("X509.ObjectIdentifier(), no cloning!");
        }
    }

    public ObjectIdentifier(DerInputStream in) throws IOException {
        byte type_id = (byte)in.getByte();
        if (type_id != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + type_id + ")");
        }
        int bufferEnd = in.available() - in.getLength() - 1;
        if (bufferEnd < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(in, bufferEnd);
    }

    ObjectIdentifier(DerInputBuffer buf) throws IOException {
        this.initFromEncoding(new DerInputStream(buf), 0);
    }

    private void initFromEncoding(DerInputStream in, int bufferEnd) throws IOException {
        boolean first_subid = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (in.available() > bufferEnd) {
            int component = ObjectIdentifier.getComponent(in);
            if (first_subid) {
                int X = component < 40 ? 0 : (component < 80 ? 1 : 2);
                int Y = component - X * 40;
                this.components[0] = X;
                this.components[1] = Y;
                this.componentLen = 2;
                first_subid = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] tmp_components = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, tmp_components, 0, this.components.length);
                this.components = tmp_components;
            }
            this.components[this.componentLen++] = component;
        }
        if (in.available() != bufferEnd) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DerOutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        bytes.write(this.components[0] * 40 + this.components[1]);
        for (int i = 2; i < this.componentLen; ++i) {
            ObjectIdentifier.putComponent(bytes, this.components[i]);
        }
        out.write((byte)6, bytes);
    }

    private static int getComponent(DerInputStream in) throws IOException {
        int retval = 0;
        for (int i = 0; i < 4; ++i) {
            retval <<= 7;
            int tmp = in.getByte();
            retval |= tmp & 0x7F;
            if ((tmp & 0x80) != 0) continue;
            return retval;
        }
        throw new IOException("X509.OID, component value too big");
    }

    private static void putComponent(DerOutputStream out, int val) throws IOException {
        int i;
        byte[] buf = new byte[4];
        for (i = 0; i < 4; ++i) {
            buf[i] = (byte)(val & 0x7F);
            if ((val >>>= 7) == 0) break;
        }
        while (i > 0) {
            out.write(buf[i] | 0x80);
            --i;
        }
        out.write(buf[0]);
    }

    public boolean precedes(ObjectIdentifier other) {
        if (other == this || this.componentLen < other.componentLen) {
            return false;
        }
        if (other.componentLen < this.componentLen) {
            return true;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (other.components[i] >= this.components[i]) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)other);
        }
        return false;
    }

    public boolean equals(ObjectIdentifier other) {
        if (other == this) {
            return true;
        }
        if (this.componentLen != other.componentLen) {
            return false;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (this.components[i] == other.components[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        int oflow = 0;
        for (int i = 0; i < this.componentLen; ++i) {
            oflow = (h & 0xFF800000) >> 23;
            h <<= 9;
            h += this.components[i];
            h ^= oflow;
        }
        return h;
    }

    public String toString() {
        String retval = "";
        for (int i = 0; i < this.componentLen; ++i) {
            if (i != 0) {
                retval = retval + ".";
            }
            retval = retval + this.components[i];
        }
        return retval;
    }

    public static ObjectIdentifier getObjectIdentifier(String oid) throws IOException {
        if (oid == null) {
            throw new IOException("empty object identifier");
        }
        oid.trim();
        ObjectIdentifier thisOID = (ObjectIdentifier)mOIDs.get(oid);
        if (thisOID != null) {
            return thisOID;
        }
        StringTokenizer token = new StringTokenizer(oid, ".");
        int value = new Integer(token.nextToken());
        if (value >= 0 && value <= 2) {
            value = new Integer(token.nextToken());
            if (value >= 0 && value <= 39) {
                thisOID = new ObjectIdentifier(oid);
                if (thisOID.toString().equals(oid)) {
                    mOIDs.put(oid, thisOID);
                    return thisOID;
                }
                throw new IOException("invalid oid " + oid);
            }
            throw new IOException("invalid oid " + oid);
        }
        throw new IOException("invalid oid " + oid);
    }

    public static ObjectIdentifier getObjectIdentifier(int[] values) throws IOException {
        String retval = "";
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                retval = retval + ".";
            }
            retval = retval + values[i];
        }
        return ObjectIdentifier.getObjectIdentifier(retval);
    }
}

