/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.share;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.share.SessionInfo;
import com.iplanet.dpro.session.share.SessionResponseParser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SessionResponse {
    static final String QUOTE = "\"";
    static final String NL = "\n";
    private String responseVersion = "1.0";
    private String requestID = null;
    private int methodID;
    private Map allSessionsforGivenUUID = new HashMap();
    private Vector sessionInfoVector = new Vector();
    private boolean booleanFlag = false;
    private String exception = null;
    private int status = -1;

    public SessionResponse(String reqid, int method) {
        this.requestID = reqid;
        this.methodID = method;
    }

    SessionResponse() {
    }

    public static SessionResponse parseXML(String xml) throws SessionException {
        SessionResponseParser parser = new SessionResponseParser(xml);
        return parser.parseXML();
    }

    void setResponseVersion(String version) {
        this.responseVersion = version;
    }

    public String getResponseVersion() {
        return this.responseVersion;
    }

    void setRequestID(String id) {
        this.requestID = id;
    }

    public String getRequestID() {
        return this.requestID;
    }

    void setMethodID(int id) {
        this.methodID = id;
    }

    public int getMethodID() {
        return this.methodID;
    }

    public void addSessionInfo(SessionInfo info) {
        this.sessionInfoVector.add(info);
    }

    public Vector getSessionInfoVector() {
        return this.sessionInfoVector;
    }

    public void setSessionInfoVector(Vector infos) {
        this.sessionInfoVector = infos;
    }

    public void setBooleanFlag(boolean flag) {
        this.booleanFlag = flag;
    }

    public boolean getBooleanFlag() {
        return this.booleanFlag;
    }

    public void addSessionForGivenUUID(String sid, Long expTime) {
        this.allSessionsforGivenUUID.put(sid, expTime);
    }

    public void setSessionsForGivenUUID(Map sessions) {
        this.allSessionsforGivenUUID = sessions;
    }

    public Map getSessionsForGivenUUID() {
        return this.allSessionsforGivenUUID;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String ex) {
        this.exception = ex;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
    }

    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<SessionResponse vers=\"" + this.responseVersion + QUOTE + " reqid=" + QUOTE + this.requestID + QUOTE + ">" + NL);
        switch (this.methodID) {
            case 0: {
                xml.append("<GetSession>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    if (this.sessionInfoVector.size() != 1) {
                        return null;
                    }
                    SessionInfo info = (SessionInfo)this.sessionInfoVector.elementAt(0);
                    xml.append(info.toXMLString());
                }
                xml.append("</GetSession>\n");
                break;
            }
            case 1: {
                xml.append("<GetValidSessions>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<SessionList>\n");
                    for (int i = 0; i < this.sessionInfoVector.size(); ++i) {
                        SessionInfo info = (SessionInfo)this.sessionInfoVector.elementAt(i);
                        xml.append(info.toXMLString());
                    }
                    xml.append("</SessionList>\n");
                    xml.append("<Status>" + Integer.toString(this.status) + "</Status>" + NL);
                }
                xml.append("</GetValidSessions>\n");
                break;
            }
            case 2: {
                xml.append("<DestroySession>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<OK></OK>\n");
                }
                xml.append("</DestroySession>\n");
                break;
            }
            case 3: {
                xml.append("<Logout>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<OK></OK>\n");
                }
                xml.append("</Logout>\n");
                break;
            }
            case 4: {
                xml.append("<AddSessionListener>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<OK></OK>\n");
                }
                xml.append("</AddSessionListener>\n");
                break;
            }
            case 5: {
                xml.append("<AddSessionListenerOnAllSessions>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<OK></OK>\n");
                }
                xml.append("</AddSessionListenerOnAllSessions>\n");
                break;
            }
            case 6: {
                xml.append("<SetProperty>\n");
                if (this.exception != null) {
                    xml.append("<Exception>" + this.exception + "</Exception>" + NL);
                } else {
                    xml.append("<OK></OK>\n");
                }
                xml.append("</SetProperty>\n");
                break;
            }
            case 7: {
                xml.append("<GetSessionCount>").append(NL);
                if (this.exception != null) {
                    xml.append("<Exception>").append(this.exception).append("</Exception>").append(NL);
                } else {
                    xml.append("<AllSessionsGivenUUID>").append(NL);
                    Set sids = this.allSessionsforGivenUUID.keySet();
                    Iterator m = sids.iterator();
                    while (m.hasNext()) {
                        String sid = (String)m.next();
                        xml.append("<SessionExpirationTimeInfo sid=").append(QUOTE).append(sid).append(QUOTE).append(" expTime=").append(QUOTE).append(((Long)this.allSessionsforGivenUUID.get(sid)).toString()).append(QUOTE).append(">").append("</SessionExpirationTimeInfo>");
                    }
                    xml.append("</AllSessionsGivenUUID>").append(NL);
                }
                xml.append("</GetSessionCount>").append(NL);
                break;
            }
            default: {
                return null;
            }
        }
        xml.append("</SessionResponse>");
        return xml.toString();
    }
}

