/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;

public final class AMEntityType {
    private String name;
    private int type;
    private String serviceName;
    private String searchTemplateName;
    private String creationTemplateName;
    private String containerRDN;
    private int containerType;
    private String stAttribute;
    private String namingAttribute;
    private String objectClass;
    private Debug debug = AMCommonUtils.debug;

    protected AMEntityType(String name, int type, String serviceName, String searchTemplate, String creationTemplate, String containerDN, int containerType, String nAttr, String stAttr, String oc) {
        this.name = name;
        this.type = type;
        this.serviceName = serviceName;
        this.containerRDN = containerDN;
        this.containerType = containerType;
        this.stAttribute = stAttr;
        this.namingAttribute = nAttr;
        this.objectClass = oc;
        this.searchTemplateName = searchTemplate;
        this.creationTemplateName = creationTemplate;
        if (this.debug.messageEnabled()) {
            this.debug.message("AMEntityType:Constructor-> created type " + this.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Entity Name=\t").append(this.name).append("\n").append("Entity type=\t").append(this.type).append("\n").append("Object Class=\t").append(this.objectClass).append("\n").append("Service Name=\t").append(this.serviceName).append("\n").append("Creation Template=\t").append(this.creationTemplateName).append("\n").append("Search Template=\t").append(this.searchTemplateName).append("\n").append("Naming Attribute=\t").append(this.namingAttribute).append("\n").append("Status Attribute=\t").append(this.stAttribute).append("\n").append("Container RDN=\t").append(this.containerRDN).append("\n").append("Container Type=\t").append(this.containerType).append("\n");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceSchemaManager getServiceSchemaManager(SSOToken token) throws AMException, SSOException {
        if (this.serviceName == null || this.serviceName.length() == 0) {
            Object[] args = new Object[]{this.name};
            throw new AMException(AMSDKBundle.getString("978", args), "978", args);
        }
        try {
            return new ServiceSchemaManager(this.serviceName, token);
        }
        catch (SMSException smse) {
            this.debug.error("AMEntityType.getServiceSchemaManager: SM Exception", smse);
            Object[] args = new Object[]{this.name};
            throw new AMException(AMSDKBundle.getString("978", args), "978", args);
        }
    }

    protected String getNamingAttribute() {
        return this.namingAttribute;
    }

    protected String getObjectClass() {
        return this.objectClass;
    }

    protected String getCreationTemplate() {
        return this.creationTemplateName;
    }

    public String getSearchTemplate() {
        return this.searchTemplateName;
    }

    protected String getContainerRDN() {
        return this.containerRDN;
    }

    protected int getContainerType() {
        return this.containerType;
    }
}

