/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMDCTree;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.common.IComplianceServices;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class AMCompliance
implements AMConstants {
    private static IComplianceServices complianceServices = AMDirectoryAccessFactory.getComplianceServices();
    private static Map deletedOrg = new HashMap();
    protected static final String ADMIN_GROUPS_ENABLED_ATTR = "iplanet-am-admin-console-compliance-admin-groups";
    protected static final String COMPLIANCE_USER_DELETION_ATTR = "iplanet-am-admin-console-compliance-user-deletion";
    private static String rootSuffix;
    protected static ServiceSchema gsc;
    static Debug debug;

    AMCompliance() {
    }

    protected static void init() {
        rootSuffix = AMStoreConnection.getAMSdkBaseDN();
        if (rootSuffix == null || rootSuffix == "") {
            debug.error("com.iplanet.am.rootsuffix property value should not be null");
            return;
        }
    }

    protected static boolean isAncestorOrgDeleted(SSOToken token, String dn, int profileType) throws AMException {
        return complianceServices.isAncestorOrgDeleted(token, dn, profileType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cleanDeletedOrgCache(String orgDN) {
        String tdn = orgDN;
        while (!tdn.equalsIgnoreCase(rootSuffix)) {
            if (deletedOrg.containsKey(tdn)) {
                Map map = deletedOrg;
                synchronized (map) {
                    deletedOrg.remove(tdn);
                }
            }
            tdn = new DN(tdn).getParent().toRFCString().toLowerCase();
        }
    }

    protected static boolean isAdminGroupsEnabled(String orgDN) throws AMException {
        if (!AMCompliance.isUnderRootSuffix(orgDN)) {
            return false;
        }
        try {
            if (AMDCTree.gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMDCTree.gsc = scm.getGlobalSchema();
            }
            Map attrMap = AMDCTree.gsc.getReadOnlyAttributeDefaults();
            Set values = (Set)attrMap.get(ADMIN_GROUPS_ENABLED_ATTR);
            boolean enabled = false;
            if (values == null || values.isEmpty()) {
                enabled = false;
            } else {
                String val = (String)values.iterator().next();
                enabled = val.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isAdminGroupsEnabled = " + enabled);
            }
            return enabled;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("357"), ex);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("357"), ex);
            throw new AMException(AMSDKBundle.getString("357"), "357");
        }
    }

    protected static boolean isUnderRootSuffix(String objDN) {
        if (objDN == null || objDN.length() == 0) {
            return true;
        }
        DN rootDN = new DN(rootSuffix);
        DN objectDN = new DN(objDN);
        return rootDN.equals(objectDN) || rootDN.equals(objectDN.getParent());
    }

    protected static boolean isComplianceUserDeletionEnabled() throws AMException {
        try {
            if (AMDCTree.gsc == null) {
                ServiceSchemaManager scm = new ServiceSchemaManager("iPlanetAMAdminConsoleService", (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()));
                AMDCTree.gsc = scm.getGlobalSchema();
            }
            Map attrMap = AMDCTree.gsc.getReadOnlyAttributeDefaults();
            Set values = (Set)attrMap.get(COMPLIANCE_USER_DELETION_ATTR);
            boolean enabled = false;
            if (values == null || values.isEmpty()) {
                enabled = false;
            } else {
                String val = (String)values.iterator().next();
                enabled = val.equalsIgnoreCase("true");
            }
            if (debug.messageEnabled()) {
                debug.message("Compliance.isComplianceUserDeletionEnabled = " + enabled);
            }
            return enabled;
        }
        catch (SMSException ex) {
            debug.error(AMSDKBundle.getString("359"), ex);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
        catch (SSOException ex) {
            debug.error(AMSDKBundle.getString("359"), ex);
            throw new AMException(AMSDKBundle.getString("359"), "359");
        }
    }

    protected static void verifyAndDeleteObject(SSOToken token, String profileDN) throws AMException {
        complianceServices.verifyAndDeleteObject(token, profileDN);
    }

    protected static String getDeletedObjectFilter(int objectType) throws AMException, SSOException {
        return complianceServices.getDeletedObjectFilter(objectType);
    }

    static {
        gsc = null;
        debug = AMCommonUtils.debug;
        AMCompliance.init();
    }
}

