/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPSocketFactory;

public class LDAPUrl
implements Serializable {
    static final long serialVersionUID = -3245440798565713641L;
    public static String defaultFilter = "(objectClass=*)";
    private String m_hostName;
    private int m_portNumber;
    private String m_DN;
    private Vector m_attributes;
    private int m_scope;
    private String m_filter;
    private String m_URL;
    private boolean m_secure;
    private static LDAPSocketFactory m_factory;
    public static final int DEFAULT_SECURE_PORT = 636;

    public LDAPUrl(String string) throws MalformedURLException {
        this.m_attributes = null;
        this.m_scope = 0;
        this.m_filter = defaultFilter;
        this.m_URL = string;
        this.parseUrl(string);
    }

    private void parseUrl(String string) throws MalformedURLException {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/?", true);
        String string3 = null;
        try {
            string2 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("LDAPS")) {
                this.m_secure = true;
            } else if (!string2.equalsIgnoreCase("LDAP")) {
                throw new MalformedURLException();
            }
            string2 = stringTokenizer.nextToken();
            if (!string2.equals(":")) {
                throw new MalformedURLException();
            }
            string2 = stringTokenizer.nextToken();
            if (!string2.equals("/")) {
                throw new MalformedURLException();
            }
            string2 = stringTokenizer.nextToken();
            if (!string2.equals("/")) {
                throw new MalformedURLException();
            }
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException();
        }
        if (string2.equals("/")) {
            this.m_hostName = null;
            this.m_portNumber = this.m_secure ? 636 : 389;
        } else {
            if (string2.equals(":")) {
                throw new MalformedURLException("No hostname");
            }
            if (string2.equals("?")) {
                throw new MalformedURLException("No host[:port]");
            }
            this.m_hostName = string2;
            if (stringTokenizer.countTokens() == 0) {
                this.m_portNumber = this.m_secure ? 636 : 389;
                return;
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equals(":")) {
                try {
                    this.m_portNumber = Integer.parseInt(stringTokenizer.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("Port not a number");
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw new MalformedURLException("No port number");
                }
                if (stringTokenizer.countTokens() == 0) {
                    return;
                }
                if (!stringTokenizer.nextToken().equals("/")) {
                    throw new MalformedURLException();
                }
            } else if (string2.equals("/")) {
                this.m_portNumber = this.m_secure ? 636 : 389;
            } else {
                throw new MalformedURLException();
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        try {
            this.m_DN = LDAPUrl.decode(this.readNextConstruct(stringTokenizer));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        if (this.m_DN.equals("?")) {
            this.m_DN = "";
        } else if (this.m_DN.equals("/")) {
            throw new MalformedURLException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string3 = this.readNextConstruct(stringTokenizer);
        try {
            if (!string3.equals("?")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(LDAPUrl.decode(string3), ", ");
                this.m_attributes = new Vector();
                while (stringTokenizer2.hasMoreTokens()) {
                    this.m_attributes.addElement(stringTokenizer2.nextToken());
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string3 = this.readNextConstruct(stringTokenizer);
        if (!string3.equals("?")) {
            this.m_scope = this.getScope(string3);
            if (this.m_scope < 0) {
                throw new MalformedURLException("Bad scope:" + string3);
            }
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        string3 = this.readNextConstruct(stringTokenizer);
        try {
            this.m_filter = LDAPUrl.decode(string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        this.checkBalancedParentheses(this.m_filter);
        if (!this.m_filter.startsWith("(") && !this.m_filter.endsWith(")")) {
            this.m_filter = "(" + this.m_filter + ")";
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new MalformedURLException();
        }
    }

    private void checkBalancedParentheses(String string) throws MalformedURLException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()", true);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("(")) {
                ++n;
                continue;
            }
            if (!string2.equals(")") || --n >= 0) continue;
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
        if (n != 0) {
            throw new MalformedURLException("Unbalanced filter parentheses");
        }
    }

    public LDAPUrl(String string, int n, String string2) {
        this.initialize(string, n, string2, null, 0, defaultFilter, false);
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3) {
        this(string, n, string2, stringArray, n2, string3, false);
    }

    public LDAPUrl(String string, int n, String string2, Enumeration enumeration, int n2, String string3) {
        this.initialize(string, n, string2, enumeration, n2, string3, false);
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3, boolean bl) {
        if (stringArray != null) {
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.addElement(stringArray[i]);
            }
            this.initialize(string, n, string2, vector.elements(), n2, string3, bl);
        } else {
            this.initialize(string, n, string2, null, n2, string3, bl);
        }
    }

    private void initialize(String string, int n, String string2, Enumeration enumeration, int n2, String string3, boolean bl) {
        this.m_hostName = string;
        this.m_DN = string2;
        this.m_portNumber = n;
        this.m_filter = string3 != null ? string3 : defaultFilter;
        this.m_scope = n2;
        this.m_secure = bl;
        if (enumeration != null) {
            this.m_attributes = new Vector();
            while (enumeration.hasMoreElements()) {
                this.m_attributes.addElement(enumeration.nextElement());
            }
        } else {
            this.m_attributes = null;
        }
        StringBuffer stringBuffer = new StringBuffer(bl ? "ldaps://" : "ldap://");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(':');
            stringBuffer.append(String.valueOf(n));
        }
        stringBuffer.append('/');
        try {
            stringBuffer.append(LDAPUrl.encode(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            System.exit(1);
        }
        if (enumeration != null) {
            stringBuffer.append('?');
            Enumeration enumeration2 = this.m_attributes.elements();
            boolean bl2 = true;
            while (enumeration2.hasMoreElements()) {
                if (!bl2) {
                    stringBuffer.append(',');
                } else {
                    bl2 = false;
                }
                stringBuffer.append((String)enumeration2.nextElement());
            }
        }
        if (string3 != null) {
            if (enumeration == null) {
                stringBuffer.append('?');
            }
            stringBuffer.append('?');
            switch (n2) {
                default: {
                    stringBuffer.append("base");
                    break;
                }
                case 1: {
                    stringBuffer.append("one");
                    break;
                }
                case 2: {
                    stringBuffer.append("sub");
                }
            }
            stringBuffer.append('?');
            try {
                stringBuffer.append(LDAPUrl.encode(string3));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                System.exit(1);
            }
        }
        this.m_URL = stringBuffer.toString();
    }

    public String getHost() {
        return this.m_hostName;
    }

    public int getPort() {
        return this.m_portNumber;
    }

    public String getDN() {
        return this.m_DN;
    }

    String getServerUrl() {
        return (this.m_secure ? "ldaps://" : "ldap://") + this.m_hostName + ":" + this.m_portNumber;
    }

    public Enumeration getAttributes() {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.elements();
    }

    public String[] getAttributeArray() {
        if (this.m_attributes == null) {
            return null;
        }
        String[] stringArray = new String[this.m_attributes.size()];
        Enumeration enumeration = this.getAttributes();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public int getScope() {
        return this.m_scope;
    }

    private int getScope(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("base")) {
            n = 0;
        } else if (string.equalsIgnoreCase("one")) {
            n = 1;
        } else if (string.equalsIgnoreCase("sub")) {
            n = 2;
        }
        return n;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public String getUrl() {
        return this.m_URL;
    }

    public boolean isSecure() {
        return this.m_secure;
    }

    public static LDAPSocketFactory getSocketFactory() {
        if (m_factory == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("netscape.ldap.factory.JSSSocketFactory");
                m_factory = (LDAPSocketFactory)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m_factory != null) {
                return m_factory;
            }
            try {
                clazz = Class.forName("netscape.ldap.factory.JSSESocketFactory");
                m_factory = (LDAPSocketFactory)clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return m_factory;
    }

    public static void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        m_factory = lDAPSocketFactory;
    }

    private String readNextConstruct(StringTokenizer stringTokenizer) throws MalformedURLException {
        try {
            if (stringTokenizer.hasMoreTokens()) {
                String string;
                String string2 = stringTokenizer.nextToken();
                if (string2.equals("?")) {
                    return string2;
                }
                if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals("?")) {
                    throw new MalformedURLException();
                }
                return string2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException();
        }
        return null;
    }

    private static int hexValue(char c) throws MalformedURLException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new MalformedURLException();
    }

    private static char hexChar(int n) {
        if (n < 0 || n > 15) {
            return 'x';
        }
        if (n < 10) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 97);
    }

    public static String decode(String string) throws MalformedURLException, UnsupportedEncodingException {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        int n2 = 0;
        try {
            while (n < string.length()) {
                if (string.charAt(n) != '%') {
                    byArray[n2++] = (byte)string.charAt(n);
                    ++n;
                    continue;
                }
                byArray[n2++] = (byte)(LDAPUrl.hexValue(string.charAt(n + 1)) << 4 | LDAPUrl.hexValue(string.charAt(n + 2)));
                n += 3;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedURLException();
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i];
        }
        String string2 = new String(byArray2, "UTF8");
        return string2;
    }

    public static String encode(String string) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        try {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "$-_.+!*'(),".indexOf(c) > 0) {
                    stringBuffer.append(c);
                    continue;
                }
                String string2 = new String(String.valueOf(c));
                byte[] byArray = string2.getBytes("UTF8");
                for (int j = 0; j < byArray.length; ++j) {
                    stringBuffer.append("%");
                    stringBuffer.append(LDAPUrl.hexChar((byArray[j] & 0xF0) >> 4));
                    stringBuffer.append(LDAPUrl.hexChar(byArray[j] & 0xF));
                }
            }
        }
        catch (Exception exception) {
            throw new UnsupportedEncodingException();
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getUrl();
    }

    public boolean equals(LDAPUrl lDAPUrl) {
        if (this.getHost() == null ? lDAPUrl.getHost() != null : !this.getHost().equals(lDAPUrl.getHost())) {
            return false;
        }
        if (this.getPort() != lDAPUrl.getPort()) {
            return false;
        }
        if (this.getDN() == null ? lDAPUrl.getDN() != null : !this.getDN().equals(lDAPUrl.getDN())) {
            return false;
        }
        if (this.getFilter() == null ? lDAPUrl.getFilter() != null : !this.getFilter().equals(lDAPUrl.getFilter())) {
            return false;
        }
        if (this.getScope() != lDAPUrl.getScope()) {
            return false;
        }
        if (this.m_attributes == null) {
            if (lDAPUrl.m_attributes != null) {
                return false;
            }
        } else {
            if (this.m_attributes.size() != lDAPUrl.m_attributes.size()) {
                return false;
            }
            for (int i = 0; i < this.m_attributes.size(); ++i) {
                if (this.m_attributes.elementAt(i) == lDAPUrl.m_attributes.elementAt(i)) continue;
                return false;
            }
        }
        return true;
    }
}

