/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAsynchronousConnection;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPCheckComm;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnThread;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPExtendedOperation;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSSLSocketFactoryExt;
import netscape.ldap.LDAPSaslBind;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;
import netscape.ldap.LDAPTLSSocketFactory;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.LDAPUrl;
import netscape.ldap.LDAPv3;
import netscape.ldap.client.JDAPAVA;
import netscape.ldap.client.opers.JDAPAddRequest;
import netscape.ldap.client.opers.JDAPBindRequest;
import netscape.ldap.client.opers.JDAPCompareRequest;
import netscape.ldap.client.opers.JDAPDeleteRequest;
import netscape.ldap.client.opers.JDAPExtendedRequest;
import netscape.ldap.client.opers.JDAPExtendedResponse;
import netscape.ldap.client.opers.JDAPModifyRDNRequest;
import netscape.ldap.client.opers.JDAPModifyRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPResult;
import netscape.ldap.client.opers.JDAPSearchRequest;
import netscape.ldap.client.opers.JDAPSearchResultReference;
import netscape.ldap.controls.LDAPPersistSearchControl;

public class LDAPConnection
implements LDAPv3,
LDAPAsynchronousConnection,
Cloneable,
Serializable {
    static final long serialVersionUID = -8698420087475771145L;
    public static final int LDAP_VERSION = 2;
    public static final String LDAP_PROPERTY_SDK = "version.sdk";
    public static final String LDAP_PROPERTY_PROTOCOL = "version.protocol";
    public static final String LDAP_PROPERTY_SECURITY = "version.security";
    public static final String TRACE_PROPERTY = "com.netscape.ldap.trace";
    public static final int NODELAY_SERIAL = -1;
    public static final int NODELAY_PARALLEL = 0;
    private static final String defaultFilter = "(objectClass=*)";
    private LDAPSearchConstraints m_defaultConstraints = new LDAPSearchConstraints();
    private LDAPConstraints m_rebindConstraints;
    private Vector m_responseListeners;
    private Vector m_searchListeners;
    private String m_boundDN;
    private String m_boundPasswd;
    private int m_protocolVersion = 2;
    private LDAPConnSetupMgr m_connMgr;
    private int m_connSetupDelay = -1;
    private int m_connectTimeout = 0;
    private LDAPSocketFactory m_factory = null;
    private boolean m_isTLSFactory;
    private transient LDAPConnThread m_thread = null;
    private Hashtable m_responseControlTable = new Hashtable();
    private LDAPCache m_cache = null;
    private boolean m_useTLS;
    static final String OID_startTLS = "1.3.6.1.4.1.1466.20037";
    private Object m_security = null;
    private LDAPSaslBind m_saslBinder = null;
    private Properties m_securityProperties;
    private Hashtable m_properties = new Hashtable();
    private LDAPConnection m_referralConnection;
    private static final Float SdkVersion = new Float(4.2f);
    private static final Float ProtocolVersion = new Float(3.0f);
    private static final String SecurityVersion = new String("none,simple,sasl");
    private static final Float MajorVersion = new Float(4.0f);
    private static final Float MinorVersion = new Float(0.2f);
    private static final String DELIM = "#";
    private static final String PersistSearchPackageName = "netscape.ldap.controls.LDAPPersistSearchControl";
    static final String EXTERNAL_MECHANISM = "external";
    private static final String EXTERNAL_MECHANISM_PACKAGE = "com.netscape.sasl";
    static final String DEFAULT_SASL_PACKAGE = "com.netscape.sasl";
    static final String SCHEMA_BUG_PROPERTY = "com.netscape.ldap.schema.quoting";
    static final String SASL_PACKAGE_PROPERTY = "com.netscape.ldap.saslpackage";
    public static final int MAXBACKLOG = 30;
    private static boolean isCommunicator = LDAPConnection.checkCommunicator();
    private static boolean debug = false;

    public LDAPConnection() {
        this.m_properties.put(LDAP_PROPERTY_SDK, SdkVersion);
        this.m_properties.put(LDAP_PROPERTY_PROTOCOL, ProtocolVersion);
        this.m_properties.put(LDAP_PROPERTY_SECURITY, SecurityVersion);
        this.m_properties.put("version.major", MajorVersion);
        this.m_properties.put("version.minor", MinorVersion);
    }

    public LDAPConnection(LDAPSocketFactory lDAPSocketFactory) {
        this();
        this.m_factory = lDAPSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finalize() throws LDAPException, Throwable {
        try {
            if (this.isConnected()) {
                this.disconnect();
            }
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void cloneConnectionManager() {
        this.m_connMgr = (LDAPConnSetupMgr)this.m_connMgr.clone();
    }

    public void setCache(LDAPCache lDAPCache) {
        if (this.m_cache != null) {
            this.m_cache.removeReference();
        }
        if (lDAPCache != null) {
            lDAPCache.addReference();
        }
        this.m_cache = lDAPCache;
        if (this.m_thread != null) {
            this.m_thread.setCache(lDAPCache);
        }
    }

    public LDAPCache getCache() {
        return this.m_cache;
    }

    public Object getProperty(String string) throws LDAPException {
        return this.m_properties.get(string);
    }

    public void setProperty(String string, Object object) throws LDAPException {
        if (string.equalsIgnoreCase(SCHEMA_BUG_PROPERTY)) {
            this.m_properties.put(SCHEMA_BUG_PROPERTY, object);
        } else if (string.equalsIgnoreCase(SASL_PACKAGE_PROPERTY)) {
            this.m_properties.put(SASL_PACKAGE_PROPERTY, object);
        } else if (string.equalsIgnoreCase("debug")) {
            debug = ((String)object).equalsIgnoreCase("true");
        } else if (string.equalsIgnoreCase(TRACE_PROPERTY)) {
            Object object2 = null;
            if (object == null) {
                this.m_properties.remove(TRACE_PROPERTY);
            } else {
                if (this.m_thread != null) {
                    object2 = this.createTraceOutput(object);
                }
                this.m_properties.put(TRACE_PROPERTY, object);
            }
            if (this.m_thread != null) {
                this.m_thread.setTraceOutput(object2);
            }
        } else if (string.equalsIgnoreCase("breakConnection")) {
            this.m_connMgr.breakConnection();
        } else {
            throw new LDAPException("Unknown property: " + string);
        }
    }

    Object createTraceOutput(Object object) throws LDAPException {
        if (object instanceof String) {
            FilterOutputStream filterOutputStream = null;
            String string = (String)object;
            if (string.length() == 0) {
                filterOutputStream = System.err;
            } else {
                try {
                    boolean bl;
                    boolean bl2 = bl = string.charAt(0) == '+';
                    if (bl) {
                        string = string.substring(1);
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
                    filterOutputStream = new BufferedOutputStream(fileOutputStream);
                }
                catch (IOException iOException) {
                    throw new LDAPException("Can not open output trace file " + string + " " + iOException);
                }
            }
            return filterOutputStream;
        }
        if (object instanceof OutputStream) {
            return object;
        }
        if (object instanceof LDAPTraceWriter) {
            return object;
        }
        throw new LDAPException("com.netscape.ldap.trace must be an OutputStream, a file name or an instance of LDAPTraceWriter");
    }

    private void setProtocolVersion(int n) {
        this.m_protocolVersion = n;
    }

    public String getHost() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getHost();
        }
        return null;
    }

    public int getPort() {
        if (this.m_connMgr != null) {
            return this.m_connMgr.getPort();
        }
        return -1;
    }

    public String getAuthenticationDN() {
        return this.m_boundDN;
    }

    public String getAuthenticationPassword() {
        return this.m_boundPasswd;
    }

    public int getConnectTimeout() {
        return this.m_connectTimeout;
    }

    public void setConnectTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Timeout value can not be negative");
        }
        this.m_connectTimeout = n;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        }
    }

    public int getConnSetupDelay() {
        return this.m_connSetupDelay;
    }

    public void setConnSetupDelay(int n) {
        this.m_connSetupDelay = n;
        if (this.m_connMgr != null) {
            this.m_connMgr.setConnSetupDelay(n);
        }
    }

    public LDAPSocketFactory getSocketFactory() {
        return this.m_factory;
    }

    public void setSocketFactory(LDAPSocketFactory lDAPSocketFactory) {
        this.m_factory = lDAPSocketFactory;
        this.m_isTLSFactory = false;
    }

    public synchronized boolean isConnected() {
        return this.m_thread != null && this.m_thread.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        boolean bl = false;
        LDAPConnection lDAPConnection = this;
        synchronized (lDAPConnection) {
            bl = this.m_thread != null && this.m_thread.isBound();
        }
        return bl;
    }

    synchronized void setBound(boolean bl) {
        if (this.m_thread != null) {
            if (!bl) {
                this.m_thread.setBound(false);
            } else if (this.m_saslBinder != null) {
                this.m_thread.setBound(true);
            } else {
                this.m_thread.setBound(!this.isAnonymousUser());
            }
        }
    }

    boolean isAnonymousUser() {
        return this.m_boundDN == null || this.m_boundDN.equals("") || this.m_boundPasswd == null || this.m_boundPasswd.equals("");
    }

    public void connect(String string, int n) throws LDAPException {
        this.connect(string, n, null, null, this.m_defaultConstraints, false);
    }

    public void connect(String string, int n, String string2, String string3) throws LDAPException {
        this.connect(string, n, string2, string3, this.m_defaultConstraints, true);
    }

    public void connect(String string, int n, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.connect(string, n, string2, string3, lDAPConstraints, true);
    }

    public void connect(String string, int n, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.connect(string, n, string2, string3, (LDAPConstraints)lDAPSearchConstraints);
    }

    private void connect(String string, int n, String string2, String string3, LDAPConstraints lDAPConstraints, boolean bl) throws LDAPException {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (string == null || string.equals("")) {
            throw new LDAPException("no host for connection", 89);
        }
        int n2 = n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            int n4 = string4.indexOf(58);
            if (n4 > 0) {
                stringArray[n3] = string4.substring(0, n4);
                nArray[n3] = Integer.parseInt(string4.substring(n4 + 1));
            } else {
                stringArray[n3] = string4;
                nArray[n3] = n2;
            }
            ++n3;
        }
        this.m_connMgr = new LDAPConnSetupMgr(stringArray, nArray, this.m_isTLSFactory ? null : this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
        if (bl) {
            this.authenticate(string2, string3, lDAPConstraints);
        }
    }

    void connect(LDAPUrl[] lDAPUrlArray) throws LDAPException {
        this.m_connMgr = new LDAPConnSetupMgr(lDAPUrlArray, this.m_factory);
        this.m_connMgr.setConnSetupDelay(this.m_connSetupDelay);
        this.m_connMgr.setConnectTimeout(this.m_connectTimeout);
        this.connect();
    }

    public void connect(int n, String string, int n2, String string2, String string3) throws LDAPException {
        this.connect(n, string, n2, string2, string3, this.m_defaultConstraints);
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.setProtocolVersion(n);
        this.connect(string, n2, string2, string3, lDAPConstraints);
    }

    public void connect(int n, String string, int n2, String string2, String string3, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.connect(n, string, n2, string2, string3, (LDAPConstraints)lDAPSearchConstraints);
    }

    private synchronized void connect() throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("no connection parameters", 89);
        }
        if (this.m_thread == null) {
            this.m_thread = new LDAPConnThread(this.m_connMgr, this.m_cache, this.getTraceOutput());
        }
        this.m_thread.connect(this);
        this.checkClientAuth();
    }

    Object getTraceOutput() throws LDAPException {
        Object object = this.m_properties.get(TRACE_PROPERTY);
        if (object != null) {
            return this.createTraceOutput(object);
        }
        try {
            object = System.getProperty(TRACE_PROPERTY);
            if (object != null) {
                return this.createTraceOutput(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void checkClientAuth() throws LDAPException {
        if (this.m_factory != null && this.m_factory instanceof LDAPSSLSocketFactoryExt && ((LDAPSSLSocketFactoryExt)this.m_factory).isClientAuth()) {
            this.authenticate(null, EXTERNAL_MECHANISM, "com.netscape.sasl", null, null);
        }
    }

    public void abandon(LDAPSearchResults lDAPSearchResults) throws LDAPException {
        if (!this.isConnected() || lDAPSearchResults == null) {
            return;
        }
        int n = lDAPSearchResults.getMessageID();
        if (n != -1) {
            this.abandon(n);
        }
    }

    public void authenticate(String string, String string2) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, this.m_defaultConstraints);
    }

    public void authenticate(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, lDAPConstraints);
    }

    public void authenticate(String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.authenticate(string, string2, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void authenticate(int n, String string, String string2) throws LDAPException {
        this.authenticate(n, string, string2, this.m_defaultConstraints);
    }

    public void authenticate(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.m_protocolVersion = n;
        this.m_boundDN = string;
        this.m_boundPasswd = string2;
        this.forceNonSharedConnection();
        this.simpleBind(lDAPConstraints);
    }

    public void authenticate(int n, String string, String string2, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.authenticate(n, string, string2, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void authenticate(String string, Hashtable hashtable, Object object) throws LDAPException {
        String[] stringArray = new String[]{"supportedSaslMechanisms"};
        LDAPEntry lDAPEntry = this.read("", stringArray);
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
        if (lDAPAttribute == null) {
            throw new LDAPException("Not found in root DSE: " + stringArray[0], 16);
        }
        this.authenticate(string, lDAPAttribute.getStringValueArray(), hashtable, object);
    }

    public void authenticate(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, stringArray, "com.netscape.sasl", hashtable, object);
    }

    public void authenticate(String string, String string2, String string3, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, new String[]{string2}, string3, hashtable, object);
    }

    public void authenticate(String string, String[] stringArray, String string2, Hashtable hashtable, Object object) throws LDAPException {
        this.forceNonSharedConnection();
        this.m_boundDN = null;
        this.m_protocolVersion = 3;
        if (hashtable == null) {
            hashtable = new Hashtable();
        }
        this.m_saslBinder = new LDAPSaslBind(string, stringArray, string2, hashtable, object);
        this.m_saslBinder.bind(this);
        this.m_boundDN = string;
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.m_boundDN = string;
        this.m_boundPasswd = string2;
        this.m_protocolVersion = n;
        this.forceNonSharedConnection();
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPBindRequest(n, this.m_boundDN, this.m_boundPasswd), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPResponseListener authenticate(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.authenticate(n, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public void bind(String string, String string2) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, this.m_defaultConstraints);
    }

    public void bind(String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(this.m_protocolVersion, string, string2, lDAPConstraints);
    }

    public void bind(int n, String string, String string2) throws LDAPException {
        this.authenticate(n, string, string2, this.m_defaultConstraints);
    }

    public void bind(int n, String string, String string2, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.authenticate(n, string, string2, lDAPConstraints);
    }

    public void bind(String string, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, hashtable, object);
    }

    public void bind(String string, String[] stringArray, Hashtable hashtable, Object object) throws LDAPException {
        this.authenticate(string, stringArray, hashtable, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTLS() throws LDAPException {
        if (this.m_useTLS) {
            throw new LDAPException("Already using TLS", 80);
        }
        if (this.m_factory == null || !(this.m_factory instanceof LDAPTLSSocketFactory)) {
            throw new LDAPException("No socket factory for the startTLS operation", 80);
        }
        this.m_isTLSFactory = true;
        this.checkConnection(true);
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.isConnected() && this.m_thread.getRequestCount() != 0) {
                throw new LDAPException("Connection has outstanding LDAP operations", 80);
            }
        }
        try {
            serializable = this.extendedOperation(new LDAPExtendedOperation(OID_startTLS, null), this.m_defaultConstraints);
        }
        catch (LDAPException lDAPException) {
            lDAPException.setExtraMessage("Cannot start TLS");
            throw lDAPException;
        }
        try {
            this.m_thread.layerSocket((LDAPTLSSocketFactory)this.m_factory);
            this.m_useTLS = true;
        }
        catch (LDAPException lDAPException) {
            lDAPException.setExtraMessage("Failed to start TLS");
            throw lDAPException;
        }
        catch (Exception exception) {
            throw new LDAPException("Failed to start TLS", 80);
        }
    }

    public boolean isTLS() {
        return this.m_useTLS;
    }

    void forceNonSharedConnection() throws LDAPException {
        this.checkConnection(false);
        if (this.m_thread != null && this.m_thread.getClientCount() > 1) {
            this.reconnect(false);
        }
    }

    private void simpleBind(LDAPConstraints lDAPConstraints) throws LDAPException {
        this.m_saslBinder = null;
        LDAPResponseListener lDAPResponseListener = new LDAPResponseListener(false);
        try {
            if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                this.m_referralConnection.disconnect();
            }
            this.m_referralConnection = null;
            this.setBound(false);
            this.sendRequest(new JDAPBindRequest(this.m_protocolVersion, this.m_boundDN, this.m_boundPasswd), lDAPResponseListener, lDAPConstraints);
            this.checkMsg(lDAPResponseListener.getResponse());
            this.setBound(true);
            this.m_rebindConstraints = (LDAPConstraints)lDAPConstraints.clone();
        }
        catch (LDAPReferralException lDAPReferralException) {
            this.m_referralConnection = this.createReferralConnection(lDAPReferralException, lDAPConstraints);
        }
    }

    synchronized void sendRequest(JDAPProtocolOp jDAPProtocolOp, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            block9: {
                try {
                    this.m_thread.sendRequest(this, jDAPProtocolOp, lDAPMessageQueue, lDAPConstraints);
                    if (!lDAPMessageQueue.isAsynchOp()) {
                        lDAPMessageQueue.waitFirstMessage();
                    }
                    bl = true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new LDAPException(illegalArgumentException.getMessage(), 89);
                }
                catch (NullPointerException nullPointerException) {
                    if (this.isConnected() || bl2) {
                        break;
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 81 && !bl2) break block9;
                    throw lDAPException;
                }
            }
            if (bl || bl2) continue;
            bl2 = true;
            lDAPMessageQueue.reset();
            if (this.m_thread != null) {
                this.m_thread.clearRequests();
            }
            boolean bl3 = !(jDAPProtocolOp instanceof JDAPBindRequest);
            this.restoreConnection(bl3);
        }
        if (!bl) {
            throw new LDAPException("Failed to send request", 80);
        }
    }

    private void checkConnection(boolean bl) throws LDAPException {
        if (this.isConnected()) {
            return;
        }
        if (this.m_connMgr == null) {
            throw new LDAPException("not connected", 80);
        }
        this.restoreConnection(bl);
    }

    private void restoreConnection(boolean bl) throws LDAPException {
        this.connect();
        if (this.m_useTLS) {
            this.m_useTLS = false;
            this.startTLS();
        }
        if (!bl) {
            return;
        }
        if (this.m_saslBinder != null) {
            this.m_saslBinder.bind(this, false);
        } else if (this.m_rebindConstraints != null) {
            this.simpleBind(this.m_rebindConstraints);
        }
    }

    public String getAuthenticationMethod() {
        if (!this.isAuthenticated()) {
            return "none";
        }
        return this.m_saslBinder == null ? "simple" : "sasl";
    }

    public void reconnect() throws LDAPException {
        this.reconnect(true);
    }

    void reconnect(boolean bl) throws LDAPException {
        boolean bl2 = this.m_useTLS;
        LDAPConnSetupMgr lDAPConnSetupMgr = this.m_connMgr;
        LDAPConstraints lDAPConstraints = this.m_rebindConstraints;
        this.disconnect();
        this.m_useTLS = bl2;
        this.m_connMgr = lDAPConnSetupMgr;
        this.m_rebindConstraints = lDAPConstraints;
        this.restoreConnection(bl);
    }

    public synchronized void disconnect() throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        this.m_thread.deregister(this);
        if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
            this.m_referralConnection.disconnect();
        }
        this.m_referralConnection = null;
        if (this.m_cache != null) {
            this.m_cache.removeReference();
            this.m_cache = null;
        }
        this.m_responseControlTable.clear();
        this.m_rebindConstraints = null;
        this.m_thread = null;
        this.m_connMgr = null;
        this.m_useTLS = false;
    }

    public LDAPEntry read(String string) throws LDAPException {
        return this.read(string, null, this.m_defaultConstraints);
    }

    public LDAPEntry read(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.read(string, null, lDAPSearchConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray) throws LDAPException {
        return this.read(string, stringArray, this.m_defaultConstraints);
    }

    public LDAPEntry read(String string, String[] stringArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = this.search(string, 0, "(|(objectclass=*)(objectclass=ldapsubentry))", stringArray, false, lDAPSearchConstraints);
        if (lDAPSearchResults == null) {
            return null;
        }
        LDAPEntry lDAPEntry = lDAPSearchResults.next();
        while (lDAPSearchResults.hasMoreElements()) {
            lDAPSearchResults.nextElement();
        }
        return lDAPEntry;
    }

    public static LDAPEntry read(LDAPUrl lDAPUrl) throws LDAPException {
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        LDAPConnection lDAPConnection = new LDAPConnection();
        if (lDAPUrl.isSecure()) {
            LDAPSocketFactory lDAPSocketFactory = lDAPUrl.getSocketFactory();
            if (lDAPSocketFactory == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            lDAPConnection.setSocketFactory(lDAPSocketFactory);
        }
        lDAPConnection.connect(string, n);
        LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray);
        lDAPConnection.disconnect();
        return lDAPEntry;
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl) throws LDAPException {
        return LDAPConnection.search(lDAPUrl, null);
    }

    public static LDAPSearchResults search(LDAPUrl lDAPUrl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        Object object;
        String string = lDAPUrl.getHost();
        int n = lDAPUrl.getPort();
        if (string == null) {
            throw new LDAPException("no host for connection", 89);
        }
        String[] stringArray = lDAPUrl.getAttributeArray();
        String string2 = lDAPUrl.getDN();
        String string3 = lDAPUrl.getFilter();
        if (string3 == null) {
            string3 = defaultFilter;
        }
        int n2 = lDAPUrl.getScope();
        LDAPConnection lDAPConnection = new LDAPConnection();
        if (lDAPUrl.isSecure()) {
            object = lDAPUrl.getSocketFactory();
            if (object == null) {
                throw new LDAPException("No socket factory for LDAPUrl", 80);
            }
            lDAPConnection.setSocketFactory((LDAPSocketFactory)object);
        }
        lDAPConnection.connect(string, n);
        object = lDAPSearchConstraints != null ? lDAPConnection.search(string2, n2, string3, stringArray, false, lDAPSearchConstraints) : lDAPConnection.search(string2, n2, string3, stringArray, false);
        ((LDAPSearchResults)object).closeOnCompletion(lDAPConnection);
        return object;
    }

    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPSearchResults search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.m_defaultConstraints;
        }
        this.m_responseControlTable.clear();
        LDAPSearchResults lDAPSearchResults = new LDAPSearchResults(this, lDAPSearchConstraints, string, n, string2, stringArray, bl);
        Vector vector = null;
        Long l = null;
        boolean bl2 = true;
        try {
            if (this.m_cache != null && (vector = (Vector)this.m_cache.getEntry(l = this.m_cache.createKey(this.getHost(), this.getPort(), string, string2, n, stringArray, this.m_boundDN, lDAPSearchConstraints))) != null) {
                return new LDAPSearchResults(vector, this, lDAPSearchConstraints, string, n, string2, stringArray, bl);
            }
        }
        catch (LDAPException lDAPException) {
            bl2 = false;
            LDAPConnection.printDebug("Exception: " + lDAPException);
        }
        this.checkConnection(true);
        boolean bl3 = false;
        LDAPControl[] lDAPControlArray = (LDAPControl[])LDAPConnection.getOption(12, lDAPSearchConstraints);
        for (int i = 0; lDAPControlArray != null && i < lDAPControlArray.length; ++i) {
            if (!(lDAPControlArray[i] instanceof LDAPPersistSearchControl)) continue;
            bl3 = true;
            break;
        }
        LDAPSearchListener lDAPSearchListener = bl3 ? new LDAPSearchListener(true, lDAPSearchConstraints) : this.getSearchListener(lDAPSearchConstraints);
        int n2 = lDAPSearchConstraints.getDereference();
        JDAPSearchRequest jDAPSearchRequest = null;
        try {
            jDAPSearchRequest = new JDAPSearchRequest(string, n, n2, lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getServerTimeLimit(), bl, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException(illegalArgumentException.getMessage(), 89);
        }
        if (this.m_cache != null && bl2) {
            lDAPSearchListener.setKey(l);
        }
        try {
            this.sendRequest(jDAPSearchRequest, lDAPSearchListener, lDAPSearchConstraints);
        }
        catch (LDAPException lDAPException) {
            lDAPSearchListener = null;
            if (this.m_thread != null) {
                this.m_thread.clearRequests();
            }
            throw lDAPException;
        }
        if (bl3) {
            lDAPSearchResults.associatePersistentSearch(lDAPSearchListener);
        } else {
            if (lDAPSearchConstraints.getBatchSize() == 0) {
                try {
                    LDAPResponse lDAPResponse = lDAPSearchListener.completeSearchOperation();
                    Enumeration enumeration = lDAPSearchListener.getAllMessages().elements();
                    this.checkSearchMsg(lDAPSearchResults, lDAPResponse, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                    while (enumeration.hasMoreElements()) {
                        LDAPMessage lDAPMessage = (LDAPMessage)enumeration.nextElement();
                        this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                    }
                }
                finally {
                    this.releaseSearchListener(lDAPSearchListener);
                }
            }
            LDAPMessage lDAPMessage = lDAPSearchListener.nextMessage();
            if (lDAPMessage instanceof LDAPResponse) {
                try {
                    this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
                }
                finally {
                    this.releaseSearchListener(lDAPSearchListener);
                }
            }
            try {
                this.checkSearchMsg(lDAPSearchResults, lDAPMessage, lDAPSearchConstraints, string, n, string2, stringArray, bl);
            }
            catch (LDAPException lDAPException) {
                this.releaseSearchListener(lDAPSearchListener);
                throw lDAPException;
            }
            lDAPSearchResults.associate(lDAPSearchListener);
        }
        return lDAPSearchResults;
    }

    void checkSearchMsg(LDAPSearchResults lDAPSearchResults, LDAPMessage lDAPMessage, LDAPSearchConstraints lDAPSearchConstraints, String string, int n, String string2, String[] stringArray, boolean bl) throws LDAPException {
        lDAPSearchResults.setMsgID(lDAPMessage.getMessageID());
        try {
            this.checkMsg(lDAPMessage);
            if (lDAPMessage.getProtocolOp().getType() != 5) {
                lDAPSearchResults.add(lDAPMessage);
            }
        }
        catch (LDAPReferralException lDAPReferralException) {
            Vector vector = new Vector();
            try {
                this.performReferrals(lDAPReferralException, lDAPSearchConstraints, 3, string, n, string2, stringArray, bl, null, null, null, vector);
            }
            catch (LDAPException lDAPException) {
                if (lDAPMessage.getProtocolOp() instanceof JDAPSearchResultReference) {
                    if (lDAPSearchConstraints.getReferralErrors() == 0) {
                        return;
                    }
                    throw lDAPException;
                }
                throw lDAPException;
            }
            for (int i = 0; i < vector.size(); ++i) {
                lDAPSearchResults.addReferralEntries((LDAPSearchResults)vector.elementAt(i));
            }
            vector = null;
        }
        catch (LDAPException lDAPException) {
            if (lDAPException.getLDAPResultCode() == 11 || lDAPException.getLDAPResultCode() == 3 || lDAPException.getLDAPResultCode() == 4) {
                lDAPSearchResults.add(lDAPException);
            }
            throw lDAPException;
        }
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute) throws LDAPException {
        return this.compare(string, lDAPAttribute, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        Enumeration enumeration = lDAPAttribute.getStringValues();
        String string2 = (String)enumeration.nextElement();
        JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
        try {
            this.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPConstraints);
            LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
            int n = ((JDAPResult)((Object)lDAPResponse.getProtocolOp())).getResultCode();
            if (n == 5) {
                boolean bl = false;
                return bl;
            }
            if (n == 6) {
                boolean bl = true;
                return bl;
            }
            this.checkMsg(lDAPResponse);
        }
        catch (LDAPReferralException lDAPReferralException) {
            Vector vector = new Vector();
            this.performReferrals(lDAPReferralException, lDAPConstraints, 14, string, 0, null, null, false, null, null, lDAPAttribute, vector);
            boolean bl = false;
            if (vector.size() > 0) {
                bl = (Boolean)vector.elementAt(0);
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
        return false;
    }

    public boolean compare(String string, LDAPAttribute lDAPAttribute, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.compare(string, lDAPAttribute, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void add(LDAPEntry lDAPEntry) throws LDAPException {
        this.add(lDAPEntry, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LDAPEntry lDAPEntry, LDAPConstraints lDAPConstraints) throws LDAPException {
        int n;
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        for (n = 0; n < lDAPAttributeSet.size(); ++n) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
        }
        n = 0;
        try {
            this.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPConstraints);
            LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
            this.checkMsg(lDAPResponse);
        }
        catch (LDAPReferralException lDAPReferralException) {
            this.performReferrals(lDAPReferralException, lDAPConstraints, 8, null, 0, null, null, false, null, lDAPEntry, null, null);
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
    }

    public void add(LDAPEntry lDAPEntry, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.add(lDAPEntry, (LDAPConstraints)lDAPSearchConstraints);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPConstraints lDAPConstraints) throws LDAPException {
        String string;
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPResponse lDAPResponse = null;
        byte[] byArray = null;
        try {
            this.sendRequest(new JDAPExtendedRequest(lDAPExtendedOperation.getID(), lDAPExtendedOperation.getValue()), lDAPResponseListener, lDAPConstraints);
            lDAPResponse = lDAPResponseListener.getResponse();
            this.checkMsg(lDAPResponse);
            JDAPExtendedResponse jDAPExtendedResponse = (JDAPExtendedResponse)lDAPResponse.getProtocolOp();
            byArray = jDAPExtendedResponse.getValue();
            string = jDAPExtendedResponse.getID();
        }
        catch (LDAPReferralException lDAPReferralException) {
            LDAPExtendedOperation lDAPExtendedOperation2 = this.performExtendedReferrals(lDAPReferralException, lDAPConstraints, lDAPExtendedOperation);
            return lDAPExtendedOperation2;
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
        return new LDAPExtendedOperation(string, byArray);
    }

    public LDAPExtendedOperation extendedOperation(LDAPExtendedOperation lDAPExtendedOperation, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        return this.extendedOperation(lDAPExtendedOperation, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModification lDAPModification) throws LDAPException {
        this.modify(string, lDAPModification, this.m_defaultConstraints);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.modify(string, lDAPModificationArray, lDAPConstraints);
    }

    public void modify(String string, LDAPModification lDAPModification, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModification, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet) throws LDAPException {
        this.modify(string, lDAPModificationSet, this.m_defaultConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        for (int i = 0; i < lDAPModificationSet.size(); ++i) {
            lDAPModificationArray[i] = lDAPModificationSet.elementAt(i);
        }
        this.modify(string, lDAPModificationArray, lDAPConstraints);
    }

    public void modify(String string, LDAPModificationSet lDAPModificationSet, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModificationSet, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray) throws LDAPException {
        this.modify(string, lDAPModificationArray, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        LDAPResponse lDAPResponse = null;
        try {
            this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
            lDAPResponse = lDAPResponseListener.getResponse();
            this.checkMsg(lDAPResponse);
        }
        catch (LDAPReferralException lDAPReferralException) {
            this.performReferrals(lDAPReferralException, lDAPConstraints, 6, string, 0, null, null, false, lDAPModificationArray, null, null, null);
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
    }

    public void modify(String string, LDAPModification[] lDAPModificationArray, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.modify(string, lDAPModificationArray, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void delete(String string) throws LDAPException {
        this.delete(string, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String string, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            this.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPConstraints);
            LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
            this.checkMsg(lDAPResponse);
        }
        catch (LDAPReferralException lDAPReferralException) {
            this.performReferrals(lDAPReferralException, lDAPConstraints, 10, string, 0, null, null, false, null, null, null, null);
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
    }

    public void delete(String string, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.delete(string, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void rename(String string, String string2, boolean bl) throws LDAPException {
        this.rename(string, string2, null, bl);
    }

    public void rename(String string, String string2, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.rename(string, string2, null, bl, lDAPConstraints);
    }

    public void rename(String string, String string2, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.rename(string, string2, bl, (LDAPConstraints)lDAPSearchConstraints);
    }

    public void rename(String string, String string2, String string3, boolean bl) throws LDAPException {
        this.rename(string, string2, string3, bl, this.m_defaultConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String string, String string2, String string3, boolean bl, LDAPConstraints lDAPConstraints) throws LDAPException {
        this.checkConnection(true);
        LDAPResponseListener lDAPResponseListener = this.getResponseListener();
        try {
            JDAPModifyRDNRequest jDAPModifyRDNRequest = null;
            jDAPModifyRDNRequest = string3 != null ? new JDAPModifyRDNRequest(string, string2, bl, string3) : new JDAPModifyRDNRequest(string, string2, bl);
            this.sendRequest(jDAPModifyRDNRequest, lDAPResponseListener, lDAPConstraints);
            LDAPResponse lDAPResponse = lDAPResponseListener.getResponse();
            this.checkMsg(lDAPResponse);
        }
        catch (LDAPReferralException lDAPReferralException) {
            this.performReferrals(lDAPReferralException, lDAPConstraints, 12, string, 0, string2, null, bl, null, null, null, null);
        }
        finally {
            this.releaseResponseListener(lDAPResponseListener);
        }
    }

    public void rename(String string, String string2, String string3, boolean bl, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        this.rename(string, string2, string3, bl, (LDAPConstraints)lDAPSearchConstraints);
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.add(lDAPEntry, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener add(LDAPEntry lDAPEntry, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        int n;
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[lDAPAttributeSet.size()];
        for (n = 0; n < lDAPAttributeSet.size(); ++n) {
            lDAPAttributeArray[n] = lDAPAttributeSet.elementAt(n);
        }
        n = 0;
        this.sendRequest(new JDAPAddRequest(lDAPEntry.getDN(), lDAPAttributeArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.bind(n, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.bind(this.m_protocolVersion, string, string2, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener bind(String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        return this.bind(this.m_protocolVersion, string, string2, lDAPResponseListener, lDAPConstraints);
    }

    public LDAPResponseListener bind(int n, String string, String string2, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        return this.authenticate(n, string, string2, lDAPResponseListener, lDAPConstraints);
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.delete(string, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener delete(String string, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPDeleteRequest(string), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.modify(string, lDAPModification, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModification lDAPModification, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[]{lDAPModification};
        this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.modify(string, lDAPModificationSet, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener modify(String string, LDAPModificationSet lDAPModificationSet, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        LDAPModification[] lDAPModificationArray = new LDAPModification[lDAPModificationSet.size()];
        for (int i = 0; i < lDAPModificationSet.size(); ++i) {
            lDAPModificationArray[i] = lDAPModificationSet.elementAt(i);
        }
        this.sendRequest(new JDAPModifyRequest(string, lDAPModificationArray), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.rename(string, string2, bl, lDAPResponseListener, (LDAPConstraints)this.m_defaultConstraints);
    }

    public LDAPResponseListener rename(String string, String string2, boolean bl, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        this.sendRequest(new JDAPModifyRDNRequest(string, string2, bl), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener) throws LDAPException {
        return this.search(string, n, string2, stringArray, bl, lDAPSearchListener, this.m_defaultConstraints);
    }

    public LDAPSearchListener search(String string, int n, String string2, String[] stringArray, boolean bl, LDAPSearchListener lDAPSearchListener, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        if (lDAPSearchConstraints == null) {
            lDAPSearchConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPSearchListener == null) {
            lDAPSearchListener = new LDAPSearchListener(true, lDAPSearchConstraints);
        }
        JDAPSearchRequest jDAPSearchRequest = null;
        try {
            jDAPSearchRequest = new JDAPSearchRequest(string, n, lDAPSearchConstraints.getDereference(), lDAPSearchConstraints.getMaxResults(), lDAPSearchConstraints.getServerTimeLimit(), bl, string2, stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LDAPException(illegalArgumentException.getMessage(), 89);
        }
        this.sendRequest(jDAPSearchRequest, lDAPSearchListener, lDAPSearchConstraints);
        return lDAPSearchListener;
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener) throws LDAPException {
        return this.compare(string, lDAPAttribute, lDAPResponseListener, this.m_defaultConstraints);
    }

    public LDAPResponseListener compare(String string, LDAPAttribute lDAPAttribute, LDAPResponseListener lDAPResponseListener, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints == null) {
            lDAPConstraints = this.m_defaultConstraints;
        }
        this.checkConnection(true);
        if (lDAPResponseListener == null) {
            lDAPResponseListener = new LDAPResponseListener(true);
        }
        Enumeration enumeration = lDAPAttribute.getStringValues();
        String string2 = (String)enumeration.nextElement();
        JDAPAVA jDAPAVA = new JDAPAVA(lDAPAttribute.getName(), string2);
        this.sendRequest(new JDAPCompareRequest(string, jDAPAVA), lDAPResponseListener, lDAPConstraints);
        return lDAPResponseListener;
    }

    public void abandon(int n) throws LDAPException {
        if (!this.isConnected()) {
            return;
        }
        try {
            LDAPControl[] lDAPControlArray = this.m_defaultConstraints.getServerControls();
            this.m_thread.abandon(n, lDAPControlArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void abandon(LDAPSearchListener lDAPSearchListener) throws LDAPException {
        int[] nArray = lDAPSearchListener.getMessageIDs();
        for (int i = 0; i < nArray.length; ++i) {
            lDAPSearchListener.removeRequest(nArray[i]);
            this.abandon(nArray[i]);
        }
    }

    public Object getOption(int n) throws LDAPException {
        if (n == 17) {
            return new Integer(this.m_protocolVersion);
        }
        return LDAPConnection.getOption(n, this.m_defaultConstraints);
    }

    private static Object getOption(int n, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        switch (n) {
            case 2: {
                return new Integer(lDAPSearchConstraints.getDereference());
            }
            case 3: {
                return new Integer(lDAPSearchConstraints.getMaxResults());
            }
            case 4: {
                return new Integer(lDAPSearchConstraints.getServerTimeLimit());
            }
            case 8: {
                return new Boolean(lDAPSearchConstraints.getReferrals());
            }
            case 9: {
                return lDAPSearchConstraints.getRebindProc();
            }
            case 13: {
                return lDAPSearchConstraints.getBindProc();
            }
            case 10: {
                return new Integer(lDAPSearchConstraints.getHopLimit());
            }
            case 20: {
                return new Integer(lDAPSearchConstraints.getBatchSize());
            }
            case 11: {
                return lDAPSearchConstraints.getClientControls();
            }
            case 12: {
                return lDAPSearchConstraints.getServerControls();
            }
            case 30: {
                return new Integer(lDAPSearchConstraints.getMaxBacklog());
            }
        }
        throw new LDAPException("invalid option", 89);
    }

    public void setOption(int n, Object object) throws LDAPException {
        if (n == 17) {
            this.setProtocolVersion((Integer)object);
            return;
        }
        LDAPConnection.setOption(n, object, this.m_defaultConstraints);
    }

    private static void setOption(int n, Object object, LDAPSearchConstraints lDAPSearchConstraints) throws LDAPException {
        try {
            switch (n) {
                case 2: {
                    lDAPSearchConstraints.setDereference((Integer)object);
                    return;
                }
                case 3: {
                    lDAPSearchConstraints.setMaxResults((Integer)object);
                    return;
                }
                case 4: {
                    lDAPSearchConstraints.setTimeLimit((Integer)object);
                    return;
                }
                case 5: {
                    lDAPSearchConstraints.setServerTimeLimit((Integer)object);
                    return;
                }
                case 8: {
                    lDAPSearchConstraints.setReferrals((Boolean)object);
                    return;
                }
                case 13: {
                    lDAPSearchConstraints.setBindProc((LDAPBind)object);
                    return;
                }
                case 9: {
                    lDAPSearchConstraints.setRebindProc((LDAPRebind)object);
                    return;
                }
                case 10: {
                    lDAPSearchConstraints.setHopLimit((Integer)object);
                    return;
                }
                case 20: {
                    lDAPSearchConstraints.setBatchSize((Integer)object);
                    return;
                }
                case 11: {
                    if (object == null) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])null);
                    } else if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setClientControls((LDAPControl)object);
                    } else if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setClientControls((LDAPControl[])object);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 12: {
                    if (object == null) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])null);
                    } else if (object instanceof LDAPControl) {
                        lDAPSearchConstraints.setServerControls((LDAPControl)object);
                    } else if (object instanceof LDAPControl[]) {
                        lDAPSearchConstraints.setServerControls((LDAPControl[])object);
                    } else {
                        throw new LDAPException("invalid LDAPControl", 89);
                    }
                    return;
                }
                case 30: {
                    lDAPSearchConstraints.setMaxBacklog((Integer)object);
                    return;
                }
            }
            throw new LDAPException("invalid option", 89);
        }
        catch (ClassCastException classCastException) {
            throw new LDAPException("invalid option value", 89);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPControl[] getResponseControls() {
        LDAPControl[] lDAPControlArray = null;
        Thread thread = Thread.currentThread();
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            ResponseControls responseControls = (ResponseControls)this.m_responseControlTable.get(thread);
            if (responseControls != null) {
                Vector vector = responseControls.ctrls;
                lDAPControlArray = (LDAPControl[])vector.elementAt(0);
                vector.removeElementAt(0);
                if (vector.size() == 0) {
                    this.m_responseControlTable.remove(thread);
                }
            }
        }
        return lDAPControlArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LDAPControl[] getResponseControls(int n) {
        LDAPControl[] lDAPControlArray = null;
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            Enumeration enumeration = this.m_responseControlTable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                ResponseControls responseControls = (ResponseControls)this.m_responseControlTable.get(k);
                if (n != responseControls.msgID) continue;
                Vector vector = responseControls.ctrls;
                lDAPControlArray = (LDAPControl[])vector.elementAt(0);
                vector.removeElementAt(0);
                if (vector.size() != 0) break;
                this.m_responseControlTable.remove(k);
                break;
            }
        }
        return lDAPControlArray;
    }

    public LDAPConstraints getConstraints() {
        return this.getSearchConstraints();
    }

    public LDAPSearchConstraints getSearchConstraints() {
        return (LDAPSearchConstraints)this.m_defaultConstraints.clone();
    }

    public void setConstraints(LDAPConstraints lDAPConstraints) {
        this.m_defaultConstraints.setHopLimit(lDAPConstraints.getHopLimit());
        this.m_defaultConstraints.setReferrals(lDAPConstraints.getReferrals());
        this.m_defaultConstraints.setTimeLimit(lDAPConstraints.getTimeLimit());
        this.m_defaultConstraints.setBindProc(lDAPConstraints.getBindProc());
        this.m_defaultConstraints.setRebindProc(lDAPConstraints.getRebindProc());
        LDAPControl[] lDAPControlArray = lDAPConstraints.getClientControls();
        LDAPControl[] lDAPControlArray2 = null;
        if (lDAPControlArray != null && lDAPControlArray.length > 0) {
            lDAPControlArray2 = new LDAPControl[lDAPControlArray.length];
            for (int i = 0; i < lDAPControlArray.length; ++i) {
                lDAPControlArray2[i] = (LDAPControl)lDAPControlArray[i].clone();
            }
        }
        this.m_defaultConstraints.setClientControls(lDAPControlArray2);
        LDAPControl[] lDAPControlArray3 = lDAPConstraints.getServerControls();
        LDAPControl[] lDAPControlArray4 = null;
        if (lDAPControlArray3 != null && lDAPControlArray3.length > 0) {
            lDAPControlArray4 = new LDAPControl[lDAPControlArray3.length];
            for (int i = 0; i < lDAPControlArray3.length; ++i) {
                lDAPControlArray4[i] = (LDAPControl)lDAPControlArray3[i].clone();
            }
        }
        this.m_defaultConstraints.setServerControls(lDAPControlArray4);
    }

    public void setSearchConstraints(LDAPSearchConstraints lDAPSearchConstraints) {
        this.m_defaultConstraints = (LDAPSearchConstraints)lDAPSearchConstraints.clone();
    }

    public InputStream getInputStream() {
        return this.m_thread != null ? this.m_thread.getInputStream() : null;
    }

    public void setInputStream(InputStream inputStream) {
        if (this.m_thread != null) {
            this.m_thread.setInputStream(inputStream);
        }
    }

    public OutputStream getOutputStream() {
        return this.m_thread != null ? this.m_thread.getOutputStream() : null;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (this.m_thread != null) {
            this.m_thread.setOutputStream(outputStream);
        }
    }

    synchronized LDAPResponseListener getResponseListener() {
        LDAPResponseListener lDAPResponseListener;
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        if (this.m_responseListeners.size() < 1) {
            lDAPResponseListener = new LDAPResponseListener(false);
        } else {
            lDAPResponseListener = (LDAPResponseListener)this.m_responseListeners.elementAt(0);
            this.m_responseListeners.removeElementAt(0);
        }
        return lDAPResponseListener;
    }

    private synchronized LDAPSearchListener getSearchListener(LDAPSearchConstraints lDAPSearchConstraints) {
        LDAPSearchListener lDAPSearchListener;
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        if (this.m_searchListeners.size() < 1) {
            lDAPSearchListener = new LDAPSearchListener(false, lDAPSearchConstraints);
        } else {
            lDAPSearchListener = (LDAPSearchListener)this.m_searchListeners.elementAt(0);
            this.m_searchListeners.removeElementAt(0);
            lDAPSearchListener.reset();
            lDAPSearchListener.setSearchConstraints(lDAPSearchConstraints);
        }
        return lDAPSearchListener;
    }

    synchronized void releaseResponseListener(LDAPResponseListener lDAPResponseListener) {
        if (this.m_responseListeners == null) {
            this.m_responseListeners = new Vector(5);
        }
        lDAPResponseListener.reset();
        this.m_responseListeners.addElement(lDAPResponseListener);
    }

    synchronized void releaseSearchListener(LDAPSearchListener lDAPSearchListener) {
        if (lDAPSearchListener.isAsynchOp()) {
            return;
        }
        if (this.m_searchListeners == null) {
            this.m_searchListeners = new Vector(5);
        }
        lDAPSearchListener.reset();
        this.m_searchListeners.addElement(lDAPSearchListener);
    }

    void checkMsg(LDAPMessage lDAPMessage) throws LDAPException {
        LDAPControl[] lDAPControlArray = lDAPMessage.getControls();
        int n = lDAPMessage.getMessageID();
        if (lDAPControlArray != null) {
            this.setResponseControls(Thread.currentThread(), n, lDAPControlArray);
        } else {
            this.setResponseControls(Thread.currentThread(), n, null);
        }
        if (lDAPMessage.getProtocolOp() instanceof JDAPResult) {
            JDAPResult jDAPResult = (JDAPResult)((Object)lDAPMessage.getProtocolOp());
            int n2 = jDAPResult.getResultCode();
            if (n2 == 0) {
                return;
            }
            if (n2 == 10) {
                throw new LDAPReferralException("referral", n2, jDAPResult.getReferrals());
            }
            if (n2 == 9) {
                throw new LDAPReferralException("referral", n2, jDAPResult.getErrorMessage());
            }
            throw new LDAPException("error result", n2, jDAPResult.getErrorMessage(), jDAPResult.getMatchedDN());
        }
        if (lDAPMessage.getProtocolOp() instanceof JDAPSearchResultReference) {
            String[] stringArray = ((JDAPSearchResultReference)lDAPMessage.getProtocolOp()).getUrls();
            throw new LDAPReferralException("referral", 0, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResponseControls(Thread thread, int n, LDAPControl[] lDAPControlArray) {
        Hashtable hashtable = this.m_responseControlTable;
        synchronized (hashtable) {
            ResponseControls responseControls = (ResponseControls)this.m_responseControlTable.get(thread);
            if (responseControls == null || responseControls.msgID != n) {
                responseControls = new ResponseControls(n, lDAPControlArray);
                this.m_responseControlTable.put(thread, responseControls);
            } else {
                responseControls.addControls(lDAPControlArray);
            }
        }
    }

    private LDAPConnection referralConnect(LDAPUrl[] lDAPUrlArray, LDAPConstraints lDAPConstraints) throws LDAPException {
        LDAPConnection lDAPConnection = new LDAPConnection(this.getSocketFactory());
        lDAPConnection.setConnSetupDelay(this.getConnSetupDelay());
        lDAPConnection.setOption(8, new Boolean(true));
        lDAPConnection.setOption(9, lDAPConstraints.getRebindProc());
        lDAPConnection.setOption(13, lDAPConstraints.getBindProc());
        Object object = this.getProperty(TRACE_PROPERTY);
        if (object != null) {
            lDAPConnection.setProperty(TRACE_PROPERTY, object);
        }
        lDAPConnection.setOption(17, new Integer(this.m_protocolVersion));
        lDAPConnection.setOption(10, new Integer(lDAPConstraints.getHopLimit() - 1));
        try {
            lDAPConnection.connect(lDAPUrlArray);
        }
        catch (LDAPException lDAPException) {
            throw new LDAPException("Referral connect failed: " + lDAPException.getMessage(), lDAPException.getLDAPResultCode());
        }
        return lDAPConnection;
    }

    private void referralRebind(LDAPConnection lDAPConnection, LDAPConstraints lDAPConstraints) throws LDAPException {
        try {
            if (lDAPConstraints.getRebindProc() == null && lDAPConstraints.getBindProc() == null) {
                lDAPConnection.authenticate(this.m_protocolVersion, null, null);
            } else if (lDAPConstraints.getBindProc() == null) {
                LDAPRebindAuth lDAPRebindAuth = lDAPConstraints.getRebindProc().getRebindAuthentication(lDAPConnection.getHost(), lDAPConnection.getPort());
                lDAPConnection.authenticate(this.m_protocolVersion, lDAPRebindAuth.getDN(), lDAPRebindAuth.getPassword());
            } else {
                lDAPConstraints.getBindProc().bind(lDAPConnection);
            }
        }
        catch (LDAPException lDAPException) {
            throw new LDAPException("Referral bind failed: " + lDAPException.getMessage(), lDAPException.getLDAPResultCode());
        }
    }

    private void adjustReferrals(LDAPUrl[] lDAPUrlArray) {
        String string = null;
        int n = 0;
        for (int i = 0; lDAPUrlArray != null && i < lDAPUrlArray.length; ++i) {
            string = lDAPUrlArray[i].getHost();
            n = lDAPUrlArray[i].getPort();
            if (string != null && string.length() >= 1) continue;
            string = this.getHost();
            n = this.getPort();
            lDAPUrlArray[i] = new LDAPUrl(string, n, lDAPUrlArray[i].getDN(), lDAPUrlArray[i].getAttributeArray(), lDAPUrlArray[i].getScope(), lDAPUrlArray[i].getFilter(), lDAPUrlArray[i].isSecure());
        }
    }

    LDAPConnection createReferralConnection(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (lDAPConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null) {
            throw new LDAPException("No target URL in referral", 94);
        }
        this.adjustReferrals(lDAPUrlArray);
        LDAPConnection lDAPConnection = this.referralConnect(lDAPUrlArray, lDAPConstraints);
        LDAPUrl lDAPUrl = lDAPConnection.m_connMgr.getLDAPUrl();
        String string = lDAPUrl.getDN();
        if (string == null || string.equals("")) {
            string = this.m_boundDN;
        }
        try {
            lDAPConnection.authenticate(this.m_protocolVersion, string, this.m_boundPasswd);
        }
        catch (LDAPException lDAPException) {
            try {
                lDAPConnection.disconnect();
            }
            catch (LDAPException lDAPException2) {
                // empty catch block
            }
            throw lDAPException;
        }
        return lDAPConnection;
    }

    void performReferrals(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, Vector vector) throws LDAPException {
        LDAPUrl lDAPUrl = null;
        LDAPConnection lDAPConnection = null;
        try {
            Object object;
            String string3;
            if (lDAPConstraints.getHopLimit() <= 0) {
                throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
            }
            if (!lDAPConstraints.getReferrals()) {
                if (n == 3) {
                    LDAPSearchResults lDAPSearchResults = new LDAPSearchResults();
                    lDAPSearchResults.add(lDAPReferralException);
                    vector.addElement(lDAPSearchResults);
                    return;
                }
                throw lDAPReferralException;
            }
            LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
            if (lDAPUrlArray == null || lDAPUrlArray.length == 0) {
                return;
            }
            this.adjustReferrals(lDAPUrlArray);
            if (this.m_referralConnection != null && this.m_referralConnection.isConnected()) {
                string3 = this.m_referralConnection.getHost();
                int n3 = this.m_referralConnection.getPort();
                try {
                    object = InetAddress.getByName(string3).getHostAddress();
                    for (int i = 0; i < lDAPUrlArray.length; ++i) {
                        String string4 = lDAPUrlArray[i].getHost();
                        int n4 = lDAPUrlArray[i].getPort();
                        String string5 = InetAddress.getByName(string4).getHostAddress();
                        if (object != string5 || n3 != n4) continue;
                        lDAPUrl = lDAPUrlArray[i];
                        break;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    for (int i = 0; i < lDAPUrlArray.length; ++i) {
                        if (string3 != lDAPUrlArray[i].getHost() || n3 != lDAPUrlArray[i].getPort()) continue;
                        lDAPUrl = lDAPUrlArray[i];
                        break;
                    }
                }
            }
            if (lDAPUrl != null) {
                lDAPConnection = this.m_referralConnection;
            } else {
                lDAPConnection = this.referralConnect(lDAPUrlArray, lDAPConstraints);
                lDAPUrl = lDAPConnection.m_connMgr.getLDAPUrl();
                this.referralRebind(lDAPConnection, lDAPConstraints);
            }
            string3 = lDAPUrl.getDN();
            String string6 = null;
            string6 = string3 == null || string3.equals("") ? string : string3;
            if (lDAPUrl.getUrl().indexOf("?base") > -1) {
                n2 = 0;
            }
            object = (LDAPSearchConstraints)lDAPConstraints.clone();
            ((LDAPConstraints)object).setHopLimit(lDAPConstraints.getHopLimit() - 1);
            this.referralOperation(lDAPConnection, (LDAPConstraints)object, n, string6, n2, string2, stringArray, bl, lDAPModificationArray, lDAPEntry, lDAPAttribute, vector);
        }
        catch (LDAPException lDAPException) {
            if (lDAPUrl != null) {
                lDAPException.setExtraMessage("Failed to follow referral to " + lDAPUrl);
            } else {
                lDAPException.setExtraMessage("Failed to follow referral");
            }
            throw lDAPException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void referralOperation(LDAPConnection lDAPConnection, LDAPConstraints lDAPConstraints, int n, String string, int n2, String string2, String[] stringArray, boolean bl, LDAPModification[] lDAPModificationArray, LDAPEntry lDAPEntry, LDAPAttribute lDAPAttribute, Vector vector) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = null;
        try {
            switch (n) {
                case 3: {
                    lDAPSearchResults = lDAPConnection.search(string, n2, string2, stringArray, bl, (LDAPSearchConstraints)lDAPConstraints);
                    if (lDAPSearchResults != null) {
                        lDAPSearchResults.closeOnCompletion(lDAPConnection);
                        vector.addElement(lDAPSearchResults);
                        break;
                    }
                    if (this.m_referralConnection == null || !lDAPConnection.equals(this.m_referralConnection)) {
                        lDAPConnection.disconnect();
                    }
                    break;
                }
                case 6: {
                    lDAPConnection.modify(string, lDAPModificationArray, lDAPConstraints);
                    break;
                }
                case 8: {
                    if (string != null && !string.equals("")) {
                        lDAPEntry.setDN(string);
                    }
                    lDAPConnection.add(lDAPEntry, lDAPConstraints);
                    break;
                }
                case 10: {
                    lDAPConnection.delete(string, lDAPConstraints);
                    break;
                }
                case 12: {
                    lDAPConnection.rename(string, string2, bl, lDAPConstraints);
                    break;
                }
                case 14: {
                    boolean bl2 = lDAPConnection.compare(string, lDAPAttribute, lDAPConstraints);
                    vector.addElement(new Boolean(bl2));
                    break;
                }
            }
            {
            }
            Object var16_16 = null;
            if (lDAPConnection == null) return;
            if (n == 3) {
                if (lDAPSearchResults != null) return;
            }
            if (this.m_referralConnection != null) {
                if (lDAPConnection.equals(this.m_referralConnection)) return;
            }
            lDAPConnection.disconnect();
            return;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (lDAPConnection == null) throw throwable;
            if (n == 3) {
                if (lDAPSearchResults != null) throw throwable;
            }
            if (this.m_referralConnection != null) {
                if (lDAPConnection.equals(this.m_referralConnection)) throw throwable;
            }
            lDAPConnection.disconnect();
            throw throwable;
        }
    }

    private LDAPExtendedOperation performExtendedReferrals(LDAPReferralException lDAPReferralException, LDAPConstraints lDAPConstraints, LDAPExtendedOperation lDAPExtendedOperation) throws LDAPException {
        if (lDAPConstraints.getHopLimit() <= 0) {
            throw new LDAPException("exceed hop limit", lDAPReferralException.getLDAPResultCode(), lDAPReferralException.getLDAPErrorMessage());
        }
        if (!lDAPConstraints.getReferrals()) {
            throw lDAPReferralException;
        }
        LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
        if (lDAPUrlArray == null || lDAPUrlArray.length == 0) {
            return null;
        }
        this.adjustReferrals(lDAPUrlArray);
        LDAPConnection lDAPConnection = this.referralConnect(lDAPUrlArray, lDAPConstraints);
        this.referralRebind(lDAPConnection, lDAPConstraints);
        LDAPExtendedOperation lDAPExtendedOperation2 = lDAPConnection.extendedOperation(lDAPExtendedOperation);
        lDAPConnection.disconnect();
        return lDAPExtendedOperation2;
    }

    public synchronized Object clone() {
        LDAPConnection lDAPConnection = null;
        try {
            if (this.m_thread != null) {
                this.checkConnection(true);
            }
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
        try {
            lDAPConnection = (LDAPConnection)super.clone();
            lDAPConnection.m_defaultConstraints = (LDAPSearchConstraints)this.m_defaultConstraints.clone();
            lDAPConnection.m_responseListeners = null;
            lDAPConnection.m_searchListeners = null;
            lDAPConnection.m_properties = (Hashtable)this.m_properties.clone();
            lDAPConnection.m_responseControlTable = new Hashtable();
            if (lDAPConnection.m_cache != null) {
                lDAPConnection.m_cache.addReference();
            }
            if (this.isConnected()) {
                lDAPConnection.m_thread.register(lDAPConnection);
            } else {
                lDAPConnection.m_thread = null;
                lDAPConnection.m_connMgr = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lDAPConnection;
    }

    private static boolean checkCommunicator() {
        try {
            Method method = LDAPCheckComm.getMethod("netscape.security.PrivilegeManager", "enablePrivilege");
            if (method == null) {
                LDAPConnection.printDebug("Method is null");
                return false;
            }
            Object[] objectArray = new Object[]{new String("UniversalConnect")};
            method.invoke(null, objectArray);
            LDAPConnection.printDebug("UniversalConnect enabled");
            objectArray[0] = new String("UniversalPropertyRead");
            method.invoke(null, objectArray);
            LDAPConnection.printDebug("UniversalPropertyRead enabled");
            return true;
        }
        catch (LDAPException lDAPException) {
            LDAPConnection.printDebug("Exception: " + lDAPException.toString());
        }
        catch (Exception exception) {
            LDAPConnection.printDebug("Exception on invoking enablePrivilege: " + exception.toString());
        }
        return false;
    }

    public static boolean isNetscape() {
        return isCommunicator;
    }

    static void printDebug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public String toString() {
        int n = this.m_thread == null ? 0 : this.m_thread.getClientCount();
        StringBuffer stringBuffer = new StringBuffer("LDAPConnection {");
        if (this.m_connMgr != null) {
            stringBuffer.append(this.m_connMgr.getLDAPUrl().getServerUrl());
        }
        if (n > 1) {
            stringBuffer.append(" (");
            stringBuffer.append(n);
            stringBuffer.append(")");
        }
        stringBuffer.append(" ldapVersion:");
        stringBuffer.append(this.m_protocolVersion);
        stringBuffer.append(" bindDN:\"");
        if (this.getAuthenticationDN() != null) {
            stringBuffer.append(this.getAuthenticationDN());
        }
        stringBuffer.append("\"}");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println("LDAP SDK Version is " + SdkVersion);
        System.out.println("LDAP Protocol Version is " + ProtocolVersion);
    }

    class ResponseControls {
        int msgID;
        Vector ctrls;

        public ResponseControls(int n, LDAPControl[] lDAPControlArray) {
            this.msgID = n;
            this.ctrls = new Vector();
            this.ctrls.addElement(lDAPControlArray);
        }

        void addControls(LDAPControl[] lDAPControlArray) {
            this.ctrls.addElement(lDAPControlArray);
        }
    }
}

