/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.encoding.Encoding;
import org.joni.exception.JOniException;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Regexp"})
public class RubyRegexp
extends RubyObject
implements ReOptions,
WarnCallback {
    private KCode kcode;
    private Regex pattern;
    private ByteList str;
    private static final int REGEXP_LITERAL_F = 2048;
    private static final int REGEXP_KCODE_DEFAULT = 4096;
    static volatile SoftReference<Map<ByteList, Regex>> patternCache = new SoftReference<Object>(null);
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyRegexp instance = new RubyRegexp(runtime, klass);
            return instance;
        }
    };
    private static final int REGEX_QUOTED = 1;
    private static final int EMBEDDABLE = 7;

    public void setLiteral() {
        this.flags |= 0x800;
    }

    public void clearLiteral() {
        this.flags &= 0xFFFFF7FF;
    }

    public boolean isLiteral() {
        return (this.flags & 0x800) != 0;
    }

    public void setKCodeDefault() {
        this.flags |= 0x1000;
    }

    public void clearKCodeDefault() {
        this.flags &= 0xFFFFEFFF;
    }

    public boolean isKCodeDefault() {
        return (this.flags & 0x1000) != 0;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    private static Map<ByteList, Regex> getPatternCache() {
        Map<ByteList, Regex> cache = patternCache.get();
        if (cache == null) {
            cache = new ConcurrentHashMap<ByteList, Regex>(5);
            patternCache = new SoftReference<Map<ByteList, Regex>>(cache);
        }
        return cache;
    }

    public static RubyClass createRegexpClass(Ruby runtime) {
        RubyClass regexpClass = runtime.defineClass("Regexp", runtime.getObject(), REGEXP_ALLOCATOR);
        runtime.setRegexp(regexpClass);
        regexpClass.index = 9;
        regexpClass.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyRegexp;
            }
        };
        regexpClass.defineConstant("IGNORECASE", runtime.newFixnum(1));
        regexpClass.defineConstant("EXTENDED", runtime.newFixnum(2));
        regexpClass.defineConstant("MULTILINE", runtime.newFixnum(4));
        regexpClass.defineAnnotatedMethods(RubyRegexp.class);
        return regexpClass;
    }

    private RubyRegexp(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private RubyRegexp(Ruby runtime) {
        super(runtime, runtime.getRegexp());
    }

    public static RubyRegexp newRegexp(Ruby runtime, String pattern, int options) {
        return RubyRegexp.newRegexp(runtime, ByteList.create(pattern), options);
    }

    public static RubyRegexp newRegexp(Ruby runtime, ByteList pattern, int options) {
        RubyRegexp regexp = RubyRegexp.newRegexp(runtime, pattern, options, false);
        regexp.setLiteral();
        return regexp;
    }

    public static RubyRegexp newRegexp(Ruby runtime, ByteList pattern, int options, boolean quote) {
        RubyRegexp regexp = new RubyRegexp(runtime);
        regexp.initialize(pattern, options, quote);
        return regexp;
    }

    @Override
    public void warn(String message) {
        this.getRuntime().getWarnings().warn(IRubyWarnings.ID.MISCELLANEOUS, message, new Object[0]);
    }

    @JRubyMethod(name={"kcode"})
    public IRubyObject kcode(ThreadContext context) {
        return !this.isKCodeDefault() && this.kcode != null ? context.getRuntime().newString(this.kcode.name()) : context.getRuntime().getNil();
    }

    @Override
    public int getNativeTypeIndex() {
        return 9;
    }

    public Regex getPattern() {
        return this.pattern;
    }

    private void check() {
        if (this.pattern == null || this.str == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        this.check();
        int hashval = this.pattern.getOptions();
        int len = this.str.realSize;
        int p = this.str.begin;
        while (len-- > 0) {
            hashval = hashval * 33 + this.str.bytes[p++];
        }
        hashval += hashval >> 5;
        return this.getRuntime().newFixnum(hashval);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"}, required=1)
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (this == other) {
            return context.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return context.getRuntime().getFalse();
        }
        RubyRegexp otherRegex = (RubyRegexp)other;
        this.check();
        otherRegex.check();
        return context.getRuntime().newBoolean(this.str.equal(otherRegex.str) && this.kcode == otherRegex.kcode && this.pattern.getOptions() == otherRegex.pattern.getOptions());
    }

    @JRubyMethod(name={"~"}, reads={FrameField.LASTLINE, FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_match2(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        IRubyObject line = context.getCurrentFrame().getLastLine();
        if (!(line instanceof RubyString)) {
            context.getCurrentFrame().setBackRef(runtime.getNil());
            return runtime.getNil();
        }
        int start = this.search(context, (RubyString)line, 0, false);
        if (start < 0) {
            return runtime.getNil();
        }
        return runtime.newFixnum(start);
    }

    @JRubyMethod(name={"==="}, required=1, writes={FrameField.BACKREF})
    public IRubyObject eqq(ThreadContext context, IRubyObject str) {
        Ruby runtime = context.getRuntime();
        if (!(str instanceof RubyString)) {
            str = str.checkStringType();
        }
        if (str.isNil()) {
            context.getCurrentFrame().setBackRef(runtime.getNil());
            return runtime.getFalse();
        }
        int start = this.search(context, (RubyString)str, 0, false);
        return start < 0 ? runtime.getFalse() : runtime.getTrue();
    }

    private void initialize(ByteList bytes, int options, boolean quote) {
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify regexp");
        }
        this.checkFrozen();
        if (this.isLiteral()) {
            throw this.getRuntime().newSecurityError("can't modify literal regexp");
        }
        this.setKCode(options);
        Map<ByteList, Regex> cache = RubyRegexp.getPatternCache();
        Regex pat = cache.get(bytes);
        if (pat != null && pat.getEncoding() == this.kcode.getEncoding() && pat.getOptions() == (options & 0xF) && (pat.getUserOptions() & 1) != 0 == quote) {
            this.pattern = pat;
        } else {
            if (quote) {
                bytes = RubyRegexp.quote(bytes, this.getRuntime().getKCode());
            }
            this.makeRegexp(bytes, bytes.begin, bytes.realSize, options & 0xF, this.kcode.getEncoding());
            if (quote) {
                this.pattern.setUserOptions(1);
            }
            cache.put(bytes, this.pattern);
        }
        this.str = bytes;
    }

    private void makeRegexp(ByteList bytes, int start, int len, int flags, Encoding enc) {
        try {
            this.pattern = new Regex(bytes.bytes, start, start + len, flags, enc, Syntax.DEFAULT, this);
        }
        catch (Exception e) {
            this.rb_reg_raise(bytes.bytes, start, len, e.getMessage(), flags);
        }
    }

    private final void rb_reg_raise(byte[] s, int start, int len, String err, int flags) {
        throw this.getRuntime().newRegexpError(err + ": " + this.rb_reg_desc(s, start, len, flags));
    }

    private final StringBuilder rb_reg_desc(byte[] s, int start, int len, int flags) {
        StringBuilder sb = new StringBuilder("/");
        this.rb_reg_expr_str(sb, s, start, len);
        sb.append("/");
        if ((flags & 4) != 0) {
            sb.append("m");
        }
        if ((flags & 1) != 0) {
            sb.append("i");
        }
        if ((flags & 2) != 0) {
            sb.append("x");
        }
        if (this.kcode != null && !this.isKCodeDefault()) {
            sb.append(this.kcode.name().charAt(0));
        }
        return sb;
    }

    private final void rb_reg_expr_str(StringBuilder sb, byte[] s, int start, int len) {
        int p;
        boolean need_escape = false;
        int pend = start + len;
        Encoding enc = this.kcode.getEncoding();
        for (p = start; p < pend; p += enc.length(s[p])) {
            if (s[p] != 47 && (32 == s[p] || !Character.isWhitespace(s[p]) && !Character.isISOControl(s[p]) || enc.length(s[p]) != 1)) continue;
            need_escape = true;
            break;
        }
        if (!need_escape) {
            sb.append(new ByteList(s, start, len, false).toString());
        } else {
            p = 0;
            while (p < pend) {
                if (s[p] == 92) {
                    int n = enc.length(s[p + 1]) + 1;
                    sb.append(new ByteList(s, p, n, false).toString());
                    p += n;
                    continue;
                }
                if (s[p] == 47) {
                    sb.append("\\/");
                } else {
                    if (enc.length(s[p]) != 1) {
                        sb.append(new ByteList(s, p, enc.length(s[p]), false).toString());
                        p += enc.length(s[p]);
                        continue;
                    }
                    if (32 == s[p] || !Character.isWhitespace(s[p]) && !Character.isISOControl(s[p])) {
                        sb.append((char)(s[p] & 0xFF));
                    } else if (!Character.isWhitespace((char)(s[p] & 0xFF))) {
                        sb.append('\\');
                        sb.append(Integer.toString(s[p] & 0xFF, 8));
                    } else {
                        sb.append((char)(s[p] & 0xFF));
                    }
                }
                ++p;
            }
        }
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject re) {
        if (this == re) {
            return this;
        }
        this.checkFrozen();
        if (this.getMetaClass().getRealClass() != re.getMetaClass().getRealClass()) {
            throw this.getRuntime().newTypeError("wrong argument type");
        }
        RubyRegexp regexp = (RubyRegexp)re;
        regexp.check();
        this.initialize(regexp.str, regexp.getOptions(), false);
        return this;
    }

    private int getKcode() {
        if (this.kcode == KCode.NONE) {
            return 16;
        }
        if (this.kcode == KCode.EUC) {
            return 32;
        }
        if (this.kcode == KCode.SJIS) {
            return 48;
        }
        if (this.kcode == KCode.UTF8) {
            return 64;
        }
        return 0;
    }

    private void setKCode(int options) {
        this.clearKCodeDefault();
        switch (options & 0xFFFFFFF0) {
            default: {
                this.setKCodeDefault();
                this.kcode = this.getRuntime().getKCode();
                break;
            }
            case 16: {
                this.kcode = KCode.NONE;
                break;
            }
            case 32: {
                this.kcode = KCode.EUC;
                break;
            }
            case 48: {
                this.kcode = KCode.SJIS;
                break;
            }
            case 64: {
                this.kcode = KCode.UTF8;
            }
        }
    }

    private int getOptions() {
        this.check();
        int options = this.pattern.getOptions() & 7;
        if (!this.isKCodeDefault()) {
            options |= this.getKcode();
        }
        return options;
    }

    @JRubyMethod(name={"initialize"}, optional=3, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_m(IRubyObject[] args) {
        ByteList bytes;
        int regexFlags = 0;
        if (args[0] instanceof RubyRegexp) {
            if (args.length > 1) {
                this.getRuntime().getWarnings().warn(IRubyWarnings.ID.REGEXP_IGNORED_FLAGS, "flags" + (args.length == 3 ? " and encoding" : "") + " ignored", new Object[0]);
            }
            RubyRegexp regexp = (RubyRegexp)args[0];
            regexp.check();
            regexFlags = regexp.pattern.getOptions() & 0xF;
            if (!regexp.isKCodeDefault() && regexp.kcode != null && regexp.kcode != KCode.NIL) {
                if (regexp.kcode == KCode.NONE) {
                    regexFlags |= 0x10;
                } else if (regexp.kcode == KCode.EUC) {
                    regexFlags |= 0x20;
                } else if (regexp.kcode == KCode.SJIS) {
                    regexFlags |= 0x30;
                } else if (regexp.kcode == KCode.UTF8) {
                    regexFlags |= 0x40;
                }
            }
            bytes = regexp.str;
        } else {
            if (args.length >= 2) {
                if (args[1] instanceof RubyFixnum) {
                    regexFlags = RubyNumeric.fix2int(args[1]);
                } else if (args[1].isTrue()) {
                    regexFlags = 1;
                }
            }
            if (args.length == 3 && !args[2].isNil()) {
                ByteList kcodeBytes = args[2].convertToString().getByteList();
                char first = kcodeBytes.length() > 0 ? kcodeBytes.charAt(0) : (char)'\u0000';
                regexFlags &= 0xFFFFFF8F;
                switch (first) {
                    case 'N': 
                    case 'n': {
                        regexFlags |= 0x10;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        regexFlags |= 0x20;
                        break;
                    }
                    case 'S': 
                    case 's': {
                        regexFlags |= 0x30;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        regexFlags |= 0x40;
                        break;
                    }
                }
            }
            bytes = args[0].convertToString().getByteList();
        }
        this.initialize(bytes, regexFlags, false);
        return this;
    }

    @JRubyMethod(name={"new", "compile"}, required=1, optional=2, meta=true)
    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyRegexp re = (RubyRegexp)klass.allocate();
        re.callInit(args, Block.NULL_BLOCK);
        return re;
    }

    @JRubyMethod(name={"options"})
    public IRubyObject options() {
        return this.getRuntime().newFixnum(this.getOptions());
    }

    public int search(ThreadContext context, RubyString str, int pos, boolean reverse) {
        Ruby runtime = context.getRuntime();
        Frame frame = context.getCurrentRubyFrame();
        ByteList value = str.getByteList();
        if (pos > value.realSize || pos < 0) {
            frame.setBackRef(runtime.getNil());
            return -1;
        }
        return this.performSearch(reverse, pos, value, frame, runtime, context, str);
    }

    private int performSearch(boolean reverse, int pos, ByteList value, Frame frame, Ruby runtime, ThreadContext context, RubyString str) {
        this.check();
        int realSize = value.realSize;
        int begin = value.begin;
        int range = reverse ? -pos : realSize - pos;
        Matcher matcher = this.pattern.matcher(value.bytes, begin, begin + realSize);
        int result = matcher.search(begin + pos, begin + pos + range, 0);
        if (result < 0) {
            frame.setBackRef(runtime.getNil());
            return result;
        }
        this.updateBackRef(context, str, frame, matcher);
        return result;
    }

    final RubyMatchData updateBackRef(ThreadContext context, RubyString str, Frame frame, Matcher matcher) {
        RubyMatchData match;
        Ruby runtime = context.getRuntime();
        IRubyObject backref = frame.getBackRef();
        if (backref == null || backref.isNil() || ((RubyMatchData)backref).used()) {
            match = new RubyMatchData(runtime);
        } else {
            match = (RubyMatchData)backref;
            match.setTaint(runtime.getSafeLevel() >= 3);
        }
        match.regs = matcher.getRegion();
        match.begin = matcher.getBegin();
        match.end = matcher.getEnd();
        match.str = (RubyString)str.strDup(runtime).freeze(context);
        match.pattern = this.pattern;
        frame.setBackRef(match);
        match.infectBy(this);
        match.infectBy(str);
        return match;
    }

    @Override
    @JRubyMethod(name={"=~"}, required=1, reads={FrameField.BACKREF}, writes={FrameField.BACKREF})
    public IRubyObject op_match(ThreadContext context, IRubyObject str) {
        if (str.isNil()) {
            context.getCurrentFrame().setBackRef(context.getRuntime().getNil());
            return str;
        }
        int start = this.search(context, str.convertToString(), 0, false);
        if (start < 0) {
            return context.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(context.getRuntime(), start);
    }

    @JRubyMethod(name={"match"}, required=1, reads={FrameField.BACKREF})
    public IRubyObject match_m(ThreadContext context, IRubyObject str) {
        if (this.op_match(context, str).isNil()) {
            return context.getRuntime().getNil();
        }
        IRubyObject result = context.getCurrentFrame().getBackRef();
        if (result instanceof RubyMatchData) {
            ((RubyMatchData)result).use();
        }
        return result;
    }

    public RubyString regsub(RubyString str, RubyString src, Matcher matcher) {
        Region regs = matcher.getRegion();
        int mbeg = matcher.getBegin();
        int mend = matcher.getEnd();
        int s = 0;
        int p = 0;
        int no = -1;
        ByteList bs = str.getByteList();
        ByteList srcbs = src.getByteList();
        int e = bs.length();
        RubyString val = null;
        Encoding enc = this.kcode.getEncoding();
        block8: while (s < e) {
            char c;
            int ss = s;
            if (enc.length((byte)(c = bs.charAt(s++))) != 1) {
                s += enc.length((byte)c) - 1;
                continue;
            }
            if (c != '\\' || s == e) continue;
            if (val == null) {
                val = RubyString.newString(this.getRuntime(), new ByteList(ss - p));
            }
            val.cat(bs.bytes, bs.begin + p, ss - p);
            c = bs.charAt(s++);
            p = s;
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    no = c - 48;
                    break;
                }
                case '&': {
                    no = 0;
                    break;
                }
                case '`': {
                    int beg = regs == null ? mbeg : regs.beg[0];
                    val.cat(srcbs.bytes, srcbs.begin, beg);
                    continue block8;
                }
                case '\'': {
                    int end = regs == null ? mend : regs.end[0];
                    val.cat(srcbs.bytes, srcbs.begin + end, src.getByteList().realSize - end);
                    continue block8;
                }
                case '+': {
                    if (regs == null) {
                        if (mbeg != -1) break;
                        no = 0;
                        continue block8;
                    }
                    for (no = regs.numRegs - 1; regs.beg[no] == -1 && no > 0; --no) {
                    }
                    if (no != 0) break;
                    continue block8;
                }
                case '\\': {
                    val.cat(bs.bytes, s - 1, 1);
                    continue block8;
                }
                default: {
                    val.cat(bs.bytes, s - 2, 2);
                    continue block8;
                }
            }
            if (regs != null) {
                if (no < 0 || no >= regs.numRegs || regs.beg[no] == -1) continue;
                val.cat(srcbs.bytes, srcbs.begin + regs.beg[no], regs.end[no] - regs.beg[no]);
                continue;
            }
            if (no != 0 || mbeg == -1) continue;
            val.cat(srcbs.bytes, srcbs.begin + mbeg, mend - mbeg);
        }
        if (p < e) {
            if (val == null) {
                val = RubyString.newString(this.getRuntime(), bs.makeShared(p, e - p));
            } else {
                val.cat(bs.bytes, bs.begin + p, e - p);
            }
        }
        if (val == null) {
            return str;
        }
        return val;
    }

    final int adjustStartPos(RubyString str, int pos, boolean reverse) {
        this.check();
        ByteList value = str.getByteList();
        return this.pattern.adjustStartPosition(value.bytes, value.begin, value.realSize, pos, reverse);
    }

    @JRubyMethod(name={"casefold?"})
    public IRubyObject casefold_p(ThreadContext context) {
        this.check();
        return context.getRuntime().newBoolean((this.pattern.getOptions() & 1) != 0);
    }

    @JRubyMethod(name={"source"})
    public IRubyObject source() {
        Ruby runtime = this.getRuntime();
        this.check();
        RubyString str = RubyString.newStringShared(runtime, this.str);
        if (this.isTaint()) {
            str.taint(runtime.getCurrentContext());
        }
        return str;
    }

    final int length() {
        return this.str.realSize;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        this.check();
        return this.getRuntime().newString(ByteList.create(this.rb_reg_desc(this.str.bytes, this.str.begin, this.str.realSize, this.pattern.getOptions()).toString()));
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        RubyString ss = this.getRuntime().newString("(?");
        this.check();
        int options = this.pattern.getOptions();
        int ptr = this.str.begin;
        int len = this.str.realSize;
        byte[] bytes = this.str.bytes;
        while (len >= 4 && bytes[ptr] == 40 && bytes[ptr + 1] == 63) {
            boolean err = true;
            ptr += 2;
            if ((len -= 2) > 0) {
                do {
                    if (bytes[ptr] == 109) {
                        options |= 4;
                    } else if (bytes[ptr] == 105) {
                        options |= 1;
                    } else {
                        if (bytes[ptr] != 120) break;
                        options |= 2;
                    }
                    ++ptr;
                } while (--len > 0);
            }
            if (len > 1 && bytes[ptr] == 45) {
                ++ptr;
                --len;
                do {
                    if (bytes[ptr] == 109) {
                        options &= 0xFFFFFFFB;
                    } else if (bytes[ptr] == 105) {
                        options &= 0xFFFFFFFE;
                    } else {
                        if (bytes[ptr] != 120) break;
                        options &= 0xFFFFFFFD;
                    }
                    ++ptr;
                } while (--len > 0);
            }
            if (bytes[ptr] == 41) {
                --len;
                ++ptr;
                continue;
            }
            if (bytes[ptr] == 58 && bytes[ptr + len - 1] == 41) {
                try {
                    Regex regex = new Regex(bytes, ++ptr, ptr + (len -= 2), 0, this.kcode.getEncoding(), Syntax.DEFAULT);
                    err = false;
                }
                catch (JOniException e) {
                    err = true;
                }
            }
            if (!err) break;
            options = this.pattern.getOptions();
            ptr = this.str.begin;
            len = this.str.realSize;
            break;
        }
        if ((options & 4) != 0) {
            ss.cat((byte)109);
        }
        if ((options & 1) != 0) {
            ss.cat((byte)105);
        }
        if ((options & 2) != 0) {
            ss.cat((byte)120);
        }
        if ((options & 7) != 7) {
            ss.cat((byte)45);
            if ((options & 4) == 0) {
                ss.cat((byte)109);
            }
            if ((options & 1) == 0) {
                ss.cat((byte)105);
            }
            if ((options & 2) == 0) {
                ss.cat((byte)120);
            }
        }
        ss.cat((byte)58);
        this.rb_reg_expr_str(ss, ptr, len);
        ss.cat((byte)41);
        ss.infectBy(this);
        return ss;
    }

    private final void rb_reg_expr_str(RubyString ss, int s, int len) {
        int p;
        int pend = p + len;
        boolean need_escape = false;
        Encoding enc = this.kcode.getEncoding();
        for (p = s; p < pend; p += enc.length(this.str.bytes[p])) {
            if (this.str.bytes[p] != 47 && (enc.isPrint(this.str.bytes[p] & 0xFF) || enc.length(this.str.bytes[p]) != 1)) continue;
            need_escape = true;
            break;
        }
        if (!need_escape) {
            ss.cat(this.str.bytes, s, len);
        } else {
            p = s;
            while (p < pend) {
                if (this.str.bytes[p] == 92) {
                    int n = enc.length(this.str.bytes[p + 1]) + 1;
                    ss.cat(this.str.bytes, p, n);
                    p += n;
                    continue;
                }
                if (this.str.bytes[p] == 47) {
                    ss.cat((byte)92);
                    ss.cat(this.str.bytes, p, 1);
                } else {
                    if (enc.length(this.str.bytes[p]) != 1) {
                        ss.cat(this.str.bytes, p, enc.length(this.str.bytes[p]));
                        p += enc.length(this.str.bytes[p]);
                        continue;
                    }
                    if (enc.isPrint(this.str.bytes[p] & 0xFF)) {
                        ss.cat(this.str.bytes, p, 1);
                    } else if (!enc.isSpace(this.str.bytes[p] & 0xFF)) {
                        ss.cat(ByteList.create(Integer.toString(this.str.bytes[p] & 0xFF, 8)));
                    } else {
                        ss.cat(this.str.bytes, p, 1);
                    }
                }
                ++p;
            }
        }
    }

    @JRubyMethod(name={"quote", "escape"}, required=1, optional=1, meta=true)
    public static RubyString quote(IRubyObject recv, IRubyObject[] args) {
        IRubyObject kcode = args.length == 2 ? args[1] : null;
        IRubyObject str = args[0];
        KCode code = recv.getRuntime().getKCode();
        if (kcode != null && !kcode.isNil()) {
            code = KCode.create(recv.getRuntime(), kcode.toString());
        }
        RubyString src = str.convertToString();
        RubyString dst = RubyString.newString(recv.getRuntime(), RubyRegexp.quote(src.getByteList(), code));
        dst.infectBy(src);
        return dst;
    }

    /*
     * Unable to fully structure code
     */
    public static ByteList quote(ByteList str, KCode kcode) {
        block15: {
            bs = str;
            tix = 0;
            s = bs.begin;
            send = s + bs.length();
            enc = kcode.getEncoding();
            while (s < send) {
                block16: {
                    c = (char)(bs.bytes[s] & 255);
                    if (enc.length((byte)c) == 1) break block16;
                    n = enc.length((byte)c);
                    while (n-- > 0 && s < send) {
                        ++s;
                    }
                    --s;
                    ** GOTO lbl-1000
                }
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        break block15;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        ++s;
                        break;
                    }
                }
            }
            return bs;
        }
        b1 = new ByteList(send * 2);
        System.arraycopy(bs.bytes, bs.begin, b1.bytes, b1.begin, s - bs.begin);
        tix += s - bs.begin;
        while (s < send) {
            block18: {
                block17: {
                    c = (char)(bs.bytes[s] & 255);
                    if (enc.length((byte)c) == 1) break block17;
                    n = enc.length((byte)c);
                    while (n-- > 0 && s < send) {
                        b1.bytes[tix++] = bs.bytes[s++];
                    }
                    --s;
                    break block18;
                }
                switch (c) {
                    case '#': 
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '?': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        b1.bytes[tix++] = 92;
                        ** GOTO lbl62
                    }
                    case ' ': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 32;
                        break;
                    }
                    case '\t': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 116;
                        break;
                    }
                    case '\n': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 110;
                        break;
                    }
                    case '\r': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 114;
                        break;
                    }
                    case '\f': {
                        b1.bytes[tix++] = 92;
                        b1.bytes[tix++] = 102;
                        break;
                    }
lbl62:
                    // 2 sources

                    default: {
                        b1.bytes[tix++] = (byte)c;
                    }
                }
            }
            ++s;
        }
        b1.realSize = tix;
        return b1;
    }

    public static IRubyObject nth_match(int nth, IRubyObject match) {
        int end;
        int start;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null) {
            if (nth >= 1) {
                return match.getRuntime().getNil();
            }
            if (nth < 0 && ++nth <= 0) {
                return match.getRuntime().getNil();
            }
            start = m.begin;
            end = m.end;
        } else {
            if (nth >= m.regs.numRegs) {
                return match.getRuntime().getNil();
            }
            if (nth < 0 && (nth += m.regs.numRegs) <= 0) {
                return match.getRuntime().getNil();
            }
            start = m.regs.beg[nth];
            end = m.regs.end[nth];
        }
        if (start == -1) {
            return match.getRuntime().getNil();
        }
        RubyString str = m.str.makeShared(match.getRuntime(), start, end - start);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject last_match(IRubyObject match) {
        return RubyRegexp.nth_match(0, match);
    }

    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return RubyRegexp.last_match_s(context, recv);
            }
            case 1: {
                return RubyRegexp.last_match_s(context, recv, args[0]);
            }
        }
        Arity.raiseArgumentError(recv.getRuntime(), args.length, 0, 1);
        return null;
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv) {
        IRubyObject match = context.getCurrentFrame().getBackRef();
        if (match instanceof RubyMatchData) {
            ((RubyMatchData)match).use();
        }
        return match;
    }

    @JRubyMethod(name={"last_match"}, meta=true, reads={FrameField.BACKREF})
    public static IRubyObject last_match_s(ThreadContext context, IRubyObject recv, IRubyObject nth) {
        IRubyObject match = context.getCurrentFrame().getBackRef();
        if (match.isNil()) {
            return match;
        }
        return RubyRegexp.nth_match(((RubyMatchData)match).backrefNumber(nth), match);
    }

    public static IRubyObject match_pre(IRubyObject match) {
        int beg;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        int n = beg = m.regs == null ? m.begin : m.regs.beg[0];
        if (beg == -1) {
            match.getRuntime().getNil();
        }
        RubyString str = m.str.makeShared(match.getRuntime(), 0, beg);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject match_post(IRubyObject match) {
        int end;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null) {
            if (m.begin == -1) {
                return match.getRuntime().getNil();
            }
            end = m.end;
        } else {
            if (m.regs.beg[0] == -1) {
                return match.getRuntime().getNil();
            }
            end = m.regs.end[0];
        }
        RubyString str = m.str.makeShared(match.getRuntime(), end, m.str.getByteList().realSize - end);
        str.infectBy(match);
        return str;
    }

    public static IRubyObject match_last(IRubyObject match) {
        int i;
        if (match.isNil()) {
            return match;
        }
        RubyMatchData m = (RubyMatchData)match;
        if (m.regs == null || m.regs.beg[0] == -1) {
            return match.getRuntime().getNil();
        }
        for (i = m.regs.numRegs - 1; m.regs.beg[i] == -1 && i > 0; --i) {
        }
        if (i == 0) {
            return match.getRuntime().getNil();
        }
        return RubyRegexp.nth_match(i, match);
    }

    @JRubyMethod(name={"union"}, rest=true, meta=true)
    public static IRubyObject union(ThreadContext context, IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            return RubyRegexp.newRegexp(recv.getRuntime(), ByteList.create("(?!)"), 0, false);
        }
        if (args.length == 1) {
            IRubyObject v = TypeConverter.convertToTypeWithCheck(args[0], recv.getRuntime().getRegexp(), 0, "to_regexp");
            if (!v.isNil()) {
                return v;
            }
            return RubyRegexp.newRegexp(recv.getRuntime(), RubyRegexp.quote(recv, args).getByteList(), 0, false);
        }
        KCode kcode = null;
        IRubyObject kcode_re = recv.getRuntime().getNil();
        RubyString source = recv.getRuntime().newString();
        IRubyObject[] _args = new IRubyObject[3];
        for (int i = 0; i < args.length; ++i) {
            IRubyObject v;
            if (0 < i) {
                source.cat((byte)124);
            }
            if (!(v = TypeConverter.convertToTypeWithCheck(args[i], recv.getRuntime().getRegexp(), 0, "to_regexp")).isNil()) {
                if (!((RubyRegexp)v).isKCodeDefault()) {
                    if (kcode == null) {
                        kcode_re = v;
                        kcode = ((RubyRegexp)v).kcode;
                    } else if (((RubyRegexp)v).kcode != kcode) {
                        IRubyObject str1 = kcode_re.inspect();
                        IRubyObject str2 = v.inspect();
                        throw recv.getRuntime().newArgumentError("mixed kcode " + str1 + " and " + str2);
                    }
                }
                v = ((RubyRegexp)v).to_s();
            } else {
                v = RubyRegexp.quote(recv, new IRubyObject[]{args[i]});
            }
            source.append(v);
        }
        _args[0] = source;
        _args[1] = recv.getRuntime().getNil();
        if (kcode == null) {
            _args[2] = recv.getRuntime().getNil();
        } else if (kcode == KCode.NONE) {
            _args[2] = recv.getRuntime().newString("n");
        } else if (kcode == KCode.EUC) {
            _args[2] = recv.getRuntime().newString("e");
        } else if (kcode == KCode.SJIS) {
            _args[2] = recv.getRuntime().newString("s");
        } else if (kcode == KCode.UTF8) {
            _args[2] = recv.getRuntime().newString("u");
        }
        return recv.callMethod(context, "new", _args);
    }

    @JRubyMethod(name={"names"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject names() {
        if (this.pattern.numberOfNames() == 0) {
            return this.getRuntime().newEmptyArray();
        }
        RubyArray ary = this.getRuntime().newArray(this.pattern.numberOfNames());
        Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
        while (i.hasNext()) {
            NameEntry e = i.next();
            ary.append(RubyString.newStringShared(this.getRuntime(), e.name, e.nameP, e.nameEnd - e.nameP));
        }
        return ary;
    }

    @JRubyMethod(name={"named_captures"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject named_captures(ThreadContext context) {
        RubyHash hash = RubyHash.newHash(this.getRuntime());
        if (this.pattern.numberOfNames() == 0) {
            return hash;
        }
        Iterator<NameEntry> i = this.pattern.namedBackrefIterator();
        while (i.hasNext()) {
            NameEntry e = i.next();
            int[] backrefs = e.getBackRefs();
            RubyArray ary = this.getRuntime().newArray(backrefs.length);
            for (int backref : backrefs) {
                ary.append(RubyFixnum.newFixnum(this.getRuntime(), backref));
            }
            hash.fastASet(RubyString.newStringShared(this.getRuntime(), e.name, e.nameP, e.nameEnd - e.nameP).freeze(context), ary);
        }
        return hash;
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyRegexp result = RubyRegexp.newRegexp(input.getRuntime(), input.unmarshalString(), input.unmarshalInt(), false);
        input.registerLinkTarget(result);
        return result;
    }

    public static void marshalTo(RubyRegexp regexp, MarshalStream output) throws IOException {
        output.registerLinkTarget(regexp);
        output.writeString(new String(regexp.str.bytes, regexp.str.begin, regexp.str.realSize));
        output.writeInt(regexp.pattern.getOptions() & 7);
    }
}

