/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NilClass"})
public class RubyNil
extends RubyObject {
    public static final ObjectAllocator NIL_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return runtime.getNil();
        }
    };

    public RubyNil(Ruby runtime) {
        super(runtime, runtime.getNilClass(), false);
        this.flags |= 3;
    }

    public static RubyClass createNilClass(Ruby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject(), NIL_ALLOCATOR);
        runtime.setNilClass(nilClass);
        nilClass.index = 5;
        nilClass.defineAnnotatedMethods(RubyNil.class);
        nilClass.getMetaClass().undefineMethod("new");
        return nilClass;
    }

    public int getNativeTypeIndex() {
        return 5;
    }

    public boolean isImmediate() {
        return true;
    }

    public RubyClass getSingletonClass() {
        return this.metaClass;
    }

    @JRubyMethod(name={"to_i"})
    public static RubyFixnum to_i(IRubyObject recv) {
        return RubyFixnum.zero(recv.getRuntime());
    }

    @JRubyMethod(name={"to_f"})
    public static RubyFloat to_f(IRubyObject recv) {
        return RubyFloat.newFloat(recv.getRuntime(), 0.0);
    }

    @JRubyMethod(name={"to_s"})
    public static RubyString to_s(IRubyObject recv) {
        return RubyString.newEmptyString(recv.getRuntime());
    }

    @JRubyMethod(name={"to_a"})
    public static RubyArray to_a(IRubyObject recv) {
        return recv.getRuntime().newEmptyArray();
    }

    @JRubyMethod(name={"inspect"})
    public static RubyString inspect(IRubyObject recv) {
        return recv.getRuntime().newString("nil");
    }

    @JRubyMethod(name={"type"})
    public static RubyClass type(IRubyObject recv) {
        return recv.getRuntime().getNilClass();
    }

    @JRubyMethod(name={"&"}, required=1)
    public static RubyBoolean op_and(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().getFalse();
    }

    @JRubyMethod(name={"|"}, required=1)
    public static RubyBoolean op_or(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"^"}, required=1)
    public static RubyBoolean op_xor(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    @JRubyMethod(name={"nil?"})
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4);
    }

    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    public IRubyObject freeze(ThreadContext context) {
        return this;
    }
}

