/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.soa.esb.testutils.IdentitySAXHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StringUtils {
    public static boolean equalsIgnoreLinebreaks(String string1, String string2, boolean ignorecase) {
        string1 = StringUtils.removeChar(string1, '\r');
        string1 = StringUtils.removeChar(string1, '\n');
        string2 = StringUtils.removeChar(string2, '\r');
        string2 = StringUtils.removeChar(string2, '\n');
        if (ignorecase) {
            return string1.equalsIgnoreCase(string2);
        }
        return string1.equals(string2);
    }

    public static String removeChar(String string, char character) {
        StringBuffer stringBuf = new StringBuffer(string);
        int index = 0;
        while (index < stringBuf.length()) {
            if (stringBuf.charAt(index) == character) {
                stringBuf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return stringBuf.toString();
    }

    public static boolean compareXMLContent(String content1, String content2) throws ParserConfigurationException, SAXException, IOException {
        try {
            IdentitySAXHandler handler2;
            IdentitySAXHandler handler1;
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                handler1 = new IdentitySAXHandler();
                parser.parse(new InputSource(new StringReader(content1)), (DefaultHandler)handler1);
            }
            catch (SAXException e) {
                System.out.println("Failed to parse content1 [" + content1 + "].");
                throw e;
            }
            try {
                handler2 = new IdentitySAXHandler();
                parser.parse(new InputSource(new StringReader(content2)), (DefaultHandler)handler2);
            }
            catch (SAXException e) {
                System.out.println("Failed to parse content2 [" + content2 + "].");
                throw e;
            }
            return handler1.getRootElement().equals(handler2.getRootElement());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

