/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.testutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.couriers.MockCourierFactory;
import org.jboss.internal.soa.esb.services.registry.MockRegistry;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.config.ConfigurationController;
import org.jboss.soa.esb.listeners.config.Generator;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleController;
import org.jboss.soa.esb.listeners.lifecycle.ManagedLifecycleException;
import org.jboss.soa.esb.parameters.ParamRepositoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ESBConfigUtil {
    private Generator generator;
    private Document listenerConfig;
    private Document gatewayConfig;
    private ManagedLifecycleController controller;

    public ESBConfigUtil(InputStream esbXsdConfig) {
        AssertArgument.isNotNull((Object)esbXsdConfig, (String)"esbXsdConfig");
        ByteArrayOutputStream listenerConfigStream = new ByteArrayOutputStream();
        ByteArrayOutputStream gatewayConfigStream = new ByteArrayOutputStream();
        this.generator = null;
        try {
            this.generator = new Generator(esbXsdConfig, (OutputStream)listenerConfigStream, (OutputStream)gatewayConfigStream);
            this.generator.generate();
            this.listenerConfig = YADOMUtil.parseStream((InputStream)new ByteArrayInputStream(listenerConfigStream.toByteArray()), (boolean)false, (boolean)false);
            this.gatewayConfig = YADOMUtil.parseStream((InputStream)new ByteArrayInputStream(gatewayConfigStream.toByteArray()), (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCase.fail((String)e.getMessage());
        }
    }

    public ConfigTree getListenerConfig(String listenerName) {
        AssertArgument.isNotNull((Object)listenerName, (String)"listenerName");
        return ConfigTree.fromElement((Element)this.getListenerConfig(listenerName, this.listenerConfig));
    }

    public ConfigTree getGatewayConfig(String gatewayName) {
        AssertArgument.isNotNull((Object)gatewayName, (String)"gatewayName");
        return ConfigTree.fromElement((Element)this.getListenerConfig(gatewayName, this.gatewayConfig));
    }

    private Element getListenerConfig(String name, Document config) {
        NodeList listenerConfigElements = config.getDocumentElement().getElementsByTagName(name);
        if (listenerConfigElements == null || listenerConfigElements.getLength() == 0) {
            return null;
        }
        return (Element)listenerConfigElements.item(0);
    }

    public ConfigTree getActionConfig(String listenerName, String actionName) {
        AssertArgument.isNotNull((Object)listenerName, (String)"listenerName");
        AssertArgument.isNotNull((Object)actionName, (String)"actionName");
        Element listener = this.getListenerConfig(listenerName, this.listenerConfig);
        NodeList actions = listener.getElementsByTagName("action");
        if (actions == null || actions.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < actions.getLength(); ++i) {
            Element action = (Element)actions.item(i);
            if (!actionName.equals(action.getAttribute("action"))) continue;
            return ConfigTree.fromElement((Element)action);
        }
        return null;
    }

    public Document getListenerConfig() {
        return this.listenerConfig;
    }

    public Document getGatewayConfig() {
        return this.gatewayConfig;
    }

    public void startController() throws ParamRepositoryException, ConfigurationException, ManagedLifecycleException, SAXException {
        ConfigTree listenerConfigTree = ConfigTree.fromElement((Element)this.listenerConfig.getDocumentElement());
        ConfigTree gatewayConfigTree = ConfigTree.fromElement((Element)this.gatewayConfig.getDocumentElement());
        MockCourierFactory.install();
        MockRegistry.install();
        this.controller = ConfigurationController.startController((Generator.XMLBeansModel)this.generator.getModel(), (ConfigTree)listenerConfigTree, (ConfigTree)gatewayConfigTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopController() {
        try {
            ConfigurationController.stopController((ManagedLifecycleController)this.controller);
        }
        finally {
            try {
                MockRegistry.uninstall();
            }
            finally {
                MockCourierFactory.uninstall();
            }
        }
    }
}

