/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.couriers;

import java.util.Hashtable;
import java.util.Map;
import org.jboss.internal.soa.esb.couriers.MockCourier;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.MalformedEPRException;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.couriers.CourierFactory;
import org.jboss.soa.esb.couriers.TwoWayCourier;

public class MockCourierFactory
extends CourierFactory {
    public static CourierException courierException;
    public static MalformedEPRException malformedEPRException;
    public static Hashtable<EPR, TwoWayCourier> couriers;
    private static CourierFactory originalInstance;

    public TwoWayCourier getMessageCourier(EPR toEPR) throws CourierException, MalformedEPRException {
        if (courierException != null) {
            throw courierException;
        }
        if (malformedEPRException != null) {
            throw malformedEPRException;
        }
        return couriers.get(toEPR);
    }

    public static void install() {
        originalInstance = CourierFactory.getInstance();
        CourierFactory.setInstance((CourierFactory)new MockCourierFactory());
    }

    public static void uninstall() {
        CourierFactory.setInstance((CourierFactory)originalInstance);
        MockCourierFactory.reset();
    }

    public static void reset() {
        couriers.clear();
        courierException = null;
        malformedEPRException = null;
    }

    public static void resetCouriers() {
        for (Map.Entry<EPR, TwoWayCourier> entry : couriers.entrySet()) {
            ((MockCourier)entry.getValue()).reset();
        }
    }

    static {
        couriers = new Hashtable();
    }
}

