/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.wife.swift.parser;

import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.wife.swift.model.SwiftBlock1;
import net.sourceforge.wife.swift.model.SwiftBlock2;
import net.sourceforge.wife.swift.model.SwiftBlock2Input;
import net.sourceforge.wife.swift.model.SwiftBlock2Output;
import net.sourceforge.wife.swift.model.SwiftBlock3;
import net.sourceforge.wife.swift.model.SwiftBlock4;
import net.sourceforge.wife.swift.model.SwiftBlock5;
import net.sourceforge.wife.swift.model.SwiftBlockUser;
import net.sourceforge.wife.swift.model.SwiftMessage;
import net.sourceforge.wife.swift.model.SwiftTagListBlock;
import net.sourceforge.wife.swift.model.Tag;
import net.sourceforge.wife.swift.model.UnparsedTextList;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLParser {
    private static final transient Logger log = Logger.getLogger(XMLParser.class.getName());

    public SwiftMessage parse(String xml) {
        Validate.notNull((Object)xml);
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(xml.getBytes()));
            return this.createMessage(doc);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error parsing XML", e);
            return null;
        }
    }

    private SwiftMessage createMessage(Document doc) {
        NodeList messageNL = doc.getElementsByTagName("message");
        if (messageNL.getLength() == 1) {
            Node message = messageNL.item(0);
            SwiftMessage m = new SwiftMessage(false);
            NodeList blocksNL = message.getChildNodes();
            if (log.isLoggable(Level.FINE)) {
                log.fine("blocks in message: " + blocksNL.getLength());
            }
            for (int i = 0; i < blocksNL.getLength(); ++i) {
                Node blockNode = blocksNL.item(i);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("evaluating node " + blockNode.getNodeName());
                }
                if (blockNode.getNodeType() != 1) continue;
                String blockName = blockNode.getNodeName();
                if (blockName.equalsIgnoreCase("block1")) {
                    m.setBlock1(this.getBlock1FromNode(blockNode));
                    continue;
                }
                if (blockName.equalsIgnoreCase("block2")) {
                    m.setBlock2(this.getBlock2FromNode(blockNode));
                    continue;
                }
                if (blockName.equalsIgnoreCase("unparsedtexts")) {
                    m.setUnparsedTexts(this.getUnparsedTextsFromNode(blockNode));
                    continue;
                }
                m.addBlock(this.getTagListBlockFromNode(blockNode));
            }
            return m;
        }
        throw new IllegalArgumentException("<message> tag not found");
    }

    private SwiftBlock1 getBlock1FromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " children in <block1>");
        }
        SwiftBlock1 b1 = new SwiftBlock1();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("APPLICATIONID".equalsIgnoreCase(n.getNodeName())) {
                b1.setApplicationId(this.getText(n));
                continue;
            }
            if ("SERVICEID".equalsIgnoreCase(n.getNodeName())) {
                b1.setServiceId(this.getText(n));
                continue;
            }
            if ("LOGICALTERMINAL".equalsIgnoreCase(n.getNodeName())) {
                b1.setLogicalTerminal(this.getText(n));
                continue;
            }
            if ("SESSIONNUMBER".equalsIgnoreCase(n.getNodeName())) {
                b1.setSessionNumber(this.getText(n));
                continue;
            }
            if ("SEQUENCENUMBER".equalsIgnoreCase(n.getNodeName())) {
                b1.setSequenceNumber(this.getText(n));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(n.getNodeName())) continue;
            b1.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b1;
    }

    private String getText(Node n) {
        String text = null;
        Node c = n.getFirstChild();
        if (c.getNodeType() == 3) {
            text = c.getNodeValue().trim();
        } else {
            log.warning("Node is not TEXT_NODE: " + c);
        }
        log.fine("text: " + text);
        return text;
    }

    private SwiftBlock2 getBlock2FromNode(Node blockNode) {
        String type = this.getNodeAttribute(blockNode, "type");
        if (type == null) {
            log.severe("atrribute 'type' was expected but not found at <block2> xml tag");
            return null;
        }
        if (type.equals("input")) {
            return this.getBlock2InputFromNode(blockNode);
        }
        if (type.equals("output")) {
            return this.getBlock2OutputFromNode(blockNode);
        }
        log.severe("expected 'input' or 'output' value for 'type' atribute at <block2> xml tag, and found: " + type);
        return null;
    }

    private SwiftBlock2Input getBlock2InputFromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " childrens in <block2 type=\"input\">");
        }
        SwiftBlock2Input b2 = new SwiftBlock2Input();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessageType(this.getText(n));
                continue;
            }
            if ("RECEIVERADDRESS".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverAddress(this.getText(n));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessagePriority(this.getText(n));
                continue;
            }
            if ("DELIVERYMONITORING".equalsIgnoreCase(n.getNodeName())) {
                b2.setDeliveryMonitoring(this.getText(n));
                continue;
            }
            if ("OBSOLESCENCEPERIOD".equalsIgnoreCase(n.getNodeName())) {
                b2.setObsolescencePeriod(this.getText(n));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(n.getNodeName())) continue;
            b2.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b2;
    }

    private SwiftBlock2Output getBlock2OutputFromNode(Node blockNode) {
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " childrens in <block2 type=\"output\">");
        }
        SwiftBlock2Output b2 = new SwiftBlock2Output();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node n = fields.item(i);
            if ("MESSAGETYPE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessageType(this.getText(n));
                continue;
            }
            if ("SENDERINPUTTIME".equalsIgnoreCase(n.getNodeName())) {
                b2.setSenderInputTime(this.getText(n));
                continue;
            }
            if ("MIRDATE".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRDate(this.getText(n));
                continue;
            }
            if ("MIRLOGICALTERMINAL".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRLogicalTerminal(this.getText(n));
                continue;
            }
            if ("MIRSESSIONNUMBER".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRSessionNumber(this.getText(n));
                continue;
            }
            if ("MIRSEQUENCENUMBER".equalsIgnoreCase(n.getNodeName())) {
                b2.setMIRSequenceNumber(this.getText(n));
                continue;
            }
            if ("RECEIVEROUTPUTDATE".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverOutputDate(this.getText(n));
                continue;
            }
            if ("RECEIVEROUTPUTTIME".equalsIgnoreCase(n.getNodeName())) {
                b2.setReceiverOutputTime(this.getText(n));
                continue;
            }
            if ("MESSAGEPRIORITY".equalsIgnoreCase(n.getNodeName())) {
                b2.setMessagePriority(this.getText(n));
                continue;
            }
            if (!"unparsedTexts".equalsIgnoreCase(n.getNodeName())) continue;
            b2.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return b2;
    }

    private SwiftTagListBlock getTagListBlockFromNode(Node blockNode) {
        String blockName = blockNode.getNodeName();
        SwiftTagListBlock b = null;
        if (blockName.equalsIgnoreCase("block3")) {
            b = new SwiftBlock3();
        } else if (blockName.equalsIgnoreCase("block4")) {
            b = new SwiftBlock4();
        } else if (blockName.equalsIgnoreCase("block5")) {
            b = new SwiftBlock5();
        } else if (blockName.equalsIgnoreCase("block")) {
            String name = this.getNodeAttribute(blockNode, "name");
            b = name != null ? new SwiftBlockUser(name) : new SwiftBlockUser();
        } else {
            return null;
        }
        NodeList fields = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(fields.getLength() + " children in tag list " + blockName);
        }
        for (int j = 0; j < fields.getLength(); ++j) {
            Node t = fields.item(j);
            if ("tag".equalsIgnoreCase(t.getNodeName())) {
                Tag tag = this.getTag(t);
                b.addTag(tag);
                continue;
            }
            if (!"unparsedtexts".equalsIgnoreCase(t.getNodeName())) continue;
            b.setUnparsedTexts(this.getUnparsedTextsFromNode(t));
        }
        return b;
    }

    private Tag getTag(Node t) {
        Tag tag = new Tag();
        NodeList children = t.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if ("name".equalsIgnoreCase(n.getNodeName())) {
                tag.setName(this.getText(n));
            }
            if ("value".equalsIgnoreCase(n.getNodeName())) {
                tag.setValue(this.getText(n));
                continue;
            }
            if (!"unparsedtexts".equalsIgnoreCase(n.getNodeName())) continue;
            tag.setUnparsedTexts(this.getUnparsedTextsFromNode(n));
        }
        return tag;
    }

    private UnparsedTextList getUnparsedTextsFromNode(Node blockNode) {
        UnparsedTextList unparsedTexts = new UnparsedTextList();
        NodeList texts = blockNode.getChildNodes();
        if (log.isLoggable(Level.FINE)) {
            log.fine(texts.getLength() + " children in <unparsedtexts>");
        }
        for (int j = 0; j < texts.getLength(); ++j) {
            Node t = texts.item(j);
            if (!"text".equalsIgnoreCase(t.getNodeName())) continue;
            unparsedTexts.addText(this.getText(t));
        }
        return unparsedTexts;
    }

    private String getNodeAttribute(Node n, String attributeName) {
        Node attr = n.getAttributes().getNamedItem(attributeName);
        if (attr == null || !attr.getNodeName().equals(attributeName)) {
            return null;
        }
        return attr.getNodeValue();
    }

    static {
        log.info("$Id: XMLParser.java,v 1.9 2007/07/25 17:56:08 mikkey Exp $");
    }
}

