/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xmlenc;

import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.xmlenc.EncryptionException;
import com.sun.identity.xmlenc.EncryptionProvider;
import com.sun.identity.xmlenc.EncryptionUtils;
import java.security.Key;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLEncryptionManager {
    private EncryptionProvider ep = null;
    private static XMLEncryptionManager instance = new XMLEncryptionManager();

    protected XMLEncryptionManager() {
        try {
            String encryptClass = SystemPropertiesManager.get("com.sun.identity.xmlenc.EncryptionProviderImpl", "com.sun.identity.xmlenc.AMEncryptionProvider");
            this.ep = (EncryptionProvider)Class.forName(encryptClass).newInstance();
            String kprovider = SystemPropertiesManager.get("com.sun.identity.saml.xmlsig.keyprovider.class", "com.sun.identity.saml.xmlsig.JKSKeyProvider");
            this.ep.initialize((KeyProvider)Class.forName(kprovider).newInstance());
        }
        catch (Exception e) {
            EncryptionUtils.debug.error("XMLEncryptionManager:constructor Exception in constructing xml encryption manager", e);
        }
    }

    protected XMLEncryptionManager(EncryptionProvider encProvider, KeyProvider keyProvider) {
        try {
            encProvider.initialize(keyProvider);
            this.ep = encProvider;
        }
        catch (Exception e) {
            EncryptionUtils.debug.error("XMLEncryptionManager:constructor Exception in constructing xml encryption manager", e);
        }
    }

    public static XMLEncryptionManager getInstance() {
        return instance;
    }

    public static XMLEncryptionManager getInstance(EncryptionProvider encProvider, KeyProvider keyProvider) {
        return new XMLEncryptionManager(encProvider, keyProvider);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keySize, String certAlias) throws EncryptionException {
        return this.ep.encryptAndReplace(doc, element, secretKeyAlg, keySize, certAlias, 0);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keySize, String certAlias, String providerID) throws EncryptionException {
        return this.ep.encryptAndReplace(doc, element, secretKeyAlg, keySize, certAlias, 0, providerID);
    }

    public Document encryptAndReplaceResourceID(Document doc, Element element, String secretKeyAlg, int keySize, String certAlias, String providerID) throws EncryptionException {
        return this.ep.encryptAndReplaceResourceID(doc, element, secretKeyAlg, keySize, certAlias, 0, providerID);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keySize, String certAlias, int kekStrength) throws EncryptionException {
        return this.ep.encryptAndReplace(doc, element, secretKeyAlg, keySize, certAlias, kekStrength);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keySize, Key kek, int kekStrength) throws EncryptionException {
        return this.ep.encryptAndReplace(doc, element, secretKeyAlg, keySize, kek, kekStrength, null);
    }

    public Document encryptAndReplace(Document doc, Element element, String secretKeyAlg, int keySize, Key kek, int kekStrength, String providerID) throws EncryptionException {
        return this.ep.encryptAndReplace(doc, element, secretKeyAlg, keySize, kek, kekStrength, providerID);
    }

    public Document encryptAndReplaceResourceID(Document doc, Element element, String secretKeyAlg, int keySize, Key kek, int kekStrength, String providerID) throws EncryptionException {
        return this.ep.encryptAndReplaceResourceID(doc, element, secretKeyAlg, keySize, kek, kekStrength, providerID);
    }

    public Document encryptAndReplaceWSSElements(Document doc, Map elmMap, String encDataEncAlg, int encDataEncAlgStrength, String certAlias, int kekStrength, String tokenType, String providerID) throws EncryptionException {
        return this.ep.encryptAndReplaceWSSElements(doc, elmMap, encDataEncAlg, encDataEncAlgStrength, certAlias, kekStrength, tokenType, providerID);
    }

    public Document decryptAndReplace(Document encryptedDoc, String kekAlias) throws EncryptionException {
        return this.ep.decryptAndReplace(encryptedDoc, kekAlias);
    }

    public Document decryptAndReplace(Document encryptedDoc, Key privKey) throws EncryptionException {
        return this.ep.decryptAndReplace(encryptedDoc, privKey);
    }
}

