/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.policy.impl;

import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.policy.Obligation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObligationImpl
implements Obligation {
    private URI obligationId = null;
    private String fulfillOn = null;
    private List attributeAssignments = null;
    private boolean mutable = true;

    public ObligationImpl() {
    }

    public ObligationImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument(xml, XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("ObligationImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ObligationImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        Object value = null;
        if (element == null) {
            XACMLSDKUtils.debug.error("ObligationImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        if (!element.getLocalName().equals(XACMLConstants.OBLIGATION)) {
            XACMLSDKUtils.debug.error("ObligationImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        NamedNodeMap attrs = element.getAttributes();
        try {
            this.obligationId = new URI(attrs.getNamedItem(XACMLConstants.OBLIGATION_ID).getNodeValue());
        }
        catch (Exception e) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_not_uri"));
        }
        if (this.obligationId == null) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_missing"));
        }
        try {
            this.fulfillOn = attrs.getNamedItem(XACMLConstants.FULFILL_ON).getNodeValue();
        }
        catch (Exception e) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("error_parsing_attribute"));
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals(XACMLConstants.ATTRIBUTE_ASSIGNMENT)) {
                Element aa;
                String aid;
                if (this.attributeAssignments == null) {
                    this.attributeAssignments = new ArrayList();
                }
                if ((aid = (aa = (Element)node).getAttribute(XACMLConstants.ATTRIBUTE_ID)) == null || aid.length() == 0) {
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
                }
                String dt = aa.getAttribute(XACMLConstants.DATA_TYPE);
                if (dt == null || dt.length() == 0) {
                    throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
                }
                this.attributeAssignments.add(aa);
                continue;
            }
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_element"));
        }
    }

    public URI getObligationId() {
        return this.obligationId;
    }

    public void setObligationId(URI obligationId) throws XACMLException {
        this.obligationId = obligationId;
    }

    public String getFulfillOn() {
        return this.fulfillOn;
    }

    public void setFulfillOn(String fulfillOn) throws XACMLException {
        this.fulfillOn = fulfillOn;
    }

    public List getAttributeAssignments() {
        return this.attributeAssignments;
    }

    public void setAttributeAssignments(List attributeAssignments) throws XACMLException {
        if (attributeAssignments == null) {
            return;
        }
        Iterator iter = attributeAssignments.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Element)) {
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("not_xml_element"));
            }
            Element elem = (Element)obj;
            String aid = elem.getAttribute(XACMLConstants.ATTRIBUTE_ID);
            if (aid == null || aid.length() == 0) {
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
            }
            String dt = elem.getAttribute(XACMLConstants.DATA_TYPE);
            if (dt != null && dt.length() != 0) continue;
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
        }
        this.attributeAssignments = attributeAssignments;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.XACML_NS_PREFIX + ":";
        }
        if (declareNS) {
            nsDeclaration = XACMLConstants.XACML_NS_DECLARATION;
        }
        sb.append("<").append(nsPrefix).append(XACMLConstants.OBLIGATION);
        if (declareNS) {
            sb.append(" ").append(nsDeclaration);
        }
        if (this.obligationId != null) {
            sb.append(" ").append(XACMLConstants.OBLIGATION_ID).append("=").append(XACMLSDKUtils.quote(this.obligationId.toString()));
        }
        if (this.fulfillOn != null) {
            sb.append(" ").append(XACMLConstants.FULFILL_ON).append("=").append(XACMLSDKUtils.quote(this.fulfillOn));
        }
        sb.append(">\n");
        int length = 0;
        if (this.attributeAssignments != null) {
            length = this.attributeAssignments.size();
            for (int i = 0; i < length; ++i) {
                Element elem = (Element)this.attributeAssignments.get(i);
                sb.append(XMLUtils.print(elem));
            }
        }
        sb.append("</").append(nsPrefix).append(XACMLConstants.OBLIGATION).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, true);
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

