/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.shared.xml.XMLHandler;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSErrorHandler;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SMSSchema {
    private static final String TEXT_NODE = "#text";
    private static final String SLASH_ESC_SEQ = "&#47;";
    static final String XML_ENC = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private static final String SCHEMA_PREFIX_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"";
    private static final String SCHEMA_PREFIX_2 = "\" version=\"";
    private static final String SCHEMA_PREFIX_3 = "\">";
    private static final String SCHEMA_SUFFIX = "</Service></ServicesConfiguration>";
    private static final String PLUGIN_PREFIX_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"";
    private static final String PLUGIN_PREFIX_2 = "\" version=\"";
    private static final String PLUGIN_PREFIX_3 = "\">";
    private static final String PLUGIN_SUFFIX = "</Service></ServicesConfiguration>";
    private Document document;
    private String serviceName;
    private String version;
    private static Class docBuildFactoryClass = null;

    SMSSchema(Document document) throws SMSException {
        this.document = document;
        this.serviceName = this.getServiceName();
        this.version = this.getServiceVersion();
    }

    SMSSchema(String serviceName, Document document) throws SMSException {
        this(document);
        this.serviceName = serviceName;
    }

    SMSSchema(String serviceName, String version, Document document) throws SMSException {
        this(serviceName, document);
        this.version = version;
    }

    SMSSchema(String serviceName, InputStream in) throws SMSException {
        this(in);
        this.serviceName = serviceName;
    }

    SMSSchema(InputStream in) throws SMSException {
        this(SMSSchema.getXMLDocument(in));
    }

    protected String getServiceName() throws SMSException {
        if (this.serviceName == null) {
            this.serviceName = this.getServiceAttribute("name");
        }
        return this.serviceName;
    }

    protected String getServiceVersion() throws SMSException {
        if (this.version == null) {
            this.version = this.getServiceAttribute("version");
        }
        return this.version;
    }

    private String getServiceAttribute(String attrName) throws SMSException {
        NodeList nodes = this.document.getElementsByTagName("Service");
        if (nodes == null || nodes.getLength() == 0) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        String value = XMLUtils.getNodeAttributeValue(nodes.item(0), attrName);
        if (value == null) {
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        return value;
    }

    protected Node getServiceNode() throws SMSException {
        NodeList nodes = this.document.getElementsByTagName("Service");
        if (nodes == null || nodes.getLength() == 0) {
            SMSEntry.debug.error("SMSSchema::getSchema: No Service node not found in XML input.");
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        Node parent = null;
        boolean foundNode = false;
        int nodeLen = nodes.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            parent = nodes.item(i);
            if (!XMLUtils.getNodeAttributeValue(parent, "name").equalsIgnoreCase(this.serviceName) || !XMLUtils.getNodeAttributeValue(parent, "version").equalsIgnoreCase(this.version)) continue;
            foundNode = true;
            break;
        }
        if (!foundNode) {
            SMSEntry.debug.error("SMSSchema::getSchema: Service not found :" + this.serviceName);
            throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
        }
        return parent;
    }

    protected String getSchema(String serviceName) throws SMSException {
        String oldServiceName = this.serviceName;
        this.serviceName = serviceName;
        String schema = this.getSchema();
        this.serviceName = oldServiceName;
        return schema;
    }

    public String getSchema() throws SMSException {
        Node node = null;
        node = XMLUtils.getChildNode(this.getServiceNode(), "Schema");
        if (node == null) {
            throw new SMSException("amSDK", "IUMSConstants.SMS_SMSSchema_no_service_element", null);
        }
        return SMSSchema.schemaToXML(node, this.getServiceName(), this.getServiceVersion());
    }

    public String getPluginSchema(String serviceName, String pluginName) throws SMSException {
        String oldServiceName = this.serviceName;
        this.serviceName = serviceName;
        String schema = this.getPluginSchema(pluginName);
        this.serviceName = oldServiceName;
        return schema;
    }

    public String getPluginSchema(String pluginName) throws SMSException {
        Node parent = this.getServiceNode();
        Iterator pNodes = XMLUtils.getChildNodes(parent, "PluginSchema").iterator();
        while (pNodes.hasNext()) {
            Node node = (Node)pNodes.next();
            if (!XMLUtils.getNodeAttributeValue(node, "name").equalsIgnoreCase(pluginName)) continue;
            return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"" + this.getServiceName() + "\" version=\"" + this.getServiceVersion() + "\">" + SMSSchema.nodeToString(node) + "</Service></ServicesConfiguration>";
        }
        throw new SMSException("amSDK", "sms-SMSSchema_no_service_element", null);
    }

    static String schemaToXML(Node schemaNode, String svcName, String version) {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"" + svcName + "\" version=\"" + version + "\">" + SMSSchema.nodeToString(schemaNode) + "</Service></ServicesConfiguration>";
    }

    public static String getDummyXML(String serviceName, String version) {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n\n<ServicesConfiguration><Service name=\"" + serviceName + "\" version=\"" + version + "\"></Service></ServicesConfiguration>";
    }

    public static String nodeToString(Node a) {
        String nodeName = a.getNodeName();
        if (nodeName.equalsIgnoreCase("#comment")) {
            return new String("");
        }
        String answer = "<" + nodeName + SMSSchema.getNodeAttributes(a) + ">";
        answer = answer + SMSSchema.getNodeValue(a);
        NodeList nodes = a.getChildNodes();
        int nodeLen = nodes.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            Node node = nodes.item(i);
            answer = node.getNodeName().equalsIgnoreCase(TEXT_NODE) ? answer + SMSSchema.escapeSpecialCharacters(node.getNodeValue()) : answer + SMSSchema.nodeToString(node);
        }
        answer = answer + "</" + nodeName + ">";
        return answer;
    }

    private static String getNodeAttributes(Node a) {
        String answer = "";
        int attrLen = 0;
        NamedNodeMap attrs = a.getAttributes();
        if (attrs != null && (attrLen = attrs.getLength()) != 0) {
            for (int i = 0; i < attrLen; ++i) {
                Node node = attrs.item(i);
                answer = answer + " " + node.getNodeName() + "=\"" + SMSSchema.getNodeValue(node) + "\" ";
            }
        }
        return answer;
    }

    private static String getNodeValue(Node a) {
        String value = a.getNodeValue();
        if (value != null && value.length() != 0) {
            return value.trim();
        }
        return "";
    }

    public static Document getXMLDocument(String xml, boolean validation) throws SchemaException, SMSException {
        return SMSSchema.getXMLDocument(SMSSchema.getServiceSchemaInputStream(xml), validation);
    }

    public static Document getXMLDocument(InputStream in) throws SchemaException, SMSException {
        return SMSSchema.getXMLDocument(in, true);
    }

    public static Document getXMLDocument(InputStream in, boolean validation) throws SchemaException, SMSException {
        DocumentBuilderFactory factory = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
        }
        catch (FactoryConfigurationError fce) {
            if (docBuildFactoryClass == null) {
                if (SMSEntry.debug.warningEnabled()) {
                    SMSEntry.debug.warning("SMSSchema:getXMLDocument():DocumentBuilderFactory class not found,so getting the instance of :com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl with new context classloader");
                }
                try {
                    docBuildFactoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
                }
                catch (ClassNotFoundException cfe) {
                    if (SMSEntry.debug.warningEnabled()) {
                        SMSEntry.debug.warning("SMSSchema:getXMLDocument():com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactory class not found");
                    }
                    throw new SMSException(cfe, "sms-init-no-class-found");
                }
            }
            try {
                factory = (DocumentBuilderFactory)docBuildFactoryClass.newInstance();
            }
            catch (Exception e) {
                if (SMSEntry.debug.warningEnabled()) {
                    SMSEntry.debug.warning("SMSSchema: error in instantiation of :com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactory: Message: " + e.getMessage());
                }
                throw new SMSException(e, "sms-instantiation-failed");
            }
        }
        catch (Exception e) {
            if (SMSEntry.debug.warningEnabled()) {
                SMSEntry.debug.warning("SMSSchema: error in instantiation ofDocumentBuilderFactory: Message: " + e.getMessage());
            }
            throw new SMSException(e, "sms-instantiation-failed");
        }
        try {
            factory.setValidating(validation);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new SMSErrorHandler());
            builder.setEntityResolver(new XMLHandler());
            Document doc = builder.parse(in);
            return doc;
        }
        catch (SAXParseException pe) {
            SMSEntry.debug.error("SMSSchema: SAXPasrseException", pe);
            Object[] params = new Object[]{new Integer(pe.getLineNumber())};
            throw new SchemaException("amSDK", "sms-SMSSchema_parser_error", params);
        }
        catch (SAXException sax) {
            Object[] params = new Object[]{new String(sax.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_exception_message", params);
        }
        catch (ParserConfigurationException pc) {
            Object[] params = new Object[]{new String(pc.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_invalid_xml_document", params);
        }
        catch (IOException ioe) {
            Object[] params = new Object[]{new String(ioe.toString())};
            throw new SchemaException("amSDK", "sms-SMSSchema_invalid_input_stream", params);
        }
    }

    static InputStream getServiceSchemaInputStream(String xmlSchema) throws SMSException {
        ByteArrayInputStream in;
        if (xmlSchema == null || xmlSchema.length() == 0) {
            throw new SMSException("amSDK", "sms-SMSSchema_service_notfound", null);
        }
        try {
            in = new ByteArrayInputStream(xmlSchema.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            SMSEntry.debug.error("SMSSchema: Unsupported encoding ", ex);
            in = new ByteArrayInputStream(xmlSchema.getBytes());
        }
        return in;
    }

    Document getDocument() {
        return this.document;
    }

    public static String escapeSpecialCharacters(String txt) {
        if (txt == null) {
            return txt;
        }
        int len = txt.length();
        if (len == 0) {
            return txt;
        }
        StringBuffer buf = new StringBuffer();
        block8: for (int i = 0; i < len; ++i) {
            char c = txt.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block8;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block8;
                }
                case '/': {
                    buf.append(SLASH_ESC_SEQ);
                    continue block8;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String unescapeName(String txtName) {
        if (txtName == null) {
            return txtName;
        }
        int len = txtName.length();
        if (len == 0) {
            return txtName;
        }
        for (int i = 0; i < txtName.length(); ++i) {
            int indx = txtName.indexOf(SLASH_ESC_SEQ);
            if (indx < 0) continue;
            String prefixID = txtName.substring(0, indx);
            String postfixID = txtName.substring(indx + 5);
            txtName = prefixID + "/" + postfixID;
        }
        return txtName;
    }
}

