/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class DirectoryServerVendor {
    public static String OPENDS = "opends";
    public static String SUNDS = "sunds";
    private static String VENDOR_OPENDS = "OpenDS Directory Server ";
    private static String VENDOR_SUNDS_5 = "Sun-ONE-Directory/";
    private static String VENDOR_SUNDS_6 = "Sun-Java(tm)-System-Directory/";
    private static DirectoryServerVendor instance = new DirectoryServerVendor();
    private String[] attrs = new String[]{"vendorversion", "rootDomainNamingContext", "forestFunctionality"};
    private Vendor unknownVendor = new Vendor("unknown", "unknown");

    private DirectoryServerVendor() {
    }

    public static DirectoryServerVendor getInstance() {
        return instance;
    }

    public Vendor query(LDAPConnection conn) throws LDAPException {
        String result = null;
        LDAPSearchResults res = conn.search("", 0, "(objectclass=*)", this.attrs, false);
        while (res.hasMoreElements()) {
            LDAPEntry findEntry = (LDAPEntry)res.nextElement();
            LDAPAttributeSet findAttrs = findEntry.getAttributeSet();
            Enumeration enumAttrs = findAttrs.getAttributes();
            while (enumAttrs.hasMoreElements()) {
                Enumeration enumVals;
                LDAPAttribute anAttr = (LDAPAttribute)enumAttrs.nextElement();
                String attrName = anAttr.getName();
                if (!attrName.equalsIgnoreCase("vendorversion") || !(enumVals = anAttr.getStringValues()).hasMoreElements()) continue;
                result = (String)enumVals.nextElement();
            }
        }
        Vendor vendor = this.unknownVendor;
        if (result != null) {
            String version;
            if (result.startsWith(VENDOR_OPENDS)) {
                version = result.substring(VENDOR_OPENDS.length());
                vendor = new Vendor(OPENDS, version);
            } else if (result.startsWith(VENDOR_SUNDS_5)) {
                version = result.substring(VENDOR_SUNDS_5.length());
                vendor = new Vendor(SUNDS, version);
            } else if (result.startsWith(VENDOR_SUNDS_6)) {
                version = result.substring(VENDOR_SUNDS_6.length());
                vendor = new Vendor(SUNDS, version);
            }
        }
        return vendor;
    }

    public class Vendor {
        public String name;
        public String version;

        public Vendor(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String toString() {
            return this.name + " " + this.version;
        }
    }
}

