/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.test.tools;

import com.sun.identity.shared.test.tools.FileNameComparator;
import com.sun.identity.shared.test.tools.ReportGenerator;
import com.sun.identity.shared.test.tools.Test;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Suite {
    private String name;
    private List<Test> tests = new ArrayList<Test>();

    public Suite(File f) throws ParserConfigurationException, SAXException, IOException {
        this.name = f.getName();
        this.getXMLFiles(f);
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public boolean passed() {
        boolean passed = true;
        Iterator<Test> i = this.tests.iterator();
        while (i.hasNext() && passed) {
            Test t = i.next();
            passed = t.passed();
        }
        return passed;
    }

    public void createHTMLReports(String templateDir, String outputDir) throws IOException {
        String templateHTML = ReportGenerator.getFileContent(templateDir + "/suite.html");
        String dirName = outputDir + "/" + this.name;
        File dir = new File(dirName);
        dir.mkdir();
        StringBuffer buff = new StringBuffer();
        for (Test t : this.tests) {
            buff.append(t.toHTML());
        }
        templateHTML = templateHTML.replaceAll("@Test@", buff.toString());
        templateHTML = templateHTML.replaceAll("@SuiteName@", this.name);
        ReportGenerator.writeToFile(templateHTML, dirName + "/index.html");
    }

    private int getNumberOfPasses() {
        int result = 0;
        for (Test t : this.tests) {
            result += t.getPassedTestCases().size();
        }
        return result;
    }

    private int getNumberOfFailed() {
        int result = 0;
        for (Test t : this.tests) {
            result += t.getFailedTestCases().size();
        }
        return result;
    }

    private int getNumberOfSkipped() {
        int result = 0;
        for (Test t : this.tests) {
            result += t.getSkippedTestCases().size();
        }
        return result;
    }

    public String toHTML() {
        StringBuffer buff = new StringBuffer();
        boolean passed = this.passed();
        String titleTag = passed ? "tblMainPassedSuite" : "tblMainFailedSuite";
        String countTag = passed ? "tblMainPassed" : "tblMainFailed";
        String urlName = this.name + "/index.html";
        Object[] args = new Object[]{urlName, this.name};
        String hrefName = MessageFormat.format("<a href=\"{0}\">{1}</a>\n", args);
        Object[] params = new Object[]{titleTag, hrefName};
        buff.append("<tr>");
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        params[0] = countTag;
        params[1] = Integer.toString(this.getNumberOfPasses());
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        params[1] = Integer.toString(this.getNumberOfFailed());
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        params[1] = Integer.toString(this.getNumberOfSkipped());
        buff.append(MessageFormat.format("<td id=\"{0}\">{1}</td>\n", params));
        buff.append("</tr>");
        return buff.toString();
    }

    private void getXMLFiles(File suite) throws ParserConfigurationException, SAXException, IOException {
        TreeSet<File> xmlFiles = new TreeSet<File>(new FileNameComparator());
        File[] files = suite.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            String name = f.getName();
            if (!name.endsWith(".xml") || name.equals("testng-failed.xml")) continue;
            xmlFiles.add(f);
        }
        for (File f : xmlFiles) {
            this.tests.add(new Test(f));
        }
    }
}

