/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.shared.search;

import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.search.FileLookupException;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class FileLookup {
    private static Debug debug = Debug.getInstance("amFileLookup");
    private static final String UNDERSCORE = "_";
    private static final String NULL_LOCALE = "nullLocale";
    private static int numberOfPlatformLocales = 0;
    private static String[] platformLocales;
    static String platformLocale;
    private static Map fileTable;

    public static File[] getOrderedPaths(String type, String locale, String component, String orgPath, String clientPath, String filename) throws FileLookupException {
        int orderedPathLength;
        if (filename == null) {
            debug.error("FileLookup.getOrderedPaths():Filename was null");
            throw new FileLookupException("filename is null");
        }
        if (debug.messageEnabled()) {
            debug.message("getting ordered paths for =" + type + "|" + locale + "|" + component + "|" + orgPath + "|" + clientPath + "|" + filename);
        }
        String[] types = null;
        int numberOfTypes = 1;
        boolean haveType = false;
        if (type != null && !type.equals("default")) {
            haveType = true;
            ++numberOfTypes;
        }
        types = new String[numberOfTypes];
        if (haveType) {
            types[0] = type;
            types[1] = "default";
            orderedPathLength = 2;
        } else {
            types[0] = "default";
            orderedPathLength = 1;
        }
        int numberOfLocales = numberOfPlatformLocales;
        int indexOfLastUS = 0;
        String[] locales = null;
        int i = 1;
        if (debug.messageEnabled()) {
            debug.message("platformLocale is : " + platformLocale);
            debug.message("locale is : " + locale);
        }
        if (locale != null && locale.length() != 0 && !locale.equals(platformLocale)) {
            ++numberOfLocales;
            String frontOfStr = locale;
            while (indexOfLastUS != -1) {
                indexOfLastUS = frontOfStr.lastIndexOf(UNDERSCORE);
                if (indexOfLastUS == -1) continue;
                frontOfStr = frontOfStr.substring(0, indexOfLastUS);
                ++numberOfLocales;
            }
            frontOfStr = locale;
            locales = new String[numberOfLocales + 1];
            locales[0] = locale;
            indexOfLastUS = 0;
            while (indexOfLastUS != -1) {
                indexOfLastUS = frontOfStr.lastIndexOf(UNDERSCORE);
                if (indexOfLastUS == -1) continue;
                String thisPartOfStr = frontOfStr.substring(0, indexOfLastUS);
                locales[i++] = thisPartOfStr;
                frontOfStr = thisPartOfStr;
            }
        } else {
            i = 0;
            locales = new String[numberOfLocales + 1];
        }
        for (int j = 0; j < numberOfPlatformLocales; ++j) {
            locales[i++] = platformLocales[j];
        }
        locales[i++] = NULL_LOCALE;
        if (++numberOfLocales > 1) {
            orderedPathLength *= numberOfLocales;
        }
        boolean haveClientPath = false;
        String[] clientkeys = null;
        if (clientPath != null && clientPath.length() > 0) {
            clientkeys = FileLookup.getClientPathKeys(clientPath);
            orderedPathLength *= clientkeys.length + 1;
            haveClientPath = true;
        }
        boolean haveComponent = false;
        if (component != null && component.length() != 0) {
            haveComponent = true;
            orderedPathLength *= 2;
        }
        boolean haveOrgPath = false;
        String[] orgPathKeys = null;
        if (orgPath != null && orgPath.length() > 0) {
            orgPathKeys = FileLookup.getOrgPathKeys(orgPath);
            orderedPathLength *= orgPathKeys.length + 1;
            haveOrgPath = true;
        }
        File[] orderedPaths = new File[orderedPathLength];
        int numberOfOrderedPaths = 0;
        for (i = 0; i < numberOfTypes; ++i) {
            String currentFilePath = types[i];
            for (int j = 0; j < numberOfLocales; ++j) {
                String thisFilePath = null;
                if (locales != null) {
                    thisFilePath = locales[j].equals(NULL_LOCALE) ? currentFilePath : currentFilePath + UNDERSCORE + locales[j];
                }
                if (haveComponent) {
                    thisFilePath = thisFilePath + "/" + component;
                    if (haveClientPath) {
                        for (int len = clientkeys.length; len > 0; --len) {
                            String filePath = thisFilePath + FileLookup.buildClientPath(clientkeys, len);
                            orderedPaths[numberOfOrderedPaths++] = new File(filePath, filename);
                        }
                    }
                    orderedPaths[numberOfOrderedPaths++] = new File(thisFilePath, filename);
                }
                String filePath = null;
                String oPath = null;
                if (haveOrgPath) {
                    int z = 0;
                    for (int orgKeys = orgPathKeys.length; orgKeys > 0; --orgKeys) {
                        String iPath = orgPathKeys[z++];
                        oPath = thisFilePath + "/" + iPath;
                        if (haveClientPath) {
                            for (int len = clientkeys.length; len > 0; --len) {
                                filePath = FileLookup.getClientFilePath(oPath, clientkeys, len);
                                orderedPaths[numberOfOrderedPaths++] = new File(filePath, filename);
                            }
                        }
                        orderedPaths[numberOfOrderedPaths++] = new File(oPath, filename);
                    }
                }
                if (haveClientPath) {
                    for (int len = clientkeys.length; len > 0; --len) {
                        thisFilePath = locales[j].equals(NULL_LOCALE) ? currentFilePath : currentFilePath + UNDERSCORE + locales[j];
                        filePath = thisFilePath + FileLookup.buildClientPath(clientkeys, len);
                        orderedPaths[numberOfOrderedPaths++] = new File(filePath, filename);
                    }
                }
                thisFilePath = !locales[j].equals(NULL_LOCALE) ? currentFilePath + UNDERSCORE + locales[j] : currentFilePath;
                orderedPaths[numberOfOrderedPaths++] = new File(thisFilePath, filename);
            }
        }
        return orderedPaths;
    }

    public static File getFirstExisting(String type, String locale, String component, String clientPath, String filename, String templateDir, boolean enableCache) throws FileLookupException {
        return FileLookup.getFirstExisting(type, locale, component, null, clientPath, filename, templateDir, enableCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFirstExisting(String type, String locale, String component, String orgFilePath, String clientPath, String filename, String templateDir, boolean enableCache) throws FileLookupException {
        File temp0;
        String tempFile = type + ":" + locale + ":" + component + ":" + orgFilePath + ":" + clientPath + ":" + filename + ":" + templateDir;
        if (debug.messageEnabled()) {
            debug.message("Check file=" + tempFile);
        }
        if (enableCache && (temp0 = (File)fileTable.get(tempFile)) != null) {
            if (debug.messageEnabled()) {
                debug.message("Found existing file=" + tempFile);
            }
            return temp0;
        }
        File[] orderedPaths = FileLookup.getOrderedPaths(type, locale, component, orgFilePath, clientPath, filename);
        if (debug.messageEnabled()) {
            debug.message("getFirstExisting:orderedPaths.length = " + orderedPaths.length);
        }
        for (int i = 0; i < orderedPaths.length; ++i) {
            File file;
            if (debug.messageEnabled()) {
                debug.message("orderedPath[" + i + "]=" + orderedPaths[i].toString());
            }
            if (!(file = new File(templateDir, orderedPaths[i].toString())).exists()) continue;
            if (debug.messageEnabled()) {
                debug.message("returning file=" + file.toString());
            }
            if (enableCache) {
                Map map = fileTable;
                synchronized (map) {
                    File temp1 = (File)fileTable.get(tempFile);
                    if (temp1 == null) {
                        fileTable.put(tempFile, file);
                    } else {
                        file = temp1;
                    }
                }
            }
            return file;
        }
        return null;
    }

    public static String getFirstExistingRemote(String server, String type, String locale, String filename) throws FileLookupException {
        debug.message("FileLookup:getFirstExistingRemote");
        File[] orderedPaths = FileLookup.getOrderedPaths(type, locale, null, null, null, filename);
        for (int i = 0; i < orderedPaths.length; ++i) {
            String tmp = orderedPaths[i].toString();
            if (tmp.charAt(0) != '/') {
                tmp = "/" + tmp;
            }
            String document = server + tmp;
            if (debug.messageEnabled()) {
                debug.message("path " + i + ") " + document);
            }
            int responseCode = -1;
            try {
                URL handle = new URL(document);
                HttpURLConnection connection = HttpURLConnectionManager.getConnection(handle);
                responseCode = connection.getResponseCode();
                connection.disconnect();
            }
            catch (MalformedURLException m) {
                debug.error("malformed url excption", m);
            }
            catch (IOException ioerror) {
                debug.error("ioexcecption opening the connection", ioerror);
            }
            if (responseCode != 200) continue;
            if (debug.messageEnabled()) {
                debug.message("returning remote file = " + document);
            }
            return document;
        }
        if (debug.messageEnabled()) {
            debug.message("could not locate " + filename + " on " + server + "; returning null");
        }
        return null;
    }

    private static String buildClientPath(String[] keys, int len) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            sb.append("/").append(keys[i]);
        }
        return sb.toString();
    }

    private static String[] getClientPathKeys(String cp) {
        StringTokenizer st = new StringTokenizer(cp, "/");
        int numTokens = st.countTokens();
        String[] keyArray = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            keyArray[i] = st.nextToken();
        }
        return keyArray;
    }

    private static String[] getOrgPathKeys(String orgPath) {
        StringTokenizer st = new StringTokenizer(orgPath, "/");
        int numTokens = st.countTokens();
        String[] keyArray = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            keyArray[i] = orgPath;
            int k = orgPath.lastIndexOf("/");
            if (k == -1) continue;
            orgPath = orgPath.substring(0, k);
        }
        return keyArray;
    }

    static String getClientFilePath(String currentFilePath, String[] clientkeys, int len) {
        String filePath = currentFilePath + FileLookup.buildClientPath(clientkeys, len);
        return filePath;
    }

    static {
        platformLocale = null;
        platformLocale = Locale.getDefault().toString();
        ++numberOfPlatformLocales;
        String frontOfStr = platformLocale;
        int idx = 0;
        while (idx != -1) {
            idx = frontOfStr.lastIndexOf(UNDERSCORE);
            if (idx == -1) continue;
            frontOfStr = frontOfStr.substring(0, idx);
            ++numberOfPlatformLocales;
        }
        frontOfStr = platformLocale;
        platformLocales = new String[numberOfPlatformLocales];
        FileLookup.platformLocales[0] = platformLocale;
        idx = 0;
        int i = 1;
        while (idx != -1) {
            idx = frontOfStr.lastIndexOf(UNDERSCORE);
            if (idx == -1) continue;
            String thisPartOfStr = frontOfStr.substring(0, idx);
            FileLookup.platformLocales[i++] = thisPartOfStr;
            frontOfStr = thisPartOfStr;
        }
        fileTable = new HashMap();
    }
}

