/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AMSecurityPropertiesException;
import com.sun.identity.security.AppSSOTokenProvider;
import com.sun.identity.security.SystemAppTokenProvider;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.security.PrivilegedAction;

public class AdminTokenAction
implements PrivilegedAction {
    private static SSOTokenManager tokenManager;
    private static SSOToken appSSOToken;
    private static SSOToken internalAppSSOToken;
    private static AdminTokenAction instance;
    private static boolean authInitialized;
    static Debug debug;
    static final String ADMIN_TOKEN_PROVIDER = "com.sun.identity.security.AdminToken";
    static final String APP_USERNAME = "com.sun.identity.agents.app.username";
    static final String APP_SECRET = "com.iplanet.am.service.secret";
    static final String APP_PASSWORD = "com.iplanet.am.service.password";
    public static final String AMADMIN_MODE = "com.sun.identity.security.amadmin";

    public static AdminTokenAction getInstance() {
        if (instance == null) {
            instance = new AdminTokenAction();
        }
        return instance;
    }

    public AdminTokenAction() {
        if (tokenManager == null) {
            try {
                tokenManager = SSOTokenManager.getInstance();
            }
            catch (SSOException ssoe) {
                debug.error("AdminTokenAction::init Unable to get SSOTokenManager", ssoe);
            }
        }
    }

    public void authenticationInitialized() {
        authInitialized = true;
        appSSOToken = AdminTokenAction.getSSOToken();
        if (debug.messageEnabled()) {
            debug.message("AdminTokenAction:authenticationInit called. AppSSOToken className=" + (appSSOToken == null ? "null" : appSSOToken.getClass().getName()));
        }
        internalAppSSOToken = null;
    }

    public static void reset() {
        internalAppSSOToken = null;
        appSSOToken = null;
    }

    public Object run() {
        SSOToken answer;
        block19: {
            String appPassword;
            String appUserName;
            block20: {
                String appTokenProviderName;
                if (appSSOToken != null && tokenManager.isValidToken(appSSOToken)) {
                    return appSSOToken;
                }
                if (internalAppSSOToken != null && tokenManager.isValidToken(internalAppSSOToken)) {
                    return internalAppSSOToken;
                }
                answer = this.getSSOToken();
                if (answer != null) {
                    if (!SystemProperties.isServerMode() || authInitialized) {
                        appSSOToken = answer;
                    }
                    return answer;
                }
                if (debug.messageEnabled()) {
                    debug.message("AdminTokenAction::run Unable to get SSOToken  from serverconfig.xml");
                }
                if ((appTokenProviderName = SystemProperties.get(ADMIN_TOKEN_PROVIDER)) != null) {
                    try {
                        AppSSOTokenProvider appSSOTokenProvider = (AppSSOTokenProvider)Class.forName(appTokenProviderName).newInstance();
                        answer = appSSOTokenProvider.getAppSSOToken();
                    }
                    catch (Throwable ce) {
                        if (debug.warningEnabled()) {
                            debug.warning("AdminTokenAction: Exception while calling appSSOToken provider plugin.", ce);
                        }
                        break block19;
                    }
                }
                appUserName = SystemProperties.get(APP_USERNAME);
                String tmp = SystemProperties.get(APP_SECRET);
                String passwd = SystemProperties.get(APP_PASSWORD);
                appPassword = null;
                if (passwd != null && passwd.length() != 0) {
                    appPassword = passwd;
                } else if (tmp != null && tmp.length() != 0) {
                    try {
                        appPassword = Crypt.decode(tmp);
                    }
                    catch (Throwable t) {
                        if (!debug.messageEnabled()) break block20;
                        debug.message("AdminTokenAction::run Unable to  decrypt secret password", t);
                    }
                }
            }
            if (appUserName == null || appUserName.length() == 0 || appPassword == null || appPassword.length() == 0) {
                debug.message("AdminTokenAction: App user name or password is empty");
            } else {
                if (debug.messageEnabled()) {
                    debug.message("App user name: " + appUserName);
                }
                SystemAppTokenProvider tokenProd = new SystemAppTokenProvider(appUserName, appPassword);
                answer = tokenProd.getAppSSOToken();
            }
        }
        if (answer == null) {
            debug.error("AdminTokenAction: FATAL ERROR: Cannot obtain Application SSO token.\nCheck AMConfig.properties for the following properties\n\tcom.sun.identity.agents.app.username\n\tcom.iplanet.am.service.password");
            throw new AMSecurityPropertiesException("AdminTokenAction:  FATAL ERROR: Cannot obtain Application SSO token.\nCheck AMConfig.properties for the following properties\n\tcom.sun.identity.agents.app.username\n\tcom.iplanet.am.service.password");
        }
        if (!SystemProperties.isServerMode() || authInitialized) {
            appSSOToken = answer;
        }
        return answer;
    }

    private static SSOToken getSSOToken() {
        SSOToken ssoAuthToken;
        block9: {
            ssoAuthToken = null;
            try {
                if (AdminUtils.getAdminPassword() != null) {
                    String adminDN = AdminUtils.getAdminDN();
                    String adminPassword = new String(AdminUtils.getAdminPassword());
                    if (!authInitialized && (SystemProperties.isServerMode() || SystemProperties.get(AMADMIN_MODE) != null)) {
                        AuthContext ac = new AuthContext((Principal)new AuthPrincipal(adminDN), adminPassword.toCharArray());
                        internalAppSSOToken = ssoAuthToken = ac.getSSOToken();
                    } else {
                        boolean authInit = authInitialized;
                        if (authInit) {
                            authInitialized = false;
                        }
                        ssoAuthToken = new SystemAppTokenProvider(adminDN, adminPassword).getAppSSOToken();
                        if (authInit && ssoAuthToken != null) {
                            authInitialized = true;
                        }
                    }
                }
            }
            catch (NoClassDefFoundError ne) {
                if (debug.messageEnabled()) {
                    debug.message("AdminTokenAction::getSSOToken Not found AdminDN and AdminPassword.", ne);
                }
            }
            catch (Throwable t) {
                if (!debug.messageEnabled()) break block9;
                debug.message("AdminTokenAction::getSSOToken Exception reading from serverconfig.xml", t);
            }
        }
        return ssoAuthToken;
    }

    static {
        debug = Debug.getInstance("amSecurity");
    }
}

