/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.meta;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.saml2.jaxb.entityconfig.AttributeType;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.entityconfig.EntityConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.ObjectFactory;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.EntityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.KeyDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.RoleDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.org.apache.xml.internal.security.Init;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.implementations.KeyStoreResolver;
import com.sun.org.apache.xml.internal.security.signature.XMLSignature;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SAML2MetaSecurityUtils {
    private static Debug debug = SAML2MetaUtils.debug;
    private static KeyProvider keyProvider = null;
    private static KeyStore keyStore = null;
    private static boolean checkCert = true;
    private static boolean keyProviderInitialized = false;
    public static final String NS_META = "urn:oasis:names:tc:SAML:2.0:metadata";
    public static final String NS_XMLSIG = "http://www.w3.org/2000/09/xmldsig#";
    public static final String NS_XMLENC = "http://www.w3.org/2001/04/xmlenc#";
    public static final String NS_MD_QUERY = "urn:oasis:names:tc:SAML:metadata:ext:query";
    public static final String PREFIX_XMLSIG = "ds";
    public static final String PREFIX_XMLENC = "xenc";
    public static final String PREFIX_MD_QUERY = "query";
    public static final String TAG_KEY_INFO = "KeyInfo";
    public static final String TAG_KEY_DESCRIPTOR = "KeyDescriptor";
    public static final String TAG_SP_SSO_DESCRIPTOR = "SPSSODescriptor";
    public static final String TAG_IDP_SSO_DESCRIPTOR = "IDPSSODescriptor";
    public static final String ATTR_USE = "use";
    public static final String ATTR_ID = "ID";

    private SAML2MetaSecurityUtils() {
    }

    private static void initializeKeyStore() {
        if (keyProviderInitialized) {
            return;
        }
        Init.init();
        keyProvider = KeyUtil.getKeyProviderInstance();
        if (keyProvider instanceof JKSKeyProvider) {
            keyStore = ((JKSKeyProvider)keyProvider).getKeyStore();
        }
        try {
            String valCert = SystemPropertiesManager.get("com.sun.identity.saml.checkcert", "on");
            checkCert = valCert.trim().equalsIgnoreCase("on");
        }
        catch (Exception e) {
            checkCert = true;
        }
        keyProviderInitialized = true;
    }

    public static Document sign(EntityDescriptorElement descriptor, SPSSOConfigElement spconfig, IDPSSOConfigElement idpconfig) throws JAXBException, SAML2MetaException {
        String xpath;
        IDPSSODescriptorElement idpDesc;
        SPSSODescriptorElement spDesc;
        Map map;
        List list;
        String spId = null;
        String idpId = null;
        String spCertAlias = null;
        String idpCertAlias = null;
        if (spconfig != null && (list = (List)(map = SAML2MetaUtils.getAttributes(spconfig)).get("signingCertAlias")) != null && !list.isEmpty() && (spCertAlias = ((String)list.get(0)).trim()).length() > 0 && (spDesc = SAML2MetaUtils.getSPSSODescriptor(descriptor)) != null) {
            spId = SAMLUtils.generateID();
            spDesc.setID(spId);
        }
        if (idpconfig != null && (list = (List)(map = SAML2MetaUtils.getAttributes(idpconfig)).get("signingCertAlias")) != null && !list.isEmpty() && (idpCertAlias = ((String)list.get(0)).trim()).length() > 0 && (idpDesc = SAML2MetaUtils.getIDPSSODescriptor(descriptor)) != null) {
            idpId = SAMLUtils.generateID();
            idpDesc.setID(idpId);
        }
        if (spId == null && idpId == null) {
            return null;
        }
        SAML2MetaSecurityUtils.initializeKeyStore();
        String xmlstr = SAML2MetaUtils.convertJAXBToString(descriptor);
        xmlstr = SAML2MetaSecurityUtils.formatBase64BinaryElement(xmlstr);
        Document doc = XMLUtils.toDOMDocument(xmlstr, debug);
        XMLSignatureManager sigManager = XMLSignatureManager.getInstance();
        if (spId != null) {
            try {
                xpath = "//*[local-name()=\"SPSSODescriptor\" and namespace-uri()=\"urn:oasis:names:tc:SAML:2.0:metadata\"]/*[1]";
                sigManager.signXML(doc, spCertAlias, null, ATTR_ID, spId, true, xpath);
            }
            catch (XMLSignatureException xmlse) {
                if (debug.messageEnabled()) {
                    debug.message("SAML2MetaSecurityUtils.sign:", xmlse);
                }
                throw new SAML2MetaException(xmlse.getMessage());
            }
        }
        if (idpId != null) {
            try {
                xpath = "//*[local-name()=\"IDPSSODescriptor\" and namespace-uri()=\"urn:oasis:names:tc:SAML:2.0:metadata\"]/*[1]";
                sigManager.signXML(doc, idpCertAlias, null, ATTR_ID, idpId, true, xpath);
            }
            catch (XMLSignatureException xmlse) {
                if (debug.messageEnabled()) {
                    debug.message("SAML2MetaSecurityUtils.sign:", xmlse);
                }
                throw new SAML2MetaException(xmlse.getMessage());
            }
        }
        return doc;
    }

    public static void verifySignature(Document doc) throws SAML2MetaException {
        NodeList sigElements;
        block18: {
            sigElements = null;
            try {
                Element nscontext = com.sun.org.apache.xml.internal.security.utils.XMLUtils.createDSctx((Document)doc, (String)PREFIX_XMLSIG, (String)NS_XMLSIG);
                sigElements = XPathAPI.selectNodeList(doc, "//ds:Signature", nscontext);
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block18;
                debug.message("SAML2MetaSecurityUtils.verifySignature:", ex);
                throw new SAML2MetaException(ex.getMessage());
            }
        }
        int numSigs = sigElements.getLength();
        if (debug.messageEnabled()) {
            debug.message("SAML2MetaSecurityUtils.verifySignature: # of signatures = " + numSigs);
        }
        if (numSigs == 0) {
            return;
        }
        SAML2MetaSecurityUtils.initializeKeyStore();
        for (int i = 0; i < numSigs; ++i) {
            Element sigElement = (Element)sigElements.item(i);
            String sigParentName = sigElement.getParentNode().getLocalName();
            Object[] objs = new Object[]{sigParentName};
            if (debug.messageEnabled()) {
                debug.message("SAML2MetaSecurityUtils.verifySignature: verifying signature under " + sigParentName);
            }
            try {
                XMLSignature signature = new XMLSignature(sigElement, "");
                signature.addResourceResolver(new OfflineResolver());
                KeyInfo ki = signature.getKeyInfo();
                X509Certificate x509cert = null;
                if (ki != null && ki.containsX509Data()) {
                    if (keyStore != null) {
                        StorageResolver sr = new StorageResolver(new KeyStoreResolver(keyStore));
                        ki.addStorageResolver(sr);
                    }
                    x509cert = ki.getX509Certificate();
                }
                if (x509cert == null) {
                    Element kd;
                    String use;
                    String xpath;
                    Node node;
                    if (debug.messageEnabled()) {
                        debug.message("SAML2MetaSecurityUtils.verifySignature: try to find cert in KeyDescriptor");
                    }
                    if ((node = XPathAPI.selectSingleNode(sigElement, xpath = "following-sibling::*[local-name()=\"KeyDescriptor\" and namespace-uri()=\"urn:oasis:names:tc:SAML:2.0:metadata\"]")) != null && (use = (kd = (Element)node).getAttributeNS(null, ATTR_USE)).equals("signing")) {
                        NodeList nl = kd.getChildNodes();
                        for (int j = 0; j < nl.getLength(); ++j) {
                            Node child = nl.item(j);
                            if (child.getNodeType() != 1) continue;
                            String localName = child.getLocalName();
                            String ns = child.getNamespaceURI();
                            if (!TAG_KEY_INFO.equals(localName) || !NS_XMLSIG.equals(ns) || !(ki = new KeyInfo((Element)child, "")).containsX509Data()) break;
                            if (keyStore != null) {
                                KeyStoreResolver ksr = new KeyStoreResolver(keyStore);
                                StorageResolver sr = new StorageResolver(ksr);
                                ki.addStorageResolver(sr);
                            }
                            x509cert = ki.getX509Certificate();
                            break;
                        }
                    }
                }
                if (x509cert == null) {
                    throw new SAML2MetaException("verify_no_cert", objs);
                }
                if (checkCert && keyProvider.getCertificateAlias(x509cert) == null) {
                    throw new SAML2MetaException("untrusted_cert", objs);
                }
                PublicKey pk = x509cert.getPublicKey();
                if (signature.checkSignatureValue(pk)) continue;
                throw new SAML2MetaException("verify_fail", objs);
            }
            catch (SAML2MetaException sme) {
                throw sme;
            }
            catch (Exception ex) {
                debug.error("SAML2MetaSecurityUtils.verifySignature: ", ex);
                throw new SAML2MetaException(Locale.getString(SAML2MetaUtils.resourceBundle, "verify_fail", objs) + "\n" + ex.getMessage());
            }
        }
    }

    public static String formatBase64BinaryElement(String xmlstr) {
        int from = 0;
        int index = xmlstr.indexOf("<ds:X509Certificate>");
        int xmlLength = xmlstr.length();
        StringBuffer sb = new StringBuffer(xmlLength + 100);
        while (index != -1) {
            int i;
            sb.append(xmlstr.substring(from, index));
            int indexEnd = xmlstr.indexOf("</ds:X509Certificate>", index);
            String encoded = xmlstr.substring(index + 20, indexEnd);
            int encodedLength = encoded.length();
            sb.append("<ds:X509Certificate>\n");
            for (i = 0; i < encodedLength - 76; i += 76) {
                sb.append(encoded.substring(i, i + 76)).append("\n");
            }
            int nlIndex = xmlstr.lastIndexOf(10, index);
            String indention = xmlstr.substring(nlIndex + 1, index);
            sb.append(encoded.substring(i, encodedLength)).append("\n").append(indention).append("</ds:X509Certificate>");
            from = indexEnd + 21;
            index = xmlstr.indexOf("<ds:X509Certificate>", from);
        }
        sb.append(xmlstr.substring(from, xmlLength));
        return sb.toString();
    }

    public static String buildX509Certificate(String certAlias) throws SAML2MetaException {
        block4: {
            if (certAlias == null || certAlias.trim().length() == 0) {
                return null;
            }
            X509Certificate cert = KeyUtil.getKeyProviderInstance().getX509Certificate(certAlias);
            if (cert != null) {
                try {
                    return Base64.encode(cert.getEncoded(), 76);
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block4;
                    debug.message("SAML2MetaSecurityUtils.buildX509Certificate:", ex);
                }
            }
        }
        Object[] objs = new Object[]{certAlias};
        throw new SAML2MetaException("invalid_cert_alias", objs);
    }

    public static void updateProviderKeyInfo(String realm, String entityID, String certAlias, boolean isSigning, boolean isIDP, String encAlgo, int keySize) throws SAML2MetaException {
        SAML2MetaManager metaManager = new SAML2MetaManager();
        EntityConfigElement config = metaManager.getEntityConfig(realm, entityID);
        if (!config.isHosted()) {
            Object[] args = new String[]{entityID, realm};
            throw new SAML2MetaException("entityNotHosted", args);
        }
        EntityDescriptorElement desp = metaManager.getEntityDescriptor(realm, entityID);
        if (isIDP) {
            IDPSSOConfigElement idpConfig = SAML2MetaUtils.getIDPSSOConfig(config);
            IDPSSODescriptorElement idpDesp = SAML2MetaUtils.getIDPSSODescriptor(desp);
            if (idpConfig == null || idpDesp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new SAML2MetaException("entityNotIDP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                SAML2MetaSecurityUtils.removeKeyDescriptor(idpDesp, isSigning);
                if (isSigning) {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", null);
                } else {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(idpConfig, "encryptionCertAlias", null);
                }
            } else {
                KeyDescriptorElement kde = SAML2MetaSecurityUtils.getKeyDescriptor(certAlias, isSigning, encAlgo, keySize);
                SAML2MetaSecurityUtils.updateKeyDescriptor(idpDesp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                if (isSigning) {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(idpConfig, "signingCertAlias", value);
                } else {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(idpConfig, "encryptionCertAlias", value);
                }
            }
            metaManager.setEntityDescriptor(realm, desp);
            metaManager.setEntityConfig(realm, config);
        } else {
            SPSSOConfigElement spConfig = SAML2MetaUtils.getSPSSOConfig(config);
            SPSSODescriptorElement spDesp = SAML2MetaUtils.getSPSSODescriptor(desp);
            if (spConfig == null || spDesp == null) {
                Object[] args = new String[]{entityID, realm};
                throw new SAML2MetaException("entityNotSP", args);
            }
            if (certAlias == null || certAlias.length() == 0) {
                SAML2MetaSecurityUtils.removeKeyDescriptor(spDesp, isSigning);
                if (isSigning) {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", null);
                } else {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(spConfig, "encryptionCertAlias", null);
                }
            } else {
                KeyDescriptorElement kde = SAML2MetaSecurityUtils.getKeyDescriptor(certAlias, isSigning, encAlgo, keySize);
                SAML2MetaSecurityUtils.updateKeyDescriptor(spDesp, kde);
                HashSet<String> value = new HashSet<String>();
                value.add(certAlias);
                if (isSigning) {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(spConfig, "signingCertAlias", value);
                } else {
                    SAML2MetaSecurityUtils.setExtendedAttributeValue(spConfig, "encryptionCertAlias", value);
                }
            }
            metaManager.setEntityDescriptor(realm, desp);
            metaManager.setEntityConfig(realm, config);
        }
    }

    private static void updateKeyDescriptor(RoleDescriptorType desp, KeyDescriptorElement newKey) {
        List keys = desp.getKeyDescriptor();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            KeyDescriptorElement key = (KeyDescriptorElement)iter.next();
            if (!key.getUse().equalsIgnoreCase(newKey.getUse())) continue;
            iter.remove();
        }
        desp.getKeyDescriptor().add(newKey);
    }

    private static void removeKeyDescriptor(RoleDescriptorType desp, boolean isSigningUse) {
        List keys = desp.getKeyDescriptor();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            KeyDescriptorElement key = (KeyDescriptorElement)iter.next();
            String keyUse = "encryption";
            if (isSigningUse) {
                keyUse = "signing";
            }
            if (!key.getUse().equalsIgnoreCase(keyUse)) continue;
            iter.remove();
        }
    }

    private static void setExtendedAttributeValue(BaseConfigType config, String attrName, Set attrVal) throws SAML2MetaException {
        try {
            List attributes = config.getAttribute();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                AttributeType avp = (AttributeType)iter.next();
                if (!avp.getName().trim().equalsIgnoreCase(attrName)) continue;
                iter.remove();
            }
            if (attrVal != null) {
                ObjectFactory factory = new ObjectFactory();
                AttributeType atype = factory.createAttributeType();
                atype.setName(attrName);
                atype.getValue().addAll(attrVal);
                config.getAttribute().add(atype);
            }
        }
        catch (JAXBException e) {
            throw new SAML2MetaException(e);
        }
    }

    private static KeyDescriptorElement getKeyDescriptor(String certAlias, boolean isSigning, String encAlgo, int keySize) throws SAML2MetaException {
        try {
            String certString = SAML2MetaSecurityUtils.buildX509Certificate(certAlias);
            StringBuffer sb = new StringBuffer(4000);
            sb.append("<KeyDescriptor xmlns=\"urn:oasis:names:tc:SAML:2.0:metadata\" use=\"");
            if (isSigning) {
                sb.append("signing");
            } else {
                sb.append("encryption");
            }
            sb.append("\">\n").append("<KeyInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\">\n").append("<X509Data>\n").append("<X509Certificate>\n").append(certString).append("\n").append("</X509Certificate>").append("</X509Data>").append("</KeyInfo>");
            if (!isSigning && encAlgo != null) {
                sb.append("<EncryptionMethod Algorithm=\"").append(encAlgo).append("\">\n");
                sb.append("<KeySize xmlns=\"http://www.w3.org/2001/04/xmlenc#\">").append("" + keySize).append("</KeySize>\n").append("</EncryptionMethod>");
            }
            sb.append("</KeyDescriptor>");
            return (KeyDescriptorElement)SAML2MetaUtils.convertStringToJAXB(sb.toString());
        }
        catch (JAXBException e) {
            throw new SAML2MetaException(e);
        }
    }
}

