/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SAML2SDKUtils {
    public static Debug debug = Debug.getInstance("libSAML2");
    public static final String BUNDLE_NAME = "libSAML2";
    public static ResourceBundle bundle = Locale.getInstallResourceBundle("libSAML2");
    protected static final String SAML2ID_PREFIX = "s2";
    public static SecureRandom random = new SecureRandom();
    private static Map classMapping = new HashMap();
    public static final String ACTION = "Action";
    public static final String ADVICE = "Advice";
    public static final String ASSERTION = "Assertion";
    public static final String ASSERTION_ID_REF = "AssertionIDRef";
    public static final String ASSERTION_ID_REQUEST = "AssertionIDRequest";
    public static final String ATTRIBUTE = "Attribute";
    public static final String ATTRIBUTE_STATEMENT = "AttributeStatement";
    public static final String AUDIENCE_RESTRICTION = "AudienceRestriction";
    public static final String AUTHN_CONTEXT = "AuthnContext";
    public static final String AUTHN_STATEMENT = "AuthnStatement";
    public static final String AUTHZ_DECISION_STATEMENT = "AuthzDecisionStatement";
    public static final String BASEID = "BaseID";
    public static final String CONDITION = "Condition";
    public static final String CONDITIONS = "Conditions";
    public static final String ENCRYPTED_ASSERTION = "EncryptedAssertion";
    public static final String ENCRYPTED_ATTRIBUTE = "EncryptedAttribute";
    public static final String ENCRYPTED_ELEMENT = "EncryptedElement";
    public static final String ENCRYPTEDID = "EncryptedID";
    public static final String EVIDENCE = "Evidence";
    public static final String ISSUER = "Issuer";
    public static final String KEYINFO_CONFIRMATION_DATA = "KeyInfoConfirmationData";
    public static final String NAMEID = "NameID";
    public static final String ONE_TIME_USE = "OneTimeUse";
    public static final String PROXY_RESTRICTION = "ProxyRestriction";
    public static final String STATEMENT = "Statement";
    public static final String SUBJECT_CONFIRMATION_DATA = "SubjectConfirmationData";
    public static final String SUBJECT_CONFIRMATION = "SubjectConfirmation";
    public static final String SUBJECT = "Subject";
    public static final String SUBJECT_LOCALITY = "SubjectLocality";
    public static final String ARTIFACT = "Artifact";
    public static final String ARTIFACT_RESOLVE = "ArtifactResolve";
    public static final String ARTIFACT_RESPONSE = "ArtifactResponse";
    public static final String ATTRIBUTE_QUERY = "AttributeQuery";
    public static final String AUTHN_QUERY = "AuthnQuery";
    public static final String AUTHN_REQUEST = "AuthnRequest";
    public static final String ECP_RELAY_STATE = "ECPRelayState";
    public static final String ECP_REQUEST = "ECPRequest";
    public static final String ECP_RESPONSE = "ECPResponse";
    public static final String EXTENSIONS = "Extensions";
    public static final String GET_COMPLETE = "GetComplete";
    public static final String IDPENTRY = "IDPEntry";
    public static final String IDPLIST = "IDPList";
    public static final String LOGOUT_REQUEST = "LogoutRequest";
    public static final String LOGOUT_RESPONSE = "LogoutResponse";
    public static final String MANAGE_NAMEID_REQUEST = "ManageNameIDRequest";
    public static final String MANAGE_NAMEID_RESPONSE = "ManageNameIDResponse";
    public static final String NAMEID_POLICY = "NameIDPolicy";
    public static final String NEW_ENCRYPTEDID = "NewEncryptedID";
    public static final String NEWID = "NewID";
    public static final String REQUESTED_AUTHN_CONTEXT = "RequestedAuthnContext";
    public static final String REQUESTERID = "RequesterID";
    public static final String RESPONSE = "Response";
    public static final String SCOPING = "Scoping";
    public static final String SESSION_INDEX = "SessionIndex";
    public static final String STATUS_CODE = "StatusCode";
    public static final String STATUS_DETAIL = "StatusDetail";
    public static final String STATUS = "Status";
    public static final String STATUS_MESSAGE = "StatusMessage";
    public static final String STATUS_RESPONSE = "StatusResponse";
    public static final String NAMEIDMAPPING_REQ = "NameIDMappingRequest";
    public static final String NAMEIDMAPPING_RES = "NameIDMappingResponse";
    private static String[] interfactNames = new String[]{"Action", "Advice", "Assertion", "AssertionIDRef", "AssertionIDRequest", "Attribute", "AttributeStatement", "AudienceRestriction", "AuthnContext", "AuthnStatement", "AuthzDecisionStatement", "BaseID", "Condition", "Conditions", "EncryptedAssertion", "EncryptedAttribute", "EncryptedElement", "EncryptedID", "Evidence", "Issuer", "KeyInfoConfirmationData", "NameID", "OneTimeUse", "ProxyRestriction", "Statement", "SubjectConfirmationData", "SubjectConfirmation", "Subject", "SubjectLocality", "Artifact", "ArtifactResolve", "ArtifactResponse", "AttributeQuery", "AuthnQuery", "AuthnRequest", "Extensions", "GetComplete", "IDPEntry", "IDPList", "LogoutRequest", "LogoutResponse", "ManageNameIDRequest", "ManageNameIDResponse", "NameIDPolicy", "NewEncryptedID", "NewID", "RequestedAuthnContext", "RequesterID", "Response", "Scoping", "SessionIndex", "StatusCode", "StatusDetail", "Status", "StatusMessage", "StatusResponse", "NameIDMappingRequest", "NameIDMappingResponse"};
    private static Class[] artParam = new Class[]{new byte[2].getClass(), Integer.TYPE, String.class, String.class};
    private static Class[] stringParam = new Class[]{String.class};
    private static Class[] elementParam = new Class[]{Element.class};

    protected SAML2SDKUtils() {
    }

    public static Object getObjectInstance(String iName) {
        Class implClass = (Class)classMapping.get(iName);
        if (implClass == null) {
            return null;
        }
        try {
            return implClass.newInstance();
        }
        catch (InstantiationException ie) {
            debug.error("SAML2SDKUtils.getDefaultInstance: " + iName, ie);
        }
        catch (IllegalAccessException iae) {
            debug.error("SAML2SDKUtils.getDefaultInstance: " + iName, iae);
        }
        return null;
    }

    public static Object getObjectInstance(String iName, String value) {
        Class implClass = (Class)classMapping.get(iName);
        if (implClass == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2SDKUtils.getObjectInstance: new customized impl (String) instance for " + iName);
        }
        Object[] params = new Object[]{value};
        return SAML2SDKUtils.getObjectInstance(implClass, stringParam, params);
    }

    public static Object getObjectInstance(String iName, Element value) {
        Class implClass = (Class)classMapping.get(iName);
        if (implClass == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2SDKUtils.getObjectInstance: new customized impl instance (Element) for " + iName);
        }
        Object[] params = new Object[]{value};
        return SAML2SDKUtils.getObjectInstance(implClass, elementParam, params);
    }

    public static Object getObjectInstance(String iName, byte[] typecode, int endpointIndex, String sourceID, String messageHandle) {
        Class implClass = (Class)classMapping.get(iName);
        if (implClass == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAML2SDKUtils.getObjectInstance: new customized impl (4) instance for " + iName);
        }
        Object[] params = new Object[]{typecode, new Integer(endpointIndex), sourceID, messageHandle};
        return SAML2SDKUtils.getObjectInstance(implClass, artParam, params);
    }

    private static Object getObjectInstance(Class impl, Class[] paramObj, Object[] valueObj) {
        try {
            Constructor constr = impl.getConstructor(paramObj);
            return constr.newInstance(valueObj);
        }
        catch (NoSuchMethodException nsme) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), nsme);
        }
        catch (SecurityException se) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), se);
        }
        catch (InstantiationException ie) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), ie);
        }
        catch (IllegalAccessException iae) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), iae);
        }
        catch (IllegalArgumentException iae) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), iae);
        }
        catch (InvocationTargetException ite) {
            debug.error("SAML2SDKUtils.getObjectInstance: " + impl.getName(), ite);
        }
        return null;
    }

    public static boolean checkStatement(Element element, String statementname) {
        if (element == null || statementname == null) {
            return false;
        }
        String tag = element.getLocalName();
        if (tag == null) {
            return false;
        }
        if (tag.equals(STATEMENT)) {
            NamedNodeMap nm = element.getAttributes();
            int len = nm.getLength();
            String attrName = null;
            Attr attr = null;
            for (int j = 0; j < len; ++j) {
                attr = (Attr)nm.item(j);
                attrName = attr.getLocalName();
                if (attrName == null || !attrName.equals("type") || !attr.getNodeValue().equals(statementname + "Type")) continue;
                return true;
            }
        } else if (tag.equals(statementname)) {
            return true;
        }
        return false;
    }

    public static String byteArrayToString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = (char)bytes[i];
        }
        return new String(chars);
    }

    public static byte[] intToTwoBytes(int i) throws SAML2Exception {
        if (i < 0 || i > 65535) {
            debug.error("SAML2Utils.intToTwoBytes: wrong index value range.");
            throw new SAML2Exception(bundle.getString("wrongInput"));
        }
        String hexStr = Integer.toHexString(i);
        int len = hexStr.length();
        String norm = null;
        if (len > 4) {
            norm = hexStr.substring(0, 4);
        } else {
            switch (len) {
                case 1: {
                    norm = "000" + hexStr;
                    break;
                }
                case 2: {
                    norm = "00" + hexStr;
                    break;
                }
                case 3: {
                    norm = "0" + hexStr;
                    break;
                }
                default: {
                    norm = hexStr;
                }
            }
        }
        byte[] bytes = SAML2SDKUtils.hexStringToByteArray(norm);
        return bytes;
    }

    public static int twoBytesToInt(byte[] bytes) throws SAML2Exception {
        if (bytes == null || bytes.length != 2) {
            debug.error("SAML2Utils.twoBytesToInt: input is null or length is not 2.");
            throw new SAML2Exception(bundle.getString("wrontInput"));
        }
        String str0 = Integer.toHexString(bytes[0]);
        int len0 = str0.length();
        String norm0 = null;
        norm0 = len0 > 2 ? str0.substring(len0 - 2, len0) : str0;
        String str1 = Integer.toHexString(bytes[1]);
        int len1 = str1.length();
        String norm1 = null;
        norm1 = len1 > 2 ? str1.substring(len1 - 2, len1) : (len1 == 1 ? "0" + str1 : str1);
        String wholeHexStr = norm0 + norm1;
        int i = Integer.parseInt(wholeHexStr, 16);
        return i;
    }

    public static String generateMessageHandle() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return SAML2SDKUtils.byteArrayToString(bytes);
    }

    public static byte[] stringToByteArray(String input) {
        char[] chars = input.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String byteArrayToHexString(byte[] byteArray) {
        int readBytes = byteArray.length;
        StringBuffer hexData = new StringBuffer();
        for (int i = 0; i < readBytes; ++i) {
            int onebyte = 0xFF & byteArray[i] | 0xFFFFFF00;
            hexData.append(Integer.toHexString(onebyte).substring(6));
        }
        return hexData.toString();
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int read = hexString.length();
        byte[] byteArray = new byte[read / 2];
        int i = 0;
        int j = 0;
        while (i < read) {
            String part = hexString.substring(i, i + 2);
            byteArray[j] = new Short(Integer.toString(Integer.parseInt(part, 16))).byteValue();
            ++i;
            ++i;
            ++j;
        }
        return byteArray;
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return SAML2ID_PREFIX + SAML2SDKUtils.byteArrayToHexString(bytes);
    }

    public static ResourceOffering getDiscoveryBootStrapResourceOffering(HttpServletRequest request) {
        if (request == null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getDiscoveryBootStrapResourceOfferings: null Input params");
            }
            return null;
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object session = sessionProvider.getSession(request);
            String[] roStr = sessionProvider.getProperty(session, "urn:liberty:disco:2003-08:DiscoveryResourceOffering");
            if (roStr == null || roStr.length == 0) {
                return null;
            }
            return new ResourceOffering(XMLUtils.toDOMDocument(roStr[0], debug).getDocumentElement());
        }
        catch (Exception ex) {
            debug.error("SAML2Utils.getDiscoveryBootStrapResourceOfferings:  Exception while retrieving discovery boot strap info.", ex);
            return null;
        }
    }

    public static List getDiscoveryBootStrapCredentials(HttpServletRequest request) {
        if (request == null) {
            if (debug.messageEnabled()) {
                debug.message("SAML2Utils.getDiscoveryBootStrapCredentials:  null Input params");
            }
            return null;
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object session = sessionProvider.getSession(request);
            String[] credentials = sessionProvider.getProperty(session, "DiscoveryBootstrapCrendentials");
            if (credentials == null || credentials.length == 0) {
                return null;
            }
            ArrayList<SecurityAssertion> securityAssertions = new ArrayList<SecurityAssertion>();
            for (int i = 0; i < credentials.length; ++i) {
                SecurityAssertion securityAssertion = new SecurityAssertion(XMLUtils.toDOMDocument(credentials[i], debug).getDocumentElement());
                securityAssertions.add(securityAssertion);
            }
            return securityAssertions;
        }
        catch (Exception ex) {
            debug.error("SAML2Utils.getDiscoveryBootStrapCredentials: ", ex);
            return null;
        }
    }

    public static String createSOAPMessageString(String xmlString) throws SOAPException, SAML2Exception {
        StringBuffer sb = new StringBuffer(500);
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.createSOAPMessage: xmlstr = " + xmlString);
        }
        sb.append("<").append("soap-env").append(":Envelope").append(" ").append("xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\">").append("<").append("soap-env").append(":Body>").append(xmlString).append("</").append("soap-env").append(":Body>").append("</").append("soap-env").append(":Envelope>").append("\n");
        if (debug.messageEnabled()) {
            debug.message("SAML2Utils.createSOAPMessage: soap message = " + sb.toString());
        }
        return sb.toString();
    }

    public static String fillInBasicAuthInfo(BaseConfigType config, String locationURL) {
        if (config == null) {
            return locationURL;
        }
        Map map = SAML2MetaUtils.getAttributes(config);
        List baoList = (List)map.get("basicAuthOn");
        if (baoList == null || baoList.isEmpty()) {
            return locationURL;
        }
        String on = (String)baoList.get(0);
        if (on == null) {
            return locationURL;
        }
        if ((on = on.trim()).length() == 0 || !on.equalsIgnoreCase("true")) {
            return locationURL;
        }
        List ul = (List)map.get("basicAuthUser");
        if (ul == null || ul.isEmpty()) {
            return locationURL;
        }
        String u = (String)ul.get(0);
        if (u == null) {
            return locationURL;
        }
        if ((u = u.trim()).length() == 0) {
            return locationURL;
        }
        List pl = (List)map.get("basicAuthPassword");
        String p = null;
        if (pl != null && !pl.isEmpty()) {
            p = (String)pl.get(0);
        }
        if (p == null) {
            p = "";
        }
        String dp = SAMLUtilsCommon.decodePassword(p);
        int index = locationURL.indexOf("//");
        return locationURL.substring(0, index + 2) + u + ":" + dp + "@" + locationURL.substring(index + 2);
    }

    public static Boolean StringToBoolean(String str) throws SAML2Exception {
        if (str == null) {
            return null;
        }
        if (str.equals("true") || str.equals("1")) {
            return Boolean.TRUE;
        }
        if (str.equals("false") || str.equals("0")) {
            return Boolean.FALSE;
        }
        throw new SAML2Exception(bundle.getString("invalidXMLBooleanValue"));
    }

    public static String removeDeployUri(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        int loc = uri.indexOf("/", 1);
        if (loc == -1) {
            return null;
        }
        return uri.substring(loc);
    }

    static {
        int len = interfactNames.length;
        for (int i = 0; i < len; ++i) {
            String iName = interfactNames[i];
            try {
                String implClass = SystemPropertiesManager.get("com.sun.identity.saml2.sdk.mapping." + iName);
                if (implClass == null || implClass.trim().length() == 0) continue;
                if (debug.messageEnabled()) {
                    debug.message("SAML2SDKUtils.init: mapper for " + iName + "=" + implClass);
                }
                classMapping.put(iName, Class.forName(implClass.trim()));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                debug.error("SAML2SDKUtils.init: " + iName, cnfe);
            }
        }
    }
}

