/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectConfirmationDataImpl
implements SubjectConfirmationData {
    public final String elementName = "SubjectConfirmationData";
    protected boolean mutable = false;
    private Date notOnOrAfter = null;
    private String inResponseTo = null;
    private List content = null;
    private String recipient = null;
    private Date notBefore = null;
    private String address = null;
    private String contentType = null;

    public SubjectConfirmationDataImpl() {
        this.mutable = true;
    }

    public SubjectConfirmationDataImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        this.makeImmutable();
    }

    public SubjectConfirmationDataImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument(xmlString, SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("");
        }
        this.parseElement(doc.getDocumentElement());
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = element.getLocalName();
        if (tag == null || !tag.equals("SubjectConfirmationData")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("parseElement: not SubjectConfirmationData.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap attrs = element.getAttributes();
        this.parseAttributes(attrs);
        this.parseContent(element);
    }

    protected void parseContent(Element element) throws SAML2Exception {
        if (element == null) {
            return;
        }
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                if (childNode.getLocalName() == null) continue;
                this.getContent().add(childNode);
            }
        }
        if (this.content == null) {
            this.content = new ArrayList();
            this.content.add(XMLUtils.getElementValue(element));
        }
    }

    protected void parseAttributes(NamedNodeMap attrs) throws SAML2Exception {
        if (attrs == null) {
            return;
        }
        try {
            int length = attrs.getLength();
            for (int i = 0; i < length; ++i) {
                Attr attr = (Attr)attrs.item(i);
                String attrName = attr.getName().trim();
                String attrValue = attr.getValue().trim();
                if (attrName.equals("Address")) {
                    this.address = attrValue;
                    continue;
                }
                if (attrName.equals("InResponseTo")) {
                    this.inResponseTo = attrValue;
                    continue;
                }
                if (attrName.equals("NotBefore")) {
                    this.notBefore = DateUtils.stringToDate(attrValue);
                    continue;
                }
                if (attrName.equals("NotOnOrAfter")) {
                    this.notOnOrAfter = DateUtils.stringToDate(attrValue);
                    continue;
                }
                if (attrName.equals("Recipient")) {
                    this.recipient = attrValue;
                    continue;
                }
                if (!attrName.equals("xsi:type")) continue;
                this.contentType = attrValue;
            }
        }
        catch (ParseException e) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("parseAttributes: " + e.toString());
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.notOnOrAfter = value;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.inResponseTo = value;
    }

    public List getContent() {
        if (this.content == null) {
            this.content = new ArrayList();
        }
        return this.content;
    }

    public void setContent(List value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.content = value;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.recipient = value;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.notBefore = value;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.address = value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String attribute) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.contentType = attribute;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer xml = new StringBuffer();
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        xml.append("<").append(appendNS).append("SubjectConfirmationData");
        xml.append(NS).append(" ");
        xml.append(this.getElementValue(includeNSPrefix, declareNS));
        xml.append("</").append(appendNS).append("SubjectConfirmationData").append(">");
        return xml.toString();
    }

    protected String getElementValue(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        StringBuffer xml = new StringBuffer();
        if (this.notOnOrAfter != null) {
            xml.append("NotOnOrAfter=\"");
            xml.append(DateUtils.toUTCDateFormat(this.notOnOrAfter));
            xml.append("\" ");
        }
        if (this.inResponseTo != null) {
            xml.append("InResponseTo=\"");
            xml.append(this.inResponseTo);
            xml.append("\" ");
        }
        if (this.recipient != null) {
            xml.append("Recipient=\"");
            xml.append(this.recipient);
            xml.append("\" ");
        }
        if (this.notBefore != null) {
            xml.append("NotBefore=\"");
            xml.append(DateUtils.toUTCDateFormat(this.notBefore));
            xml.append("\" ");
        }
        if (this.address != null) {
            xml.append("Address=\"");
            xml.append(this.address);
            xml.append("\" ");
        }
        if (this.contentType != null) {
            xml.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(" ").append("xsi:type=\"").append(this.contentType).append("\" ");
        }
        xml.append(">");
        if (!this.getContent().isEmpty()) {
            Iterator it = this.getContent().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof Element) {
                    xml.append(XMLUtils.print((Element)obj)).append(" ");
                    continue;
                }
                if (!(obj instanceof String)) continue;
                xml.append((String)obj);
            }
        }
        return xml.toString();
    }

    public void makeImmutable() {
        if (!this.mutable) {
            return;
        }
        this.mutable = false;
        if (this.content != null && !this.content.isEmpty()) {
            this.content = Collections.unmodifiableList(this.content);
        }
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

