/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AudienceRestriction;
import com.sun.identity.saml2.assertion.Condition;
import com.sun.identity.saml2.assertion.ConditionAbstract;
import com.sun.identity.saml2.assertion.Conditions;
import com.sun.identity.saml2.assertion.OneTimeUse;
import com.sun.identity.saml2.assertion.ProxyRestriction;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConditionsImpl
implements Conditions {
    private Date notOnOrAfter;
    private List conditions = new ArrayList();
    private List audienceRestrictions = new ArrayList();
    private List oneTimeUses = new ArrayList();
    private List proxyRestrictions = new ArrayList();
    private Date notBefore;
    private boolean isMutable = true;
    public static final String CONDITIONS_ELEMENT = "Conditions";
    public static final String CONDITION_ELEMENT = "Condition";
    public static final String ONETIMEUSE_ELEMENT = "OneTimeUse";
    public static final String AUDIENCE_RESTRICTION_ELEMENT = "AudienceRestriction";
    public static final String PROXY_RESTRICTION_ELEMENT = "ProxyRestriction";
    public static final String NOT_BEFORE_ATTR = "NotBefore";
    public static final String NOT_ON_OR_AFTER_ATTR = "NotOnOrAfter";

    public ConditionsImpl() {
    }

    public ConditionsImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument(xml, SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public ConditionsImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(CONDITIONS_ELEMENT)) {
            SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        String attrValue = element.getAttribute(NOT_BEFORE_ATTR);
        if (attrValue != null && attrValue.trim().length() != 0) {
            try {
                this.notBefore = DateUtils.stringToDate(attrValue);
            }
            catch (ParseException pe) {
                SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): invalid NotBefore attribute");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_date_format"));
            }
        }
        if ((attrValue = element.getAttribute(NOT_ON_OR_AFTER_ATTR)) != null && attrValue.trim().length() != 0) {
            try {
                this.notOnOrAfter = DateUtils.stringToDate(attrValue);
            }
            catch (ParseException pe) {
                SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): invalid NotOnORAfter attribute");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_date_format"));
            }
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
            String childName;
            Node child = nodes.item(nextElem);
            if (child.getNodeType() != 1 || (childName = child.getLocalName()) == null) continue;
            if (childName.equals(CONDITION_ELEMENT)) {
                this.conditions.add(AssertionFactory.getInstance().createCondition((Element)child));
                continue;
            }
            if (childName.equals(AUDIENCE_RESTRICTION_ELEMENT)) {
                this.audienceRestrictions.add(AssertionFactory.getInstance().createAudienceRestriction((Element)child));
                continue;
            }
            if (childName.equals(ONETIMEUSE_ELEMENT)) {
                this.oneTimeUses.add(AssertionFactory.getInstance().createOneTimeUse((Element)child));
                continue;
            }
            if (childName.equals(PROXY_RESTRICTION_ELEMENT)) {
                this.proxyRestrictions.add(AssertionFactory.getInstance().createProxyRestriction((Element)child));
                continue;
            }
            SAML2SDKUtils.debug.error("ConditionsImpl.processElement(): unexpected subelement " + childName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
        }
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.notOnOrAfter = value;
    }

    public List getConditions() {
        return this.conditions;
    }

    public List getAudienceRestrictions() {
        return this.audienceRestrictions;
    }

    public List getOneTimeUses() {
        return this.oneTimeUses;
    }

    public List getProxyRestrictions() {
        return this.proxyRestrictions;
    }

    public void setConditions(List conditions) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.conditions = conditions;
    }

    public void setAudienceRestrictions(List ars) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.audienceRestrictions = ars;
    }

    public void setOneTimeUses(List oneTimeUses) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.oneTimeUses = oneTimeUses;
    }

    public void setProxyRestrictions(List prs) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.proxyRestrictions = prs;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.notBefore = value;
    }

    public boolean checkDateValidity(long someTime) {
        if (this.notBefore == null) {
            if (this.notOnOrAfter == null) {
                return true;
            }
            if (someTime < this.notOnOrAfter.getTime()) {
                return true;
            }
        } else if (this.notOnOrAfter == null ? someTime >= this.notBefore.getTime() : someTime >= this.notBefore.getTime() && someTime < this.notOnOrAfter.getTime()) {
            return true;
        }
        return false;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        ConditionAbstract ar;
        int i;
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(CONDITIONS_ELEMENT).append(NS);
        String str = null;
        if (this.notBefore != null) {
            str = DateUtils.toUTCDateFormat(this.notBefore);
            sb.append(" ").append(NOT_BEFORE_ATTR).append("=\"").append(str).append("\"");
        }
        if (this.notOnOrAfter != null) {
            str = DateUtils.toUTCDateFormat(this.notOnOrAfter);
            sb.append(" ").append(NOT_ON_OR_AFTER_ATTR).append("=\"").append(str).append("\"");
        }
        sb.append(">\n");
        int length = 0;
        if (this.conditions != null) {
            length = this.conditions.size();
            for (i = 0; i < length; ++i) {
                Condition condition = (Condition)this.conditions.get(i);
                sb.append(condition.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.audienceRestrictions != null) {
            length = this.audienceRestrictions.size();
            for (i = 0; i < length; ++i) {
                ar = (AudienceRestriction)this.audienceRestrictions.get(i);
                sb.append(ar.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.oneTimeUses != null) {
            length = this.oneTimeUses.size();
            for (i = 0; i < length; ++i) {
                ar = (OneTimeUse)this.oneTimeUses.get(i);
                sb.append(ar.toXMLString(includeNSPrefix, false));
            }
        }
        if (this.proxyRestrictions != null) {
            length = this.proxyRestrictions.size();
            for (i = 0; i < length; ++i) {
                ProxyRestriction pr = (ProxyRestriction)this.proxyRestrictions.get(i);
                sb.append(pr.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(appendNS).append(CONDITIONS_ELEMENT).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            int i;
            int length;
            if (this.conditions != null) {
                length = this.conditions.size();
                for (i = 0; i < length; ++i) {
                    Condition condition = (Condition)this.conditions.get(i);
                    condition.makeImmutable();
                }
                this.conditions = Collections.unmodifiableList(this.conditions);
            }
            if (this.audienceRestrictions != null) {
                length = this.audienceRestrictions.size();
                for (i = 0; i < length; ++i) {
                    AudienceRestriction ar = (AudienceRestriction)this.audienceRestrictions.get(i);
                    ar.makeImmutable();
                }
                this.audienceRestrictions = Collections.unmodifiableList(this.audienceRestrictions);
            }
            if (this.oneTimeUses != null) {
                length = this.oneTimeUses.size();
                for (i = 0; i < length; ++i) {
                    OneTimeUse oneTimeUse = (OneTimeUse)this.oneTimeUses.get(i);
                    oneTimeUse.makeImmutable();
                }
                this.oneTimeUses = Collections.unmodifiableList(this.oneTimeUses);
            }
            if (this.proxyRestrictions != null) {
                length = this.proxyRestrictions.size();
                for (i = 0; i < length; ++i) {
                    ProxyRestriction pr = (ProxyRestriction)this.proxyRestrictions.get(i);
                    pr.makeImmutable();
                }
                this.proxyRestrictions = Collections.unmodifiableList(this.proxyRestrictions);
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

