/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.SubjectQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthenticationQuery
extends SubjectQuery {
    protected String authMethod = null;

    protected AuthenticationQuery() {
    }

    public AuthenticationQuery(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtils.debug.message("AuthenticationQuery: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        boolean valid = SAMLUtils.checkQuery(element, "AuthenticationQuery");
        if (!valid) {
            SAMLUtils.debug.message("AuthenticationQuery: Wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = element.getChildNodes();
        int length = nl.getLength();
        for (int k = 0; k < length; ++k) {
            Node child = nl.item(k);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("Subject")) {
                if (this.subject != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("AuthenticationQuery: contained more than one <Subject>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.subject = new Subject((Element)child);
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AuthenticationQuery: included wrong element:" + childName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.subject == null) {
            SAMLUtils.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        if (element.hasAttribute("AuthenticationMethod")) {
            this.authMethod = element.getAttribute("AuthenticationMethod");
        }
    }

    public AuthenticationQuery(Subject subject, String authMethod) throws SAMLException {
        if (subject == null) {
            SAMLUtils.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.subject = subject;
        this.authMethod = authMethod;
    }

    public AuthenticationQuery(Subject subject) throws SAMLException {
        if (subject == null) {
            SAMLUtils.debug.message("AuthenticationQuery: missing Subject.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.subject = subject;
    }

    public String getAuthenticationMethod() {
        return this.authMethod;
    }

    public int getQueryType() {
        return 0;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(200);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        xml.append("<").append(prefix).append("AuthenticationQuery").append(uri);
        if (this.authMethod != null) {
            xml.append(" AuthenticationMethod=\"").append(this.authMethod).append("\"");
        }
        xml.append(">\n").append(this.subject.toString(true, true));
        xml.append("</").append(prefix).append("AuthenticationQuery>\n");
        return xml.toString();
    }
}

