/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.shared.encode.Base64;
import java.security.MessageDigest;
import java.util.Random;

public class SAMLSiteID {
    private static Random random = new Random();

    private SAMLSiteID() {
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        String encodedID = null;
        try {
            encodedID = Base64.encode(bytes).trim();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodedID;
    }

    public static String generateSourceID(String siteURL) {
        if (siteURL == null || siteURL.length() == 0) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        char[] chars = siteURL.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        md.update(bytes);
        byte[] byteResult = md.digest();
        String result = null;
        try {
            result = Base64.encode(byteResult);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage : java SAMLSiteID <host_name>");
            return;
        }
        System.out.println(SAMLSiteID.generateSourceID(args[0]));
    }
}

