/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Action {
    protected String _action = null;
    protected String _namespace = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";

    public Action(Element element) throws SAMLException {
        if (element == null) {
            SAMLUtilsCommon.debug.message("Action: Input is null.");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("Action")) {
            SAMLUtilsCommon.debug.message("Action: wrong input");
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        int attrCount = atts.getLength();
        int i = 0;
        for (i = 0; i < attrCount; ++i) {
            Node att = atts.item(i);
            if (att.getNodeType() != 2) continue;
            String attName = att.getLocalName();
            if (attName == null || attName.length() == 0) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Action: Attribute Nameis either null or empty.");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
            }
            if (attName.equals("Namespace")) {
                this._namespace = ((Attr)att).getValue().trim();
            }
            if (this._namespace != null && this._namespace.length() != 0) continue;
            this._namespace = "urn:oasis:names:tc:SAML:1.0:action:rwedc-negation";
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Action: Wrong input");
                }
                throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("wrongInput"));
            }
        }
        this._action = XMLUtils.getElementValue(element);
        if (this._action == null) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Action is null.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("missingElementValue"));
        }
        if (!this.isValid(this._action, this._namespace)) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Action is invalid");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidAction"));
        }
    }

    public Action(String namespace, String action) throws SAMLException {
        if (namespace == null || namespace.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Action:Take default Attribute Namespace.");
            }
        } else {
            this._namespace = namespace;
        }
        if (action == null || action.length() == 0) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Action:Action is null or empty.");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("nullInput"));
        }
        this._action = action;
        if (!this.isValid(this._action, this._namespace)) {
            if (SAMLUtilsCommon.debug.messageEnabled()) {
                SAMLUtilsCommon.debug.message("Action is invalid");
            }
            throw new SAMLRequesterException(SAMLUtilsCommon.bundle.getString("invalidAction"));
        }
    }

    private boolean isValid(String action, String namespace) {
        if (namespace.equals("urn:oasis:names:tc:SAML:1.0:action:rwedc")) {
            return action.equals("Read") || action.equals("Write") || action.equals("Execute") || action.equals("Delete") || action.equals("Control");
        }
        if (namespace.equals("urn:oasis:names:tc:SAML:1.0:action:rwedc-negation")) {
            return action.equals("Read") || action.equals("~Read") || action.equals("Write") || action.equals("~Write") || action.equals("Execute") || action.equals("~Execute") || action.equals("Delete") || action.equals("~Delete") || action.equals("Control") || action.equals("~Control");
        }
        if (namespace.equals("urn:oasis:names:tc:SAML:1.0:ghpp")) {
            return action.equals("GET") || action.equals("HEAD") || action.equals("PUT") || action.equals("POST");
        }
        if (namespace.equals("urn:oasis:names:tc:SAML:1.0:action:unix")) {
            int permissionNum = 0;
            try {
                permissionNum = Integer.parseInt(action);
            }
            catch (NumberFormatException ne) {
                if (SAMLUtilsCommon.debug.messageEnabled()) {
                    SAMLUtilsCommon.debug.message("Actions: Unix file permissions error:" + ne.getMessage());
                }
                return false;
            }
            int quota = permissionNum / 1000;
            int remain = permissionNum - 1000 * quota;
            int tmp = 0;
            if (quota == 0 || quota == 2 || quota == 4 || quota == 6) {
                for (int i = 0; i < 3; ++i) {
                    tmp = remain / 10;
                    quota = remain - tmp * 10;
                    if (quota < 0 || quota > 7) {
                        return false;
                    }
                    remain = tmp;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public String getAction() {
        return this._action;
    }

    public String getNameSpace() {
        return this._namespace;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        result.append("<").append(prefix).append("Action ").append(uri).append(" Namespace=\"").append(this._namespace).append("\">");
        result.append(this._action);
        result.append("</").append(prefix).append("Action>\n");
        return result.toString();
    }
}

