/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.plugin.log.impl;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.plugin.log.LogException;
import com.sun.identity.plugin.log.Logger;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.Map;
import java.util.logging.Level;

public class LogProvider
implements Logger {
    protected com.sun.identity.log.Logger accessLogger;
    protected com.sun.identity.log.Logger errorLogger;
    private LogMessageProvider msgProvider;
    private static Debug debug = Debug.getInstance("amLogProvider");
    private static boolean logStatus = false;

    public void init(String componentName) throws LogException {
        this.accessLogger = (com.sun.identity.log.Logger)com.sun.identity.log.Logger.getLogger(componentName + ".access");
        this.errorLogger = (com.sun.identity.log.Logger)com.sun.identity.log.Logger.getLogger(componentName + ".error");
        try {
            this.msgProvider = MessageProviderFactory.getProvider(componentName);
        }
        catch (IOException e) {
            debug.error("LogProvider.<init>: unable to create log message provider", e);
        }
    }

    public void access(Level level, String messageId, String[] data, Object session) throws LogException {
        this.access(level, messageId, data, session, null);
    }

    public void access(Level level, String messageId, String[] data, Object session, Map props) throws LogException {
        SSOToken authSSOToken;
        LogRecord lr;
        if (this.isAccessLoggable(level) && (lr = this.getLogRecord(messageId, data, session, props, authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()))) != null) {
            this.accessLogger.log(lr, authSSOToken);
        }
    }

    private LogRecord getLogRecord(String messageId, String[] data, Object session, Map properties, SSOToken authSSOToken) {
        SSOToken ssoToken = null;
        if (session != null) {
            try {
                String sid = SessionManager.getProvider().getSessionID(session);
                ssoToken = SSOTokenManager.getInstance().createSSOToken(sid);
            }
            catch (SessionException se) {
                debug.message("Error getting session provider: ", se);
            }
            catch (SSOException soe) {
                debug.message("Error creating SSOToken: ", soe);
            }
        }
        SSOToken realToken = ssoToken != null ? ssoToken : authSSOToken;
        LogRecord lr = this.msgProvider.createLogRecord(messageId, data, realToken);
        if (properties != null && lr != null) {
            String nameIDValue = (String)properties.get("NameID");
            if (nameIDValue != null && nameIDValue.length() > 0) {
                lr.addLogInfo("NameID", nameIDValue);
            }
            if (ssoToken == null) {
                String contextID;
                String moduleName;
                String loginIDSid;
                String ipAddress;
                String clientID;
                String clientDomain = (String)properties.get("Domain");
                if (clientDomain != null) {
                    lr.addLogInfo("Domain", clientDomain);
                }
                if ((clientID = (String)properties.get("LoginID")) != null) {
                    lr.addLogInfo("LoginID", clientID);
                }
                if ((ipAddress = (String)properties.get("IPAddr")) != null) {
                    String hostName = ipAddress;
                    try {
                        if (com.sun.identity.log.Logger.resolveHostNameEnabled()) {
                            hostName = InetAddress.getByName(ipAddress).getHostName();
                        }
                    }
                    catch (Exception e) {
                        if (debug.messageEnabled()) {
                            debug.message("LogProvider:Unable to get Host for:" + ipAddress);
                        }
                        hostName = ipAddress;
                    }
                    lr.addLogInfo("IPAddr", hostName);
                }
                if ((loginIDSid = (String)properties.get("LoginIDSid")) != null) {
                    lr.addLogInfo("LoginIDSid", loginIDSid);
                }
                if ((moduleName = (String)properties.get("ModuleName")) != null) {
                    lr.addLogInfo("ModuleName", moduleName);
                }
                if ((contextID = (String)properties.get("ContextID")) != null) {
                    lr.addLogInfo("ContextID", contextID);
                }
            }
        }
        return lr;
    }

    public void error(Level level, String messageId, String[] data, Object session) throws LogException {
        this.error(level, messageId, data, session, null);
    }

    public void error(Level level, String messageId, String[] data, Object session, Map props) throws LogException {
        SSOToken authSSOToken;
        LogRecord lr;
        if (this.isErrorLoggable(level) && (lr = this.getLogRecord(messageId, data, session, props, authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance()))) != null) {
            this.errorLogger.log(lr, authSSOToken);
        }
    }

    public boolean isLogEnabled() {
        return logStatus;
    }

    public boolean isAccessLoggable(Level level) {
        SSOToken authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (authSSOToken == null || !logStatus) {
            return false;
        }
        return this.accessLogger.isLoggable(level);
    }

    public boolean isErrorLoggable(Level level) {
        SSOToken authSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        if (authSSOToken == null || !logStatus) {
            return false;
        }
        return this.errorLogger.isLoggable(level);
    }

    static {
        String status = SystemPropertiesManager.get("com.iplanet.am.logstatus");
        logStatus = status != null && status.equalsIgnoreCase("ACTIVE");
    }
}

