/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.identity.monitoring.Monitoring;
import com.sun.identity.monitoring.MonitoringUtils;
import com.sun.mfwk.instrum.me.CIM_ManagedElementInstrum;
import com.sun.mfwk.instrum.me.CMM_ApplicationSystemInstrum;
import com.sun.mfwk.instrum.me.CMM_SWRCacheInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceAccessURIInstrum;
import com.sun.mfwk.instrum.me.CMM_ServiceInstrum;
import com.sun.mfwk.instrum.me.MfManagedElementInstrumException;
import com.sun.mfwk.instrum.me.settings.CMM_SWRCacheSettingInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_SWRCacheStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceAccessURIStatsInstrum;
import com.sun.mfwk.instrum.me.statistics.CMM_ServiceStatsInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrum;
import com.sun.mfwk.instrum.relations.MfRelationInstrumException;
import com.sun.mfwk.instrum.server.MfManagedElementInfo;
import com.sun.mfwk.instrum.server.MfManagedElementServer;
import com.sun.mfwk.instrum.server.MfManagedElementServerException;
import com.sun.mfwk.instrum.server.MfManagedElementType;
import com.sun.mfwk.instrum.server.MfRelationInfo;
import com.sun.mfwk.instrum.server.MfRelationType;
import java.util.HashSet;

public class MonitoringSAMLv1 {
    private static CMM_ServiceInstrum amSvcSAML10;
    private static CMM_ServiceInstrum amSvcSAML10SAMLPostProfile;
    private static CMM_ServiceInstrum amSvcSAML10SAMLAware;
    private static CMM_ServiceInstrum amSvcSAML10SAMLSOAPReceiver;
    private static CMM_ServiceStatsInstrum amSAML10SAMLSvcStats;
    private static CMM_ServiceStatsInstrum amSAML10SAMLPostProfileStats;
    private static CMM_ServiceStatsInstrum amSAML10SAMLAwareStats;
    private static CMM_ServiceStatsInstrum amSAML10SAMLSOAPReceiverStats;
    private static CMM_ServiceAccessURIInstrum amSAML10PostProfileUri;
    private static CMM_ServiceAccessURIInstrum amSAML10SAMLAwareUri;
    private static CMM_ServiceAccessURIInstrum amSAML10SOAPReceiverUri;
    private static CMM_ServiceAccessURIInstrum amSAML10JaxrpcUri;
    private static CMM_ServiceAccessURIStatsInstrum amSAML10SAMLPOSTProfileUriStats;
    private static CMM_ServiceAccessURIStatsInstrum amSAML10SAMLAwareUriStats;
    private static CMM_ServiceAccessURIStatsInstrum amSAML10SAMLSOAPRcvrUriStats;
    private static CMM_ServiceAccessURIStatsInstrum amSAML10JaxrpcUriStats;
    private static CMM_SWRCacheInstrum amSAML10AssertionCacheElement;
    private static CMM_SWRCacheInstrum amSAML10ArtifactCacheElement;
    private static CMM_SWRCacheStatsInstrum amSAML10AssertionCacheStats;
    private static CMM_SWRCacheStatsInstrum amSAML10ArtifactCacheStats;
    private static CMM_SWRCacheSettingInstrum amSAML10AssertionCacheSetting;
    private static CMM_SWRCacheSettingInstrum amSAML10ArtifactCacheSetting;

    private MonitoringSAMLv1() {
    }

    protected static int createSAMLv1(MfManagedElementServer mfMEServer, CMM_ApplicationSystemInstrum amAppli) {
        Monitoring.debug.message("MonitoringSAMLv1:createSAMLv1");
        try {
            MfManagedElementInfo meInfo = mfMEServer.makeManagedElementInfo();
            MfRelationInfo relInfo = mfMEServer.makeRelationInfo();
            MfRelationInstrum mRI = null;
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("SAML1.0");
            relInfo.setType(MfRelationType.CMM_HOSTED_SERVICE);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSvcSAML10 = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("SAML1.0 SAMLPOSTProfile servlet");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, meInfo);
            amSvcSAML10SAMLPostProfile = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("SAML1.0 SAMLAware servlet");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, meInfo);
            amSvcSAML10SAMLAware = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE);
            meInfo.setName("SAML1.0 SAMLSOAPReceiver servlet");
            relInfo.setType(MfRelationType.CMM_SERVICE_COMPONENT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, meInfo);
            amSvcSAML10SAMLSOAPReceiver = (CMM_ServiceInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI);
            meInfo.setName("SAML1.0 POSTProfileServlet URI");
            relInfo.setType(MfRelationType.CMM_HOSTED_ACCESS_POINT);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSAML10PostProfileUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amSAML10PostProfileUri.setLabeledURI("%protocol://%host:%port/openfam/SAMLPOSTProfileServlet");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSAML10SAMLPostProfile, relInfo, (CIM_ManagedElementInstrum)amSAML10PostProfileUri);
            meInfo.setName("SAML1.0 SAMLAwareServlet URI");
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSAML10SAMLAwareUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amSAML10SAMLAwareUri.setLabeledURI("%protocol://%host:%port/openfam/SAMLAWareServlet");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSAML10SAMLAware, relInfo, (CIM_ManagedElementInstrum)amSAML10SAMLAwareUri);
            meInfo.setName("SAML1.0 SAMLSOAPReceiver URI");
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSAML10SOAPReceiverUri = (CMM_ServiceAccessURIInstrum)mRI.getDestination();
            amSAML10SOAPReceiverUri.setLabeledURI("%protocol://%host:%port/openfam/SAMLSDOAPReceiver");
            relInfo.setType(MfRelationType.CMM_SERVICE_ACCESS_BY_SAP);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSAML10SAMLSOAPReceiver, relInfo, (CIM_ManagedElementInstrum)amSAML10SOAPReceiverUri);
            meInfo.setType(MfManagedElementType.CMM_SERVICE_STATS);
            meInfo.setName("SAML1.0 Service");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, meInfo);
            amSAML10SAMLSvcStats = (CMM_ServiceStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SERVICE_ACCESS_URI_STATS);
            meInfo.setName("SAML1.0 POST Profile servlet");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10PostProfileUri, relInfo, meInfo);
            amSAML10SAMLPOSTProfileUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setName("SAML1.0 SAMLAware servlet");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10SAMLAwareUri, relInfo, meInfo);
            amSAML10SAMLAwareUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setName("SAML1.0 SAMLSOAP receiver");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10SOAPReceiverUri, relInfo, meInfo);
            amSAML10SAMLSOAPRcvrUriStats = (CMM_ServiceAccessURIStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE);
            meInfo.setName("SAML1.0 Assertion cache");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSAML10AssertionCacheElement = (CMM_SWRCacheInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, (CIM_ManagedElementInstrum)amSAML10AssertionCacheElement);
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_STATS);
            meInfo.setName("SAML1.0 Assertion cache stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10AssertionCacheElement, relInfo, meInfo);
            amSAML10AssertionCacheStats = (CMM_SWRCacheStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_SETTING);
            meInfo.setName("SAML1.0 Assertion cache setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10AssertionCacheElement, relInfo, meInfo);
            amSAML10AssertionCacheSetting = (CMM_SWRCacheSettingInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE);
            meInfo.setName("SAML1.0 Artifact cache");
            relInfo.setType(MfRelationType.CMM_RESOURCE_OF_SYSTEM);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amAppli, relInfo, meInfo);
            amSAML10ArtifactCacheElement = (CMM_SWRCacheInstrum)mRI.getDestination();
            relInfo.setType(MfRelationType.CMM_SERVICE_RESOURCE);
            mRI = mfMEServer.createRelation((CIM_ManagedElementInstrum)amSvcSAML10, relInfo, (CIM_ManagedElementInstrum)amSAML10ArtifactCacheElement);
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_STATS);
            meInfo.setName("SAML1.0 Artifact cache stats");
            relInfo.setType(MfRelationType.CMM_ELEMENT_STATISTICAL_DATA);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10ArtifactCacheElement, relInfo, meInfo);
            amSAML10ArtifactCacheStats = (CMM_SWRCacheStatsInstrum)mRI.getDestination();
            meInfo.setType(MfManagedElementType.CMM_SWR_CACHE_SETTING);
            meInfo.setName("SAML1.0 Artifact cache setting");
            relInfo.setType(MfRelationType.CMM_SCOPED_SETTING);
            mRI = mfMEServer.createRelationToNewManagedElement((CIM_ManagedElementInstrum)amSAML10ArtifactCacheElement, relInfo, meInfo);
            amSAML10ArtifactCacheSetting = (CMM_SWRCacheSettingInstrum)mRI.getDestination();
            MonitoringSAMLv1.initStats();
        }
        catch (MfManagedElementServerException mmese) {
            Monitoring.debug.error("createSAMLv1: " + mmese.getMessage());
        }
        catch (MfRelationInstrumException mrie) {
            Monitoring.debug.error("createSAMLv1: " + mrie.getMessage());
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("createSAMLv1:from initStats(): " + mmeie.getMessage());
        }
        return 0;
    }

    public static void initAttributes() {
    }

    private static void initStats() throws MfManagedElementInstrumException {
        MonitoringUtils.initSWRCacheStats(amSAML10ArtifactCacheStats, "SAML 1.0");
        MonitoringUtils.initSWRCacheStats(amSAML10AssertionCacheStats, "SAML 1.0");
        MonitoringUtils.initSvcStats(amSAML10SAMLSOAPReceiverStats, "SAML 1.0");
        MonitoringUtils.initSvcStats(amSAML10SAMLAwareStats, "SAML 1.0");
        MonitoringUtils.initSvcStats(amSAML10SAMLPostProfileStats, "SAML 1.0");
    }

    public static void setStatus(OperationalStatus status) {
        HashSet<OperationalStatus> samlStatus = new HashSet<OperationalStatus>();
        samlStatus.add(status);
        if (amSvcSAML10 == null) {
            return;
        }
        try {
            amSvcSAML10.setOperationalStatus(samlStatus);
            if (amSAML10PostProfileUri != null) {
                amSAML10PostProfileUri.setOperationalStatus(samlStatus);
            }
            if (amSAML10SAMLAwareUri != null) {
                amSAML10SAMLAwareUri.setOperationalStatus(samlStatus);
            }
            if (amSAML10SOAPReceiverUri != null) {
                amSAML10SOAPReceiverUri.setOperationalStatus(samlStatus);
            }
            if (Monitoring.debug.messageEnabled()) {
                Monitoring.debug.message("MonitoringSAMLv1:setStatus = " + status);
            }
        }
        catch (MfManagedElementInstrumException mmeie) {
            Monitoring.debug.error("MonitoringSAMLv1:setStatus:error = " + mmeie.getMessage());
        }
    }

    public static CMM_ServiceStatsInstrum getSAMLv1SvcStats() {
        return amSAML10SAMLSvcStats;
    }

    public static CMM_ServiceStatsInstrum getSAMLv1PostProfileStats() {
        return amSAML10SAMLPostProfileStats;
    }

    public static CMM_ServiceStatsInstrum getSAMLv1SAMLAwareStats() {
        return amSAML10SAMLAwareStats;
    }

    public static CMM_ServiceStatsInstrum getSAMLv1SOAPRcvrStats() {
        return amSAML10SAMLSOAPReceiverStats;
    }

    protected static CMM_ServiceInstrum getSvcSAMLv1() {
        return amSvcSAML10;
    }
}

